
import excel "raw/ExpectationsSPF.xlsx", sheet("PCEF5") firstrow clear

gen yq = yq(YEAR, QUARTER)

replace pcef5 = "" if pcef5 == "#N/A"

destring pcef5, replace
gen ym = mofd(dofq(yq))
format ym %tm
tsset ym, monthly

tsfill
gen yline = 0.1

local threshold=0.1

format yq %tqCCYY

drop if pcef5 == .

gen target = 2
drop ym
gen ym = mofd(dofq(yq))
format ym %tmCCYY
foreach var of varlist pcef5 {
	local _var = upper("`var'")
	
	twoway (line target yq, sort lcolor(black) lpattern(dash)) (line `var' yq, sort lcolor(maroon) lwidth(thick)) (line target yq, sort lcolor(black) lpattern(dash)), name(fig_4a, replace) graphregion(color(white)) plotregion(color(white)) legend(off) title("") note("") xtitle("") ytitle("") yscale(r(1.5 3)) ylabel(1.5(0.5)3)
	gr export output/fig_4a.png, as(png) replace
}

