preserve

import delimited "raw/SelicBCB.csv", rowrange(2) clear

split v1, p(";")
tostring v2, replace

*correcting for csv formatting issues
gen _aux = v12 + "." + v2

replace v2 = _aux

drop v12
drop v1
rename v11 v1

split v1, p("/")
drop if v12 == ""

destring v1*, replace
rename v11 day
rename v12 month
rename v13 year

gen mdy = mdy(month, day, year)

format mdy %td

gen ym = mofd(mdy)

keep if year >= 2000

rename v2 policy_rate
destring policy_rate, replace
collapse (last) policy_rate, by(year month ym)

merge 1:1 year month using data/dichotomous.dta, nogen

format ym %tmCCYY
drop if year > 2023
replace dichotomous_upper = 30 if dichotomous_upper != . | ym >= ym(2022,08)
replace dichotomous_lower = 0 if dichotomous_lower >= ym(2022,08)
twoway (rarea dichotomous_upper dichotomous_lower ym, sort acolor(gray%40) cmissing(n)) (line policy_rate ym, sort lcolor(navy) lwidth(thin)), name(fig_3b, replace) graphregion(color(white)) plotregion(color(white)) ytitle("") legend(order(2 "Policy Rate" 1 "Unanchored") region(lstyle(none))) title("") xtitle("") yscale(range(0 30)) ylabel(#4) 
gr export output/fig_3b.png, as(png) replace


restore