preserve
local codes DEXBZUS
local labls `" "Brazil daily exchange rate" "'
local var_names exchange_rate

import delimited "raw/ExchangeRate", clear
label variable dexbzus "Brazil daily exchange rate"
rename dexbzus exchange_rate

split date, p("/")
destring date*, replace

rename date3 year
rename date1 month
rename date2 day

gen mdy = mdy(month, day, year)
format mdy %tdCCYY

gen ym = ym(year, month)


merge m:1 year month using data/dichotomous.dta, nogen

keep if year >= 2000

summ exchange_rate
replace dichotomous_upper = 8 if dichotomous_upper != . | ym >= ym(2022,08)
replace dichotomous_lower = 0 if dichotomous_lower >= ym(2022,08)

twoway (rarea dichotomous_upper dichotomous_lower mdy, sort acolor(gray%40) cmissing(n)) (line exchange_rate mdy, sort lcolor(navy) lwidth(thin)), name(fig_3a, replace) graphregion(color(white)) plotregion(color(white)) ytitle("") legend(order(2 "Exchange Rate" 1 "Unanchored") region(lstyle(none))) title("") xtitle("") yscale(range(0 `_max')) ylabel(#4) 
gr export output/fig_3a.png, as(png) replace

restore