

****Let's import the IPCA data
import delimited "raw/IPCA.csv", varnames(1) clear
split date, p("/")
drop if date2 == ""
destring *, replace
rename date1 month
rename date2 year
rename broadnationalconsumerpriceindexi ipcainflation
save data/brazil_inflation.dta, replace


***Let's import the interval bands and target from the target table
preserve
import excel using raw/BCBTargets.xlsx, firstrow clear

drop if Date == ""
split Date, p("/")
destring Date*, replace
rename Date2 day
rename Date3 year
gen month = 6
drop Date*

gen Date = mdy(month, day, year)
split ToleranceInterval, p("-")
replace Target = subinstr(Target, ",", ".", .)

rename ToleranceInterval1 l_limit
rename ToleranceInterval2 u_limit
rename Target target
destring *, replace

gen target_month = 1
replace target_month = month if Target_year == year
gen ym_target = ym(Target_year, target_month)
gen ym = ym(year, month)

sort ym
quietly bysort ym_target:  gen dup = cond(_N==1,0,_n)

drop if dup == 1
drop dup

tsset ym_target, monthly
tsfill

local vars l_limit u_limit target
foreach var in `vars' {
	qui levelsof ym_target, local(dates)
	foreach date in `dates' {
		qui summ `var' if ym_target == `date'
		if r(mean) != . {
		    local _value = r(mean)
		}
		qui replace `var' = `_value' if ym_target == `date'
	}
}

keep ym_target `vars'

gen year = year(dofm(ym_target))
gen month = month(dofm(ym_target))
save data/bank_targets_figure_bra.dta, replace
restore

merge 1:1 year month using data/bank_targets_figure_bra.dta, nogen

summ ipcainflation

gen ym = ym(year, month)
keep if year >= 2000
format ym %tmCCYY
local graph_options legend(order (1 "Target" 2 "Tolerance Band" 4 "IPCA inflation") c(3) region(lstyle(none))) graphregion(color(white) lstyle(none)) plotregion(color(white)) title("", size(medium)) note("") xtitle("") name(fig_1, replace)
twoway (line target ym, sort lcolor(black)) (line l_limit ym, sort lcolor(black) lpattern(dash)) (line u_limit ym, sort lcolor(black) lpattern(dash)) (line ipcainflation ym, sort lcolor(navy) lwidth(thick)), `graph_options'

gr export output/fig_1.png, as(png) replace
