*Creating the correlation table

gen dev_mean_24_36 = mean_24_36-Meta2436


local aggs mean
foreach agg in `aggs' {
gen `agg'_debt_5_1 = `agg'_debt_5 - `agg'_debt_1
gen `agg'_debt_8_1 = `agg'_debt_8 - `agg'_debt_1
}

*Calculate 30 day changes based on completed forecasts
local change_vars mean_debt_5_1 mean_debt_8_1 dev_mean_24_36
foreach var of varlist `change_vars' {
	gen d30_`var' = .
	sort mdy
	qui levelsof mdy if `var' != ., local(dates)
	local i = 0
	foreach day in `dates' {
		local j = `i'+30
		local end_date: word `j' of `dates'
		
		qui cap summ `var' if mdy == `day'
		local start_val = r(mean)
		*di "`start_val'; `day'"
		qui cap sum `var' if mdy == `end_date'
		local end_val = r(mean)
		qui cap replace d30_`var' = `end_val'-`start_val' if mdy == `end_date'
		local i = `i'+1
	}
}

gen period = ""
label var period "period"

local period_regs `"  "01222018-08312021" "09012021-01182023" "10032022-01182023"  "'
local newey_lag = 5

local mods  `" ""   "d30_"      "'
local names `"  "Levels" "One month change"   "'
local varnames `"  "Levels" "One_month_change"   "'
local horizons 5_1 8_1
local aggs mean


*Calculate standard errors using newey with 5 lags. Calculate correlations using R squared statistic from newey lag 0 (equivalent to reg y x, vce(robust))
*Quieting display verifications for output readability.
foreach agg in `aggs' {
	foreach h in `horizons' {
	preserve
	tsset mdy, daily
	local i = 1
		foreach mod in `mods' {
		    local _name: word `i' of `varnames'
			local _label: word `i' of `names'
			gen `_name' = ""
			label var `_name' "`_label'"
			local p = 0
			foreach period in `period_regs' {
			    local p = `p'+1
			    local month_start = substr("`period'", 1, 2)
				local day_start = substr("`period'", 3, 2)
				local year_start = substr("`period'", 5, 4)
				local month_end = substr("`period'", 10, 2)
				local day_end = substr("`period'", 12, 2)
				local year_end = substr("`period'", 14, 4 )
				
				qui replace period = "`month_start'/`day_start'/`year_start' - `month_end'/`day_end'/`year_end'" if _n == `p'
				*di "Analyzing period: `month_start'/`day_start'/`year_start' --- `month_end'/`day_end'/`year_end'"
				qui newey `mod'dev_mean_24_36 `mod'`agg'_debt_`h' if mdy>= mdy(`month_start', `day_start', `year_start') & mdy <= mdy(`month_end', `day_end', `year_end'), lag(`newey_lag') force
				*di "restriction: if mdy>= mdy(`month_start', `day_start', `year_start') & mdy <= mdy(`month_end', `day_end', `year_end')"
				
				local pval = (2 * ttail(e(df_r), abs(_b[`mod'`agg'_debt_`h']/_se[`mod'`agg'_debt_`h'])))
				qui reg `mod'dev_mean_24_36 `mod'`agg'_debt_`h' if mdy>= mdy(`month_start', `day_start', `year_start') & mdy <= mdy(`month_end', `day_end', `year_end'), vce(robust)
				local _r2 = e(r2)
				local corr = `_r2'^(1/2)
				local corr = round(`corr', 0.01)
				
				if `pval' <= 0.01 {
				  		qui replace `_name' = "`corr'***" if _n == `p'				
				}
				if `pval' > 0.01 & `pval' <= 0.05 {
				  		qui replace `_name' = "`corr'**" if _n == `p'				
				}
				if `pval' > 0.05 & `pval' <= 0.10 {
				  		qui replace `_name' = "`corr'*" if _n == `p'			
				}
				if `pval' > 0.1 {
				  		qui replace `_name' = "`corr'" if _n == `p'				
				}
				*di "`p'"
			}
			local i = `i'+1
		}
	keep period Levels One_month*
	order period Levels One_month*
	drop if period == ""
	export excel using output/correlation_table_`newey_lag'.xlsx, sheet("`agg'; H= `h'", replace) firstrow(varlabels)
	restore	
	}    
}