*do fig appendix a2_c
local excels `"  "brazil_policy" "colombia_policy" "chile_policy" "s_africa_policy"    "us_policy"  "mexico_policy" "india_policy"   "'

local countrynames `"  "Brazil"     "Colombia"         "Chile"        "South Africa"          "US"             "Mexico"         "India"   "'

local names_sheets
foreach sheet in `excels' {
    import excel using raw/`sheet', describe
	local name = r(worksheet_1)
	local range = r(range_1)
	di "`range'"
	di "`name'"
	local range = subinstr("`range'", "A1", "A6", 1)
	import excel using raw/`sheet', firstrow clear cellrange(`range')
	gen country = "`name'"
	local name = subinstr("`name'", " ", "_", .)
	save data/`name'_br_policy.dta, replace
	local names_sheets `names_sheets' `name'_br_policy

}

local counter = 1
foreach data in `names_sheets' {
    if `counter' == 1 {
	    use data/`data'.dta, clear
	}
	else {
	    append using data/`data'.dta
	}
	local counter = `counter' + 1
}

rename PX_LAST policy_rate_bloomberg
encode country, g(c1)

gen ym = mofd(Date)
format ym %tm

preserve
keep if ym >= ym(2019,01)
levelsof country, local(countries)
format ym %tmCCYY
local colors green maroon sandb olive_teal dkorange cranberry navy 

local counter = 1
local graph_command twoway
local order_legend
foreach country in `countries' {
	di "`forecast_month'"
	local color: word `counter' of `colors'
	if "`country'" == "Brazil" {
	    	local graph_command `graph_command' (line policy_r ym if country == "`country'", sort lwidth(thick) lcolor(`color'))
	}
	else {
	    	local graph_command `graph_command' (line policy_r ym if country == "`country'", sort lwidth(medium) lcolor(`color'))
	}
	local order_legend `counter' "`country'" `order_legend'
	local counter = `counter'+1
}
local graph_options legend(order(`order_legend') ring(0) position(10) bmargin(large) c(3) region(lstyle(none)) symxsize(*0.5)) graphregion(color(white)) plotregion(color(white)) title("", size(medium)) note("") xtitle("") ytitle("") name(fig_appendix_2c, replace)
`graph_command', `graph_options'
restore

gr export output/fig_appendix_2c.png, as(png) replace

*******************************************************************************