import excel raw/bcb_calculations.xlsx, sheet("credit_liquidity") clear firstrow
replace country = "UK" if country == "United Kingdom"
replace country = "US" if country == "United States"

encode country, g(c1)

foreach var of varlist liquidity credit {
    replace `var' = 0 if `var' == .
	replace `var' = `var'*100
}
replace liquidity = liquidity + credit

format liquidity %12.0f
format credit %12.0f

twoway (bar liquidity c1, barw(0.5) color(navy%20) sort) (bar liquidity c1 if country == "Brazil", barw(0.5) bcolor(green%20)) (bar credit c1, barw(0.5) color(navy) sort) (bar credit c1 if country == "Brazil", barw(0.5) bcolor(green)), legend(order(1 "Liquidity Support" 3 "Credit Support") region(lstyle(none)) ring(0) position(1) bmargin(large)) graphregion(color(white)) plotregion(color(white)) title("", size(medium)) note("") xtitle("") ytitle("") xlabels(1(1)8, valuelabels alt) name(fig_appendix_2b, replace)
gr export output/fig_appendix_2b.png, as(png) replace