
import excel "raw/FiscalMeasuresDetailed.xlsx", sheet("Summary.Global_Sep1") cellrange(A6:AB210) firstrow clear
/*
Required variables:

	P: Health Sector
	Q: Non-Health Sector
	R: AS/DR
	
	V: Below the line
	W: Guarantees
	X Quasi-fiscal operations
	
	B: country
*/

rename B country

label var P "Health Sector"
label var Q "Non-Health Sector"
label var R "AS/DR"
label var U "Below the line"
label var W "Guarantees"
label var X "Quasi-fiscal operations"

keep country P Q R W X U

keep if country == "Japan" | country == "United Kingdom" | country == "United States" | country == "Brazil" | country == "Turkey" | country == "European Union" | country == "India" | country == "China" | country == "Russia" | country == "Indonesia" | country == "Mexico"
replace country = "US" if country == "United States"
replace country = "UK" if country == "United Kingdom"
replace country = "EU" if country == "European Union"

gen _sum = 0
local vars P Q R U W X
foreach var of varlist `vars' {
    replace `var' = 0 if `var' == .
}

forval i = 1/6 {
    local var: word `i' of `vars'
   	replace _sum = `var' + _sum
}
forval i = 2/6 {
    local var: word `i' of `vars'
	local j = `i'-1
	local var_b4: word `j' of `vars'
	di "`var'; `var_b4'"
    replace `var' = `var' + `var_b4'
}

sencode country, g(c1) gsort(-_sum)

twoway (bar X c1, barw(0.5) bcolor(orange%30) sort) (bar W c1, barw(0.5) bcolor(orange_red%40) sort) (bar U c1, sort barw(0.5) bcolor(maroon%80)) (bar R c1, barw(0.5) bcolor(ltblue) sort) (bar Q c1, barw(0.5) bcolor(ebblue) sort) (bar P c1, barw(0.5) bcolor(navy) sort), xlabels(1(1)11, valuelabels labsize(medium) alt) graphregion(color(white)) plotregion(color(white)) xtitle("") ytitle("") note("") title("") legend(region(lstyle(none)) ring(0) c(1) position(1) bmargin(large)) name(fig_appendix_2a, replace)
gr export output/fig_appendix_2a.png, as(png) replace