*Importing Fiscal Monitor Database

import delimited using "raw/GrossDebtByCountry.csv", clear

rename timeperiod year
rename countryname country
keep country year grossdebtofgdpg_xwdg_g01_gdp_pt

encode country, gen(c_id)

xtset c_id year, yearly

keep if year == 2019 | year == 2022

rename grossdebtofgdpg_xwdg_g01_gdp_pt debt


local keep_countries `"  "Brazil"  "United States"  "Mexico"  "Japan"  "United Kingdom"  "Chile"  "Colombia" "Canada"   "Germany"  "France"  "Italy" "Spain"  "Portugal"  "Australia" "South Africa" "Peru"  "'
gen _keep = 0
foreach country in `keep_countries' {
    replace _keep = 1 if country == "`country'"
}

keep if _keep == 1


reshape wide debt@, i(country) j(year)
replace country = "US" if country == "United States"
replace country = "UK" if country == "United Kingdom"
sencode country, g(c1) gsort(-debt2019)



twoway (bar debt2019 c1 if country == "Brazil", barw(0.5) bcolor(green) sort) (bar debt2019 c1 if country != "Brazil", barw(0.5) bcolor(navy) sort) (scatter debt2022 c1, mcolor(black) sort), xlabels(1(1)16, valuelabels labsize(mediumsmall) angle(45)) graphregion(color(white)) plotregion(color(white)) xtitle("") ytitle("") title("") legend(order(2 "2019" 3 "2022") c(1) region(lstyle(none)) ring(0) position(1) bmargin(large)) name(fig_appendix_1c, replace)

gr export output/fig_appendix_1c.png, as(png) replace