*Importing Fiscal Monitor Database and figure

import delimited using "raw/GrossDebt.csv", clear

rename timeperiod year
rename countryname country

keep country year grossdebtofgdpg_xwdg_g01_gdp_pt

local keep_countries `"  "Brazil"  "'
gen _keep = 0
foreach country in `keep_countries' {
    replace _keep = 1 if country == "`country'"
}

keep if _keep == 1

encode country, g(c1)
xtset c1 year, yearly

keep if year <= 2022

local debt_label: var label grossdebtofgdpg_xwdg_g01_gdp_pt
xtline grossdebtofgdpg_xwdg_g01_gdp_pt if country == "Brazil", overlay title("") subtitle("", size(small)) ytitle("") legend(off) name(fig_appendix_1b, replace) graphregion(color(white)) plotregion(color(white)) xtitle("")
gr export output/fig_appendix_1b.png, as(png) replace