****Let's create the master dataset


import excel "raw/Targets_2_3y.xlsx", sheet("2436 daily") firstrow clear
rename Ano year
rename Mes month
rename Date mdy
gen ym = mofd(mdy)
save data/unanchor_given_update.dta, replace


import delimited "raw/ExpectationsFocus.csv", clear
split data, p("/")
destring data*, replace
rename data1 month
rename data2 day
rename data3 year


gen mdy = mdy(month, day, year)
format %td mdy
sort mdy

rename datareferencia forecasted_year

gen year_dif = forecasted_year- year
local start_year 2003
local end_year 2025
local counter=1
gen counter = .
forval yr = `start_year'/`end_year' {
	replace counter	= `counter' if forecasted_year==`yr'
	local counter= `counter'+1
}


foreach var of varlist _all {
    local _type: type `var'
	local _type = substr("`_type'", 1, 3)
	if "`_type'" == "str" {
		replace `var' = "" if `var' == "null"
		replace `var' = subinstr(`var', ",", ".", .)

	}
}

destring _all, replace
drop if forecasted_year<year

keep if basecalculo==0
keep mdy media year_dif

reshape wide media, i(mdy) j(year_dif)
gen year = year(mdy)
gen month = month(mdy)
gen ym = ym(year, month)


***Correcting for inconsistent formatting in the csv
foreach var of varlist media* {
    replace `var' = `var'/10 if mdy >= mdy(3,31,2021) & `var' >= 20
}


local vars media
local translate mean
forval i = 1/1 {
	local _var: word `i' of `vars'
	local _translate: word `i' of `translate'
	forval j = 0/4 {
		rename `_var'`j' `_translate'`j'
	}
}

merge 1:1 mdy using data/unanchor_given_update.dta, nogen


***************************Now let's create the dichotomous regions*********************************
preserve
collapse (mean) mean* (last) Upper2436 Meta2436, by(year month) 

foreach var of varlist Upper2436 Meta2436 {
	summ `var' if year >= 2022
	replace `var' = r(mean) if year >= 2022
}

local vars mean
foreach _var in `vars' {
	gen `_var'_24_36 = (12-(month-1))/12*`_var'2+((month-1)/12)*`_var'3 if year >= 2002
}

gen marina_credib_mean_24_36 = ((1-(1/(Upper2436-Meta2436))*(mean_24_36-Meta2436)))
replace marina_credib_mean_24_36 = 0 if marina_credib_mean_24_36 <0
replace marina_credib_mean_24_36 = 1 if marina_credib_mean_24_36 >1

gen Unanc_BR_CPI_Marinav2 = 1-marina_credib_mean_24_36
replace Unanc_BR_CPI_Marinav2 = . if year < 2002

gen dichotomous_upper = .
replace dichotomous_upper = 1 if Unanc_BR_CPI_Marinav2>0.1
gen dichotomous_lower = 0

gen yline = 0.1


replace dichotomous_upper = . if year < 2002




gen ym = ym(year, month)

keep year month dichotomous* yline
save data/dichotomous.dta, replace
restore


local vars mean
foreach _var in `vars' {
	gen `_var'_24_36 = (12-(month-1))/12*`_var'2+((month-1)/12)*`_var'3
}


foreach var of varlist Upper2436 Lower2436 Meta2436 {
	summ `var' if year >= 2022
	replace `var' = r(mean) if year >= 2022
}


gen credib_mean_24_36 = ((1-(1/(Upper2436-Meta2436))*(mean_24_36-Meta2436)))
replace credib_mean_24_36 = 0 if credib_mean_24_36 <0
replace credib_mean_24_36 = 1 if credib_mean_24_36 >1

gen Unanc_BR_IDX = 1-credib_mean_24_36

drop if mean_24_36 == .
save data/inflation_master.dta, replace



