/*******************************************************************************
This code replicates Table ##: Sudden Stops in EMs 

*******************************************************************************/

clear
set more off
cls
clear matrix
clear mata 
set maxvar 8000

//Change this directory depending who is running the code
cap cd "Replication_pkg/Data_programs/Data"  


use "LP_data", clear

/*******************************************************************************
Check units
*******************************************************************************/
replace i_treasury_12m_avg_US=i_treasury_12m_avg_US/100

/*******************************************************************************
Drop hard pegs
*******************************************************************************/
drop if IRR_coarse==1
drop if IRR_coarse==6

/*******************************************************************************
Drop LICS+ 
*******************************************************************************/
drop if IMF_incomeLevel==3
drop if Name=="Bolivia"
drop if Name=="Cambodia"
drop if Name=="Dominican Republic"
drop if Name=="Jamaica"
drop if Name=="Mongolia"
drop if Name=="Nicaragua"


/*
Define dependent variables:
Exchange rate depreciation (qtoq)
Change in reserves (q to q)
GDP growth(y to y)
Investment growth (y to y)
Current account balance/GDP 
*/
xtset IFS_code time_q 
g ler=ln(ER_avg_IFS) 
g double g_er=100*(D.ler) //ER q to q
g lgdp=ln(rGDPsa_weo)
g double g_gdp=100*(ln(rGDPsa_weo)-ln(l4.rGDPsa_weo)) //y to y
g aux=FXI_reserves*nGDPnsa_USD 
g g_reserves=ln(aux)-ln(l.aux) //q to q 
g g_inv=100*(ln(rInv)-ln(l4.rInv)) // y to y
g g_tb=100*(trade_balance_GDP-l.trade_balance_GDP) //change in trade balance 

/*
Panel regression
*/
g t1=0 if time_q==tq(2020q1)
replace t1=time_q-tq(2020q1) if time_q>tq(2020q1)

g t2=0 if time_q==tq(2021q4)
replace t2=time_q-tq(2021q4) if time_q>tq(2021q4)

local i=1
foreach var of varlist g_er g_gdp g_inv g_tb{
	eststo reg_`i': reghdfe `var' i.t1 if t1<=4 & EM==1, absorb(IFS_code)
	local i=`i'+1
}


esttab reg_* using "../../Figures/Tables/Sudden_StopsB.tex" , replace keep(*.t*) drop(*0.t*) cells(b(fmt(3) star) t(par fmt(2))) ///
varlabels(1.t "Quarter 1" 2.t "Quarter 2" 3.t "Quarter 3" 4.t "Quarter 4") ///
collabel(none) star(* 0.1 ** 0.05 *** 0.01) stat(N r2_a) ///
mtitle("Exchange rate depreciation" "GDP growth" "Investment growth" "Trade balance/GDP")



local i=1
foreach var of varlist g_er g_gdp g_inv g_tb{
	eststo reg_`i': reghdfe `var' i.t2 if t2<=4 & EM==1, absorb(IFS_code)
	local i=`i'+1
}


esttab reg_* using "../../Figures/Tables/Sudden_StopsB_2021.tex", replace keep(*.t*) drop(*0.t*) cells(b(fmt(3) star) t(par fmt(2))) ///
varlabels(1.t "Quarter 1" 2.t "Quarter 2" 3.t "Quarter 3" 4.t "Quarter 4") ///
collabel(none) star(* 0.1 ** 0.05 *** 0.01) stat(N r2_a) ///
mtitle("Exchange rate depreciation" "GDP growth" "Investment growth" "Trade balance/GDP")




