cap log close
cap drop _all
set more off
# delimit ;
log using make_Table2.log, replace;
/* Create Table 2:  mortality by ICD-10 category, by education category(ED), 2000-2019 and 2019-2021    */
/* This takes major ICD-10 cause of death categories (COD) one at a time, and also all-cause mortality (Trate) */
/* And reports differences for those with no BA (ED==1) and with a BA (ED==3)                 */
/* Men and women together. Mortality rates are for 25-84 year olds, age adjusted to 2000 population*/
/* PART ONE of the table is for the change between 2000 and 2019 */
/* PART TWO of the table is for the change between 2019 and 2021 */

use c:\users\accase\dropbox\acc_asd_projects\bpea_fall_2023\data\Table2.dta;
d;

/******** PART ONE OF THE TABLE ********************************/
/** differences and D-in-D calculations 2000 to 2019  **********/

keep if year==2019|year==2000;

foreach var in U X C J I G K E F V N A W T     {;
ren `var'rate `var'rate_ ;
};
keep year ED *rate_ ;
reshape wide *rate_, i(year) j(ED);


/*************************************************************************************************/
/** NOTE: suffix "_3" is for BA, "_1" is noBA , 'var'dif is the difference between them         **/
/** for each COD: The first row listed below is for 2000 (columns 1-3 of Table 2)    *************/
/** for each COD: The second row listed below is for 2019 (columns 4-6 of Table 2)   *************/
/*************************************************************************************************/

foreach var in U X C J I G K E F V N A W T     {;
gen `var'dif= `var'rate_1-`var'rate_3 ;
list year `var'rate_3 `var'rate_1 `var'dif ;
};


/* second differences: columns 7-9 of Table 2 */
gen one=1;
reshape wide *dif *rate_1 *rate_3, i(one) j(year);

foreach var in U X C J I G K E F V N A W T     {;
gen `var'BAdif = `var'rate_32019-`var'rate_32000 ;
gen `var'noBAdif = `var'rate_12019 - `var'rate_12000;
gen `var'DD = `var'noBAdif - `var'BAdif ;
list `var'BAdif `var'noBAdif `var'DD;
};

/*************************************************************************/
/******** SUMMING UP FOR TABLE Part One **********************************/
/* this is row "Total Above" in Table 2 for all of these COD together    */
/*************************************************************************/

use c:\users\accase\dropbox\acc_asd_projects\bpea_fall_2023\data\Table2.dta, clear;
keep if year==2000|year==2019;

foreach var in U X C J I G K E F V N A W      {;
ren `var'rate `var'rate_ ;
};
keep year ED *rate_ ;
reshape wide *rate_, i(year) j(ED);

foreach var in U X C J I G K E F V N A W      {;
gen `var'dif= `var'rate_1-`var'rate_3 ;
};

gen partialsum_1 = 0;
gen partialsum_3 = 0;
gen partdif = 0 ;

foreach var in U X C J I G K E F V N A W      {;
replace partialsum_1 = partialsum_1+`var'rate_1 ;
replace partialsum_3 = partialsum_3+`var'rate_3 ;
replace partdif = partdif + `var'dif ;
};
/* "Total Above" line for BAs */
tab year, sum(partialsum_3);
/* "Total Above" line for non-BAs */
tab year, sum(partialsum_1);
/* "Total Above" line for the difference */
tab year, sum(partdif );
keep year part* ;


/* second differences */
gen one=1;
reshape wide part* , i(one) j(year);
gen partBAdif = partialsum_32019-partialsum_32000;
gen partnoBAdif = partialsum_12019-partialsum_12000;
gen partDD= partnoBAdif-partBAdif;

/* "Total Above" line for the change from 2000 to 2019 */
list partBAdif partnoBAdif partDD;

/******** END SUMMING UP FOR TABLE Part One ***********************/
/*******END PART ONE OF THE TABLE *********************************/



/**********************************************************************/
/*******PART TWO OF THE TABLE *****************************************/
/* last 3 columns of Table 2: change for BAs, for non-BAs, and D-in-D */
/* Here we report only the changes from 2019 to 2021                  */
/**********************************************************************/

use c:\users\accase\dropbox\acc_asd_projects\bpea_fall_2023\data\Table2.dta, clear;

keep if year==2021|year==2019;

foreach var in U X C J I G K E F V N A W T     {;
ren `var'rate `var'rate_ ;
};
keep year ED *rate_ ;
reshape wide *rate_, i(year) j(ED);


foreach var in U X C J I G K E F V N A W T     {;
gen `var'dif= `var'rate_1-`var'rate_3 ;
};

/* second differences */
gen one=1;
reshape wide *dif *rate_1 *rate_3, i(one) j(year);



foreach var in U X C J I G K E F V N A W T     {;
gen `var'BAdif = `var'rate_32021-`var'rate_32019 ;
gen `var'noBAdif = `var'rate_12021 - `var'rate_12019;
gen `var'DD = `var'noBAdif - `var'BAdif ;
list `var'BAdif `var'noBAdif `var'DD;
};



log close;
