cap log close
cap drop _all
set more off
# delimit ;
log using make_Table1.log, replace;
/* Create Table 1:  mortality by cause by education category(ED),  1992-2019 and 2019-2021    */
/* This takes 11 major causes of death (COD) one at a time, and also all-cause mortality      */
/* And reports differences for those with no BA (ED==1) and with a BA (ED==3)                 */
/* Men and women together. Mortality rates are for 25-84 year olds, age adjusted to 2000 population*/
/* PART ONE of the table is for the change between 1992 and 2019 */
/* PART TWO of the table is for the change between 2019 and 2021 */

use c:\users\accase\dropbox\acc_asd_projects\bpea_fall_2023\data\Table1.dta;
d;
keep if sex==0 ;


/******** PART ONE OF THE TABLE ********************************/
/** differences and D-in-D calculations 1992 to 2019  **********/

keep if year==2019|year==1992;

/* death of despair data */
gen DoDrate = Prate+Srate+Lrate ;
label var DoDrate "drugs, suicide, alcohol";

foreach var in T DoD C cvd resp D trans alz neph sept Assault COV  P S L       {;
ren `var'rate `var'rate_ ;
};
keep year ED *rate_ ;
reshape wide *rate_, i(year) j(ED);


/*************************************************************************************************/
/** NOTE: suffix "_3" is for BA, "_1" is noBA , 'var'dif is the difference between them         **/
/** for each COD: The first row listed below is for 1992 (columns 1-3 of Table 1)    *************/
/** for each COD: The second row listed below is for 2019 (columns 4-6 of Table 1)   *************/
/*************************************************************************************************/

foreach var in T DoD C cvd resp D trans alz neph sept Assault COV  P S L       {;
gen `var'dif= `var'rate_1-`var'rate_3 ;
list year `var'rate_3 `var'rate_1 `var'dif ;
};


/* second differences: columns 7-9 of Table 1 */
gen one=1;
reshape wide *dif *rate_1 *rate_3, i(one) j(year);

foreach var in T DoD C cvd resp D trans alz neph sept Assault COV  P S L       {;
gen `var'BAdif = `var'rate_32019-`var'rate_31992 ;
gen `var'noBAdif = `var'rate_12019 - `var'rate_11992;
gen `var'DD = `var'noBAdif - `var'BAdif ;
list `var'BAdif `var'noBAdif `var'DD;
};

/*************************************************************************/
/******** SUMMING UP FOR TABLE Part One **********************************/
/* this is row "Total Above" in Table 1 for all of these COD together    */
/*************************************************************************/

use c:\users\accase\dropbox\acc_asd_projects\bpea_fall_2023\data\Table1.dta, clear;
keep if sex==0 ;
keep if year==1992|year==2019;
gen DoDrate = Prate+Srate+Lrate;
drop Prate Srate Lrate;

foreach var in T DoD C cvd resp D trans alz neph sept Assault COV       {;
ren `var'rate `var'rate_ ;
};
keep year ED *rate_ ;
reshape wide *rate_, i(year) j(ED);

foreach var in DoD C cvd resp D trans alz neph sept Assault COV  {;
gen `var'dif= `var'rate_1-`var'rate_3 ;
};

gen partialsum_1 = 0;
gen partialsum_3 = 0;
gen partdif = 0 ;

foreach var in DoD C cvd resp D trans alz neph sept Assault COV       {;
replace partialsum_1 = partialsum_1+`var'rate_1 ;
replace partialsum_3 = partialsum_3+`var'rate_3 ;
replace partdif = partdif + `var'dif ;
};
/* "Total Above" line for BAs */
tab year, sum(partialsum_3);
/* "Total Above" line for non-BAs */
tab year, sum(partialsum_1);
/* "Total Above" line for the difference */
tab year, sum(partdif );
keep year part* ;


/* second differences */
gen one=1;
reshape wide part* , i(one) j(year);
gen partBAdif = partialsum_32019-partialsum_31992;
gen partnoBAdif = partialsum_12019-partialsum_11992;
gen partDD= partnoBAdif-partBAdif;

/* "Total Above" line for the change from 1992 to 2019 */
list partBAdif partnoBAdif partDD;

/******** END SUMMING UP FOR TABLE Part One ***********************/
/*******END PART ONE OF THE TABLE *********************************/




/**********************************************************************/
/*******PART TWO OF THE TABLE *****************************************/
/* last 3 columns of Table 1: change for BAs, for non-BAs, and D-in-D */
/* The Table reports only the changes from 2019 to 2021               */
/**********************************************************************/

use c:\users\accase\dropbox\acc_asd_projects\bpea_fall_2023\data\Table1.dta, clear;

keep if sex==0 ;
keep if year==2021|year==2019;
gen DoDrate= Prate+Srate+Lrate ;

foreach var in T DoD C cvd resp D trans alz neph sept Assault COV  P S L       {;
ren `var'rate `var'rate_ ;
};
keep year ED *rate_ ;
reshape wide *rate_, i(year) j(ED);


foreach var in T DoD C cvd resp D trans alz neph sept Assault COV  P S L       {;
gen `var'dif= `var'rate_1-`var'rate_3 ;
};

/* second differences */
gen one=1;
reshape wide *dif *rate_1 *rate_3, i(one) j(year);



foreach var in T DoD C cvd resp D trans alz neph sept Assault COV  P S L       {;
gen `var'BAdif = `var'rate_32021-`var'rate_32019 ;
gen `var'noBAdif = `var'rate_12021 - `var'rate_12019;
gen `var'DD = `var'noBAdif - `var'BAdif ;
list `var'BAdif `var'noBAdif `var'DD;
};



log close;
