cap log close
set more off
clear
# delimit ;

log using graph_figure_10.log, replace ;

/* real wage data come from NBER/CEPR CPS Outgoing Rotation Groups data */
use c:\users\accase\dropbox\cepr_org\data\rw_ORG_1979_2019.dta;
keep if age>=25 & age<=64 ;
keep if year>=1992 ;

gen BA=educ>=4 & educ<=5;

drop if educ==.;
collapse (median) rw [aw=orgwgt], by(year BA) ;

reshape wide rw, i(year) j(BA);

/* create wage premium */
gen rw_premium = rw1/rw0 ;
*gr two line rw_premium year ;

tempfile tempwage ;
keep year rw_premium;
save `tempwage' ;

/* age-adjusted mortality rates for ages 25-64 come from NVSS files */
/* these are age-adjusted 25-64 rates for drugs+alcohol+suicide combined for 1992-2019 */
use ..\data\Figure10.dta ;
d;


reshape wide DoDrate, i(year) j(ED) ;
gen DoDratio = DoDrate1/DoDrate3 ;
keep DoDratio year;
merge 1:1 year using `tempwage' ;

/* create figure 10 */
gr two (line rw_premium year, lwidth(thick) lcolor(black))
       (line DoDratio year, lwidth(thick) lcolor(black) lpattern(shortdash) yaxis(2)),
legend(off) xtitle("") graphregion(color(white)) ;
log close;



