set more off
cap log close
clear
# delimit ;
/*** this can be used to graph either men or women. change sex==2 to sex==1  **/
use c:\users\accase\dropbox\acs\extract\wage_salary\faminc_1970_2021.dta;

/* This dataset contains individual records from the ACS, pulled from IPUMS            */
/* The records have year, sex, age and education                                       */
/* 34,349,992 records for adults aged 25-84 for years 2000-2019                        */
/* BA status is calculated for five-year birth cohorts using ACS sample weights, perwt */

keep if sex==2 ;
drop if year<2000;
drop if year>2019;
drop if age<25 ;
drop if age>84 ;

tab educ ;
gen BA= educ>=10 & educ<=11;
drop if educ==.;

gen yob=year-age;
gen YOB = 1940 if yob>=1940 & yob<=1944 ;
forval i = 1945(5)1970 {;
replace YOB=`i' if yob>=`i' & yob<=`i'+4 ;
};
keep if YOB!=. ;


collapse BA [aw=perwt], by(YOB age);

gr two (line BA age if YOB==1940 , lwidth(thick))
       (line BA age if YOB==1945 , lwidth(thick))
       (line BA age if YOB==1950 , lwidth(thick))
       (line BA age if YOB==1955 , lwidth(thick))
       (line BA age if YOB==1960 , lwidth(thick))
       (line BA age if YOB==1965 , lwidth(thick))
       (line BA age if YOB==1970 , lwidth(thick)),
legend(off) ytitle(fraction four-year college degree) xtitle(age)
ylabel(.2(.05).40)
title("Four-year college degree, women, by birth cohort", size(medlarge));

use ..\code_asd\Figure9.dta , clear ;
/* This dataset contains mortality counts and population counts
   by year, by single year of age, sex and BA-status */

keep if sex==2 ;
gen yob = year-age ;

gen YOB = 1940 if yob>=1940 & yob<=1944 ;
forval i = 1945(5)1970 {;
replace YOB=`i' if yob>=`i' & yob<=`i'+4 ;
};
keep if YOB!=. ;

bysort YOB age ED: egen TOTMORT = total(Tmort);
bysort YOB age ED: egen TOTPOP = total(population) ;
gen TRATE = (TOTMORT*100000)/TOTPOP;
bysort YOB age ED: keep if _n ==1;


keep YOB age ED TRATE ;
ren TRATE Trate ;
reshape wide Trate, i(YOB age) j(ED);
gen gap= Trate1-Trate3 ;
gen pctgap = gap/Trate0;


gr two (lpoly pctgap age if YOB==1940  , lwidth(thick) degree(2))
       (lpoly pctgap age if YOB==1945  , lwidth(thick) degree(2))
       (lpoly pctgap age if YOB==1950  , lwidth(thick) degree(2))
       (lpoly pctgap age if YOB==1955  , lwidth(thick) degree(2))
       (lpoly pctgap age if YOB==1960  , lwidth(thick) degree(2))
       (lpoly pctgap age if YOB==1965  , lwidth(thick) degree(2))
       (lpoly pctgap age if YOB==1970  , lwidth(thick) degree(2)),
legend(off) ytitle("deaths per 100,000")  xtitle(age)
title("All-cause mortality gap ratio, women with less than BA, by birth cohort", size(medlarge));
