set more off
cap log close
clear
log using graph_fig6_fig7_fig8.log, replace
/* this files demonstrates how to make Figures 6, 7 and 8 in the paper */
# delimit ;

/* this file can be used for graphing men or women by changing sex==1 to sex==2 in the command lines below */

use Table1.dta ;
gen PSL = Prate+Srate+Lrate;

/********* Figure 6 *********************************************************************/
*gr two (line cvdrate year if sex==2 & ED==3, lwidth(thick) lcolor(black) lpattern(shortdash))
       (line cvdrate year if sex==2 & ED==1, lwidth(thick) lcolor(black))
       (line PSL     year if sex==2 & ED==3, lwidth(thick) lcolor(black) lpattern(shortdash))
       (line PSL     year if sex==2 & ED==1, lwidth(thick) lcolor(black)),
legend(off) ytitle("deaths per 100,000") xtitle("") title(Women, color(black)) subtitle(CVD and Deaths of Despair)
ylabel(0(100)500);

*gr two (line Crate year if sex==2 & ED==3, lwidth(thick) lcolor(black) lpattern(shortdash))
       (line Crate year if sex==2 & ED==1, lwidth(thick) lcolor(black)),
legend(off) ytitle("deaths per 100,000") xtitle("") subtitle(Cancer)
ylabel(0(100)500);




/*********** Figure 7 and 8 *****************************************************************/
/* Figure 7 is for women, Figure 8 is for men. Note not all of their cancers are identical  */

*gr two (line lungCrate year if sex==2 & ED==3, lwidth(thick) lcolor(black) lpattern(shortdash))
       (line lungCrate year if sex==2 & ED==1, lwidth(thick) lcolor(black)),
legend(off) ytitle("deaths per 100,000") xtitle("") subtitle(Lung Cancer)
saving(fig7a.gph, replace) ;

*gr two (line  colCrate year if sex==2 & ED==3, lwidth(thick) lcolor(black) lpattern(shortdash))
       (line  colCrate year if sex==2 & ED==1, lwidth(thick) lcolor(black)),
legend(off) ytitle("deaths per 100,000") xtitle("") subtitle(Colon Cancer)
saving(fig7b.gph, replace) ;

*gr two (line livCrate year if sex==2 & ED==3, lwidth(thick) lcolor(black) lpattern(shortdash))
       (line livCrate year if sex==2 & ED==1, lwidth(thick) lcolor(black)),
legend(off) ytitle("")  xtitle("") subtitle(Liver Cancer)
saving(fig7c.gph, replace) ;

*gr two (line ovaCrate year if sex==2 & ED==3, lwidth(thick) lcolor(black) lpattern(shortdash))
       (line ovaCrate year if sex==2 & ED==1, lwidth(thick) lcolor(black)),
legend(off) ytitle("deaths per 100,000") xtitle("") subtitle(Ovarian Cancer)
saving(fig7d.gph, replace) ;

*r two (line breCrate year if sex==2 & ED==3, lwidth(thick) lcolor(black) lpattern(shortdash))
       (line breCrate year if sex==2 & ED==1, lwidth(thick) lcolor(black)),
legend(off) ytitle("")  xtitle("") subtitle(Breast Cancer)
saving(fig7e.gph, replace) ;


gr two (line panCrate year if sex==2 & ED==3, lwidth(thick) lcolor(black) lpattern(shortdash))
       (line panCrate year if sex==2 & ED==1, lwidth(thick) lcolor(black)),
legend(off) ytitle("")  xtitle("") subtitle(Pancreatic Cancer)
saving(fig7f.gph, replace) ;


*gr two (line lungCrate year if sex==1 & ED==3, lwidth(thick) lcolor(black) lpattern(shortdash))
       (line lungCrate year if sex==1 & ED==1, lwidth(thick) lcolor(black)),
legend(off) ytitle("deaths per 100,000") xtitle("") subtitle(Lung Cancer)
saving(fig8a.gph, replace) ;

*gr two (line  colCrate year if sex==1 & ED==3, lwidth(thick) lcolor(black) lpattern(shortdash))
       (line  colCrate year if sex==1 & ED==1, lwidth(thick) lcolor(black)),
legend(off) ytitle("deaths per 100,000") xtitle("") subtitle(Colon Cancer)
saving(fig8b.gph, replace) ;

*gr two (line livCrate year if sex==1 & ED==3, lwidth(thick) lcolor(black) lpattern(shortdash))
       (line livCrate year if sex==1 & ED==1, lwidth(thick) lcolor(black)),
legend(off) ytitle("")  xtitle("") subtitle(Liver Cancer)
saving(fig8c.gph, replace) ;

*r two (line proCrate year if sex==1 & ED==3, lwidth(thick) lcolor(black) lpattern(shortdash))
       (line proCrate year if sex==1 & ED==1, lwidth(thick) lcolor(black)),
legend(off) ytitle("deaths per 100,000") xtitle("") subtitle(Prostate Cancer)
saving(fig8d.gph, replace) ;


gr two (line panCrate year if sex==1 & ED==3, lwidth(thick) lcolor(black) lpattern(shortdash))
       (line panCrate year if sex==1 & ED==1, lwidth(thick) lcolor(black)),
legend(off) ytitle("")  xtitle("") subtitle(Pancreatic Cancer)
saving(fig8e.gph, replace) ;
 log close;
