set more off
cap log close
clear

# delimit ;
log using graph_Fig11_BRFSS_menthlth.log, replace ;
/* adding 2020 and 2021, which use 5-year age categories */
tempfile tempdat;
tempfile tempall;

use "C:\BRFSS\outfiles\combineBRFS_allrace.dta" ;
/* this is all races together */

gen BA= edclass==3 ;
drop if edclass==.;

gen ind30 = menthlth==30;
replace ind30=. if menthlth==. ;

drop if age<25 ;
drop if age>79 ;

collapse ind30 [aw=A_F], by(year age BA);
save `tempdat' ;

tempfile temp20;
use c:\brfss\infiles\llcp2020.dta ;
gen year=2020;
save `temp20';

use c:\brfss\infiles\llcp2021.dta ;
gen year=2021 ;
append using `temp20' ;

gen BA=educa==6;
drop if educa>6;

gen ind30 = 1 if menthlth==30;
replace ind30=0 if menthlth>=1 & menthlth<30;
replace ind30=0 if menthlth==88;
drop if ind30==. ;


gen age=_age80;
drop if age<25|age>79 ;

collapse ind30 [aw=_llcpwt], by(year age BA);
merge 1:1 year age BA using `tempdat';
drop _m;
save `tempdat', replace ;

merge m:1 age using "C:\Users\accase\Dropbox\ACC_ASD_projects\BPEA_Fall_2023\data\cdc_pop_by_age_2000.dta" ;
drop _m ;


drop if BA==.;
collapse ind30 [aw=population], by(year BA) ;
reshape wide ind30, i(year) j(BA);


gr two (line ind300 year , lwidth(thick) lcolor(black))
       (line ind301 year , lwidth(thick) lcolor(black) lpattern(longdash)), legend(off) xtitle("") ytitle("fraction");


gen ind30gap = ind300-ind301 ;
keep year ind30gap;

keep ind30gap year;
merge 1:1 year using Fig12_gaps  ;
drop _m ;
save Fig12_gaps, replace;

log close;

