cap log close
set more off
clear

# delimit ;
log using graph_fig11_NHIS.log , replace ;

tempfile tempwgt ;
tempfile temprate;

/* create NHIS age-adjusted report of pain and difficulty socializing for those aged 25-79   */
/* and BRFSS age-adjusted extreme distress ages 25-79 */

/* first make population weights to use in age adjustment */
/* The population figures come from CDC Wonder Bridged-Race Population Series for year 2000 */
/* available at: https://wonder.cdc.gov/bridged-race-population.html */

use c:\users\accase\dropbox\acc_asd_projects\bpea_fall_2023\data\cdc_pop_by_age_sex_2000;
keep if age>=25 & age<=79;

/* these data are by sex at each age. aggregate over sex */
bysort age: egen cdc_pop00=total(population)  ;
bysort age: keep if _n==1;
keep age cdc_pop00;
save `tempwgt' ;

/* second, make rates of pain and difficulty socialing  by year age ED from the NHIS*/
/* these data need to be pulled from the NHIS website:
   https://www.cdc.gov/nchs/nhis/data-questionnaires-documentation.htm  */
use c:\users\accase\dropbox\anne_nhis\data\allrace_addlvars_1997_2018.dta;

keep if age>=25  & age<=79;

/* we take 3 education class (LEHS, Some College, BA or more) make them into a "no BA, BA" variable */
gen ED=1 if edclass>=1 & edclass<=2;
replace ED=3 if edclass==3;
drop if edclass==.;

/* sciatic pain is lower back pain that spreads down a leg */
/* we recreate an indicator for it here */
drop ind_painsci;
gen ind_painsci=1 if painlb==1&painleg==1;
replace ind_painsci=0 if painlb==2|painleg==2;
gen PAIN = ind_painsci;

/* difficulty socializing is reporting more than "a little bit" of difficulty seeing friends, etc */
/* recreate an indicator for it here */
drop ind_flsoc ;
gen ind_flsoc=flsoc>1;
replace ind_flsoc=. if flsoc==.;
gen SOC=ind_flsoc;



/* first make pain and socializing rates for each year age ED cell, the make an AA2579 pain and soc measures */

collapse PAIN SOC [aw=wtfa_sa], by(year age ED);
ren PAIN PAINrate ;
ren SOC SOCrate;
merge m:1 age  using `tempwgt' ;
drop _m;


/* calculate age-adjusted rates of PAIN and SOC using SY rates */


collapse PAINrate SOCrate [aw=cdc_pop00], by(ED year) ;

reshape wide PAIN SOC, i(year ) j(ED) ;

/* this is Figure 11 - pain  **/
gr two (line PAINrate1 year, lwidth(thick) lcolor(black)) (line PAINrate3 year, lwidth(thick) lcolor(black) lpattern(longdash)),
legend(off) ytitle(fraction) xtitle("") title("Sciatic Pain") note(SOURCE: NHIS 1997-2018) saving(Fig11_pain.gph, replace) ;

/* this is Figure 11 - socializing **/
gr two (line SOCrate1 year, lwidth(thick) lcolor(black)) (line SOCrate3 year, lwidth(thick) lcolor(black) lpattern(longdash)),
legend(off) ytitle(fraction) xtitle("") title("Diffculty Socializing")note(SOURCE: NHIS 1997-2018) saving(Fig11_soc, replace) ;


/* save this for Figure 12 */

gen PAINgap = PAINrate1-PAINrate3 ;
gen SOCgap = SOCrate1-SOCrate3 ;

keep PAINgap SOCgap year;
save Fig12_gaps, replace;




log close;
