set more off
clear
cap log close
# delimit ;

log using Table3.log, replace ;
/* This takes age-adjusted all-cause mortality data by age group, originally drawn from NVSS,
   for years 1992, 2000, 2019 and 2021. Both sexes together.
   and population from Census Bureau for year 2000 to create Table 3*/

use Table3.dta ;
/* we will need mortality rates from year 2000 in column 7 */
tempfile tempdat;
keep if year==2000 & EDclass==0;
keep age_gp Trate ;
save `tempdat' ;


use Table3.dta;
/*col 1 of Table 3 */
tab age_gp, sum(popwt);

/* col 2 of Table 3 */
tab age_gp if year==2000 & ED==0, sum(Trate) ;

reshape wide Trate, i(year popwt age_gp) j(EDclass);
gen mortgap  = Trate1-Trate3;

/* col 3 of Table 3 */
tab age_gp if year==1992, sum(mortgap);

/* col 4 of Table 3 */
tab age_gp if year==2019, sum(mortgap);

/* col 5 of Table 3 */
tab age_gp if year==2021, sum(mortgap);

drop Trate*;

reshape wide mortgap, i(popwt age_gp) j(year) ;
gen Dmortgap9221 = mortgap2021-mortgap1992;

/*col 6 of Table 3 */
tab age_gp, sum(Dmortgap9221);

merge 1:1 age_gp using `tempdat' ;
gen mort_ratio = Dmortgap9221/Trate *100;

/* col 7 of Table 3 */
tab age_gp, sum(mort_ratio);

log close;

