set more off
cap log close
clear
log using faminc_mean_median.log, replace
# delimit ;
tempfile tempdat ;
tempfile temp86 ;

use c:\users\accase\dropbox\cepr_march\infiles2023\cpsmar82\cepr_march_1982.dta ;
keep year age fem educ hhid famno incf_all hhwgt  ;
save `temp86' ;

use c:\users\accase\dropbox\cepr_march\infiles2023\cpsmar84\cepr_march_1984.dta ;
keep year age fem educ hhid famno incf_all hhwgt  ;
append using `temp86';
save `temp86', replace ;

use c:\users\accase\dropbox\cepr_march\infiles2023\cpsmar86\cepr_march_1986.dta ;
keep year age fem educ hhid famno incf_all hhwgt  ;
append using `temp86';

/* get the year 1982-1986 ready to use with later data */
gen sex=fem+1 ;  drop fem;
tab educ ;
gen isBA = educ>=4 & educ<=5 ;
drop educ;
gen double serial = real(hhid);
ren famno famunit;
ren incf_all ftotinc ;

gen one=1 ;
bysort year serial famunit: egen famsize=total(one);
drop one;

keep year serial famunit famsize age isBA ftotinc hhwgt ;
ren hhwgt hhwt;
save `temp86', replace ;

use c:\users\accase\dropbox\cepr_march\nber_zip\cpsmar88\cpsmar88.dta ;
gen isBA88= educ>=16 & educ<=18 ;
drop educ;

append using c:\users\accase\dropbox\cepr_march\nber_zip\cpsmar98\cpsmar98.dta ;
append using c:\users\accase\dropbox\cepr_march\nber_zip\cpsmar96\cpsmar96.dta ;
append using c:\users\accase\dropbox\cepr_march\nber_zip\cpsmar94\cpsmar94.dta ;
append using c:\users\accase\dropbox\cepr_march\nber_zip\cpsmar92\cpsmar92.dta ;

gen double serial = real(h_idnum)  ;
ren ffpos famunit ;
ren ftot_rD ftotinc ;
ren hsup_wgt hhwt ;

gen isBA = educ>=43 & educ<=46;
replace isBA=isBA88 if year==1988 ;
drop isBA88 ;

ren educ educ98 ;
gen one=1;
bysort year serial famunit: egen famsize=total(one)  ;


keep year serial famunit famsize educ98 age isBA ftotinc hhwt ;
save `tempdat' ;
append using `temp86' ;
save `tempdat', replace;


use faminc_1970_2021.dta ;
/* these are data from ipums, only for those not living in GQ */
count if educ==. ;

gen isBA = educ>=10 & educ<=11;
append using `tempdat' ;


bysort year serial famunit: egen hasBA = max(isBA) ;

gen is017 = age>=0 & age<=17;
gen is18p = age>=18 & age<120 ;

bysort year serial famunit: egen n017 = total(is017);
bysort year serial famunit: egen n18p = total(is18p);
bysort year serial famunit: egen minage = min(age);
bysort year serial famunit: egen maxage = max(age);

drop if minage>74 ;
drop if maxage<18 ;

/*equivalent scale number of family members*/
gen eq = (n18p + .7*n017)^(.7);

bysort year serial famunit: keep if _n==1 ;

merge m:1 year using c:\users\accase\dropbox\acc_asd_projects\bpea_fall_2023\data\cpi_u_ann.dta ;
drop if _m !=3;
drop _m;

gen Rftotinc  = ftotinc/p ;
label var Rftotinc "ftotinc in $2012" ;

/* create faminc per member, and faminc per equivalent scale of members    */

gen Rftotinc_pc = Rftotinc /famsize ;
label var Rftotinc_pc "real family income per family member";

gen Rftotinc_eq = Rftotinc/eq ;
label var Rftotinc_eq "real family income per equivalence unit";


collapse (median) med_Rftotinc=Rftotinc (median) med_Rftotinc_pc=Rftotinc_pc (median) med_Rftotinc_eq=Rftotinc_eq [aw=hhwt],
         by(year hasBA) ;
gen census=1 if year==1970|year==1980|year==1990|year==2000;

gr two (line med_Rftotinc_eq year if hasBA==0, lwidth(thick))
       (line med_Rftotinc_eq year if hasBA==1, lwidth(thick))
       (sc   med_Rftotinc_eq year if hasBA==0 & year>=1992 & year<=1998, color(black))
       (sc   med_Rftotinc_eq year if hasBA==0 & year>=1982 & year<=1988, color(black))
       (sc   med_Rftotinc_eq year if hasBA==1 & year>=1992 & year<=1998, color(black))
       (sc   med_Rftotinc_eq year if hasBA==1 & year>=1982 & year<=1988, color(black))
       (sc   med_Rftotinc_eq year if hasBA==0 & census==1, color(midgreen))
       (sc   med_Rftotinc_eq year if hasBA==1 & census==1, color(midgreen)),
        legend(off) xtitle("") ytitle("median ($2012)")
        title("real family total income per equivalence unit($2012)", size(medium)) ;
log close;

