clear
close all
m=xlsread('FRBH41.xlsx','Sheet1','A2:L823');
dates=datenum(m(:,1),m(:,2),m(:,3));
m=0.1*m(:,4:11)./(m(:,12)*ones(1,8));  %Scale by nominal GDP
figure(1);
area(dates,m(:,[6 1 5 8]));
legend({'Currency','Reserves','Reverse Repo','Other'},'location','Northwest')
ylabel('Percent of Nominal GDP');
datetick('x','yyyy');
axis([min(dates) max(dates) 0 40])
clear
figure(2);
m=xlsread('projections.xlsx','Sheet1','J2:K20');
d=[2022.375:0.25:2026.875]';
plot(d,m(:,1),'Linewidth',2);
hold on
plot(d,m(:,2),'r--','Linewidth',2);
legend({'Treasuries','MBS'},'Fontsize',14,'Location','East');
ylabel('Percent of Nominal GDP','Fontsize',14);
axis([d(1) d(end) 4 24]);
xticks([2023 2024 2025 2026]);
clear
figure(3)
m=xlsread('gvlqusd.xlsx','Sheet1','A2:D944');
d=datenum(m(:,1),m(:,2),m(:,3));
plot(d,m(:,4),'Linewidth',3)
ylabel('Basis Points');
datetick('x','yyyy');
axis([min(d)-40 max(d)+40 0 4])
clear
figure(4)
m=xlsread('moasfncl.xlsx','Sheet1','A510:D3437');
d=datenum(m(:,1),m(:,2),m(:,3));
plot(d,m(:,4),'Linewidth',3)
ylabel('Basis Points');
datetick('x','yyyy');
axis([min(d)-40 max(d)+40 -40 160])
