%% Global dollar cycle

% Extract real gdp factor
% Haonan Zhou, 02/27/2022

% Revised 08/07/2022: add Costa Rica, Malaysia revision; revised EM groupings.
% Revised 06/30/2022: add EM-subset common factor

%% Housekeeping

clear all;
close all;
clc;

cd('/Users/haonanzhou/Dropbox (Princeton)/Research/globalcycle_brookings/replication');
addpath([pwd '/code/misc/output_factor/library/'])

iris.startup;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                                %% DATA CLEANING %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Load data
rgdp_1 = readtable('data/misc/rgdp_sa.xlsx', 'Sheet', 'RAW_SA');
rgdp_1 = convertvars(rgdp_1, @isdatetime, @(t) datetime(t, 'Format', 'dd/MM/yyyy'));
writetable(rgdp_1, 'data/misc/rgdp_sa_1.csv', 'Delimiter', ',');

rgdp_2 = readtable('data/misc/rgdp_sa.xlsx', 'Sheet', 'Spliced_SA', 'Range', 2);
rgdp_2 = convertvars(rgdp_2, @isdatetime, @(t) datetime(t, 'Format', 'dd/MM/yyyy'));
writetable(rgdp_2, 'data/misc/rgdp_sa_2.csv', 'Delimiter', ',');

rgdp_3 = readtable('data/misc/rgdp_sa.xlsx', 'Sheet', 'X13_SA');
rgdp_3 = convertvars(rgdp_3, @isdatetime, @(t) datetime(t, 'Format', 'dd/MM/yyyy'));
writetable(rgdp_3, 'data/misc/rgdp_sa_3.csv', 'Delimiter', ',');

rgdp_4 = readtable('data/misc/rgdp_sa.xlsx', 'Sheet', 'CR_SA');
rgdp_4 = convertvars(rgdp_4, @isdatetime, @(t) datetime(t, 'Format', 'dd/MM/yyyy'));
writetable(rgdp_4, 'data/misc/rgdp_sa_4.csv', 'Delimiter', ',');

clear;

rgdp_1 = dbload('data/misc/rgdp_sa_1.csv', 'DateFormat=', '01/MM/YYYY', 'Freq=', 4, 'LeadingRow=' , 'Date');
rgdp_2 = dbload('data/misc/rgdp_sa_2.csv', 'DateFormat=', '01/MM/YYYY', 'Freq=', 4, 'LeadingRow=' , 'Date');
rgdp_3 = dbload('data/misc/rgdp_sa_3.csv', 'DateFormat=', '01/MM/YYYY', 'Freq=', 4, 'LeadingRow=' , 'Date');
rgdp_4 = dbload('data/misc/rgdp_sa_4.csv', 'DateFormat=', '01/MM/YYYY', 'Freq=', 4, 'LeadingRow=' , 'Date');

rgdp_3 = rmfield(rgdp_3, 'Iran');
rgdp_3 = rmfield(rgdp_3, 'Malaysia');

% Combine into one single struct
rgdp = rgdp_1;

f2 = fieldnames(rgdp_2);
f3 = fieldnames(rgdp_3);
f4 = fieldnames(rgdp_4);

for k = 1:length(f2)
    rgdp.(f2{k}) = rgdp_2.(f2{k});
end

for k = 1:length(f3)
    rgdp.(f3{k}) = rgdp_3.(f3{k});
end

for k = 1:length(f4)
    rgdp.(f4{k}) = rgdp_4.(f4{k});
end

rgdp = orderfields(rgdp);

% sample is 1980-2019 (40 years)
date = datetime(1970,3,31):calquarters(1):datetime(2021,12,31);
date_sample = [datetime(1979,12,31), datetime(2019,12,31)];

sample_bool = date >= date_sample(1) & date <= date_sample(2);

% convert back to array, take log
rgdp_array = db2array(rgdp);
rgdp_array = rgdp_array(sample_bool, :);
logrgdp_array = 100 * log(rgdp_array);

% transform to 100 * D.log
dgdp = diff(logrgdp_array);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                                %% DFM %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Set blocks (ae / em)
block_raw = readtable('data/misc/rgdp_sa.xlsx', 'Sheet', 'INDEX', 'Range', 'I4:O90');
block_raw = block_raw([1 3:end], :);
block_aeem = table2array(block_raw(:, [1;6;7]));

nM = size(dgdp, 2);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                                %% DFM: EM sample only %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

em = block_aeem(:,3)' .* (1:size(block_aeem,1));
em = em(em ~= 0);
dgdp_em = dgdp(41:end, em); % start from 1990

nM = size(dgdp_em, 2);

%-------------------------------------------------------------------------
% set parameters

DFMinit.nM          =nM; %number of monthly variables
DFMinit.max_iter    =1000; %EM iterations
%

DFMinit.blocks      =ones(size(dgdp_em,2),1);

%--------------------------------------------------------------------------

DFMinit.r           =ones(1, size(DFMinit.blocks, 2)); %number of factors per block
DFMinit.p           =1; %number of lags in factors VAR
DFMinit.s           =1; %lags in idio dynamic

DFMend = EM_DHDFM_SS_block(dgdp_em,DFMinit,[]);

Factor_EM = DFMend.States(:,1);

rgdp_em = cumsum(Factor_EM);

date = datetime(1990,3,31):calquarters(1):datetime(2019,12,31);
date = date';

figure(1)
set(gca, 'FontSize', 16);
plot(date, normalize(rgdp_em), 'Linewidth', 2);
xlabel('Date');
ylabel('EM real GDP common factor (normalized)');
printpdf(gcf,'output/misc/em_demand.pdf');

% Output
output = table(date, normalize(rgdp_em));

writetable(output, 'output/misc/EM_demand.csv'); 
