*** THE GLOBAL DOLLAR CYCLE ***

* PANEL LOCAL PROJECTIONS: Dollar appreciation shocks *

* State-dependent local-projections *

clear all
set more off
cd "$masterpath"
set scheme s1color
graph drop _all
eststo clear

** read data **
use "data/lp/lp_data.dta", clear
xtset cid yq

/////////////////////////////////////////////////////////////////////
///////////////////// LOCAL PROJECTION: PREP ////////////////////////
/////////////////////////////////////////////////////////////////////

* generate change in the price level
cap drop pp
cap drop pi
gen pp = 100 * (p - l4.p) / l4.p		// % yoy change
gen pi = 100 * (cpi - l.cpi) / l.cpi	// % yoy change
replace pp = . if pp > 50 & pp < .
replace pi = . if pi > 50 & pi < .

* data in levels: log difference (quarterly)
local data_l rgdp rcons rgc rinv p cpi xr neer tot aeusd_g aeusd_avg broadusd_g ncredit_lc rexp rimp pexp pimp equity
foreach var in `data_l' {
    gen d`var' = 100 * log(`var' / l.`var')
}

* data in percentages: first difference in levels
local data_p fci rpol ffr ltrates kgdp shadow embi pp pi
foreach var in `data_p' {
    gen d`var' = d.`var'
}

* US monetary policy controls
* replace shadow rate with FFR before 2009
gen dmon = dshadow
replace dmon = dffr if year(dofq(yq)) <= 2008

* divide response variables into three buckets:
* national accounts: read gdp, private and government consumption, investment, 
* exports and imports
local res_na rgdp rcons rgc rinv rexp rimp

* price: gdp deflator, CPI, exchange rate, export/import prices, tot
local res_price pp pi xr pexp pimp tot

* interest rate, nominal credit
local res_int ncredit_lc equity rpol embi

local res_all `res_na' `res_price' `res_int'

** define variables included in the regressions **

* global factors
local r factor_em dmon dfci

* local controls
local q drgdp dxr drpol

* shock: dollar index against advanced economies (EOQ)
local x daeusd_g

* rescale shock size to 10%
replace daeusd_g = daeusd_g / 10
replace daeusd_avg = daeusd_avg / 10

* combine them
local w `r' `x' `q'

** Generate forward value ***
qui forval h=0/12 {
	foreach y of local res_all {
		cap drop `y'`h'
        if !inlist("`y'", "kgdp", "rpol", "ltrates", "embi", "pp", "pi") {
            gen `y'`h' = 100 * log(f`h'.`y' / l.`y')        // cumulative IRF
        }
        if inlist("`y'", "kgdp", "rpol", "ltrates", "embi", "pp", "pi") {
            gen `y'`h' = f`h'.`y' - l.`y'
        }	
	}
}

xtset cid yq
keep if year(dofq(yq)) <= 2019


////////// STATE-DEPENDENT LOCAL PROJECTIONS: PREP ////////////

* monetary regime
gen inf_targeting = .
replace inf_targeting = 1 if mon_policy == 3
replace inf_targeting = 0 if mon_policy != 3 & mon_policy < . 

gen `x'target = `x' * l4.inf_targeting		// lagged dummy by a year
gen `x'nt = `x' * (1 - l4.inf_targeting)

gen ltarget = l4.inf_targeting
gen lnt = 1 - l4.inf_targeting

* foreach var of varlist `r' {
* 	gen target`var' = ltarget * `var'
* 	gen nt`var' = lnt * `var'
* 	local interaction `interaction' target`var' nt`var'
* }

/////////////////////////////////////////////////////////////////////
///////////////////// LOCAL PROJECTION: LOOP ////////////////////////
/////////////////////////////////////////////////////////////////////

******* NATIONAL ACCOUNTS *******
foreach y of local res_na {

	cap drop b_* se_* Horizon
	cap drop h_* l_*
	gen b_nt_`y'=.
	gen h_nt_`y'=.
	gen l_nt_`y'=.
	gen se_nt_`y'=.
    gen b_target_`y'=.
	gen h_target_`y'=.
	gen l_target_`y'=.
	gen se_target_`y'=.

	gen Horizon = _n-1 if _n<=12+1

	eststo clear
	
	local max 12
	
	// Regression Loop
	forvalues h=0/`max' {	

		qui reghdfe `y'`h' `x'target `x'nt, vce(robust) /// 
            a(i.cid#i.ltarget i.cid#i.lnt i.ltarget#c.l(1/4).(`w') i.lnt#c.l(1/4).(`w') /// 
             i.ltarget#c.l(1/4).d`y' i.lnt#c.l(1/4).d`y' /// 
             i.ltarget#c.(`r') i.lnt#c.(`r'))
        * reghdfe `y'`h' `x'target `x'nt `interaction', vce(robust) /// 
        *     a(i.cid#i.ltarget i.cid#i.lnt i.ltarget#c.l(1/4).(`w') i.lnt#c.l(1/4).(`w') /// 
        *      i.ltarget#c.l(1/4).d`y' i.lnt#c.l(1/4).d`y')
		eststo h`h'mon
			
		qui replace  b_nt_`y'    =  _b[`x'nt]                 if _n == `h'+1
		qui replace se_nt_`y'    = _se[`x'nt]                 if _n == `h'+1	
		qui replace  l_nt_`y'    = _b[`x'nt]- _se[`x'nt] 		 if _n == `h'+1 	
		qui replace  h_nt_`y'    = _b[`x'nt]+ _se[`x'nt]  		 if _n == `h'+1

		qui replace  b_target_`y'    =  _b[`x'target]                 if _n == `h'+1
		qui replace se_target_`y'    = _se[`x'target]                 if _n == `h'+1	
		qui replace  l_target_`y'    = _b[`x'target]- _se[`x'target] 		 if _n == `h'+1 	
		qui replace  h_target_`y'    = _b[`x'target]+ _se[`x'target]  		 if _n == `h'+1
		
	}
		
	****** Output tables ******

    ** dollar **
    noisily esttab ///
		h0mon h3mon h6mon h9mon h12mon  ///
		, compress keep(`x'target `x'nt) b(%8.2f) se(%8.2f) title("`y'") mtitles nonum label /// 
		star(* 0.10 ** 0.05 *** 0.01)

	****** Export IRFs ******
	preserve
	keep if Horizon <= 12

    if "`y'" == "rgdp" local tname "real GDP"
    if "`y'" == "rcons" local tname "private consumption"
    if "`y'" == "rgc" local tname "government consumption"
    if "`y'" == "rinv" local tname "gross capital formation"
    if "`y'" == "rexp" local tname "real export"
    if "`y'" == "rimp" local tname "real import"

    local ytitle "100 x log"

	cap drop Zero
	gen Zero=0
	qui twoway ///
		(  rarea h_target l_target Horizon if Horizon~=. , fc(navy) fi(10) lcolor(white) lpattern(solid)  )  ///
		(  rarea h_nt l_nt Horizon if Horizon~=. , fc(ltblue) fi(100) lcolor(ltblue) lpattern(solid)  )  ///
		(  line  Zero    Horizon if Horizon~=. , lc(gray)  lw(medthin) lp(dash)                     )  ///		
		(  line  b_nt     Horizon if Horizon~=. , lc(ebblue)   lw(thick) lp(solid)                 )    ///
		(  line  b_target     Horizon if Horizon~=. , lc(red)   lw(thick) lp(solid)                     ///
				xtitle("Quarter") xlab(0(4)12) ///
				ytitle("`ytitle'") ///
				legend(order(4 "Other regimes" 5 "Inflation targeting") row(2))  /// 
																				          )  ///
		, title("`tname'") name(`y'mon)
	*

	local res_namon `res_namon' `y'mon
	*
	restore
	**
}

gr combine `res_namon', row(2)
gr export  "$outputpath/dollar_na_monetary.pdf", replace


******* PRICES *******
foreach y of local res_price {

	cap drop b_* se_* Horizon
	cap drop h_* l_*
	gen b_nt_`y'=.
	gen h_nt_`y'=.
	gen l_nt_`y'=.
	gen se_nt_`y'=.
    gen b_target_`y'=.
	gen h_target_`y'=.
	gen l_target_`y'=.
	gen se_target_`y'=.

	gen Horizon = _n-1 if _n<=12+1

	eststo clear
	
	local max 12
	
	// Regression Loop
	forvalues h=0/`max' {	

		qui reghdfe `y'`h' `x'target `x'nt, vce(robust) /// 
            a(i.cid#i.ltarget i.cid#i.lnt i.ltarget#c.l(1/4).(`w') i.lnt#cl(1/4).(`w') /// 
              i.ltarget#c.l(1/4).d`y' i.lnt#c.l(1/4).d`y' /// 
              i.ltarget#c.(`r') i.lnt#c.(`r'))
        eststo h`h'mon
			
		qui replace  b_nt_`y'    =  _b[`x'nt]                 if _n == `h'+1
		qui replace se_nt_`y'    = _se[`x'nt]                 if _n == `h'+1	
		qui replace  l_nt_`y'    = _b[`x'nt]- _se[`x'nt] 		 if _n == `h'+1 	
		qui replace  h_nt_`y'    = _b[`x'nt]+ _se[`x'nt]  		 if _n == `h'+1

		qui replace  b_target_`y'    =  _b[`x'target]                 if _n == `h'+1
		qui replace se_target_`y'    = _se[`x'target]                 if _n == `h'+1	
		qui replace  l_target_`y'    = _b[`x'target]- _se[`x'target] 		 if _n == `h'+1 	
		qui replace  h_target_`y'    = _b[`x'target]+ _se[`x'target]  		 if _n == `h'+1
		
	}
		
	****** Output tables ******

    ** dollar **
    noisily esttab ///
		h0mon h3mon h6mon h9mon h12mon  ///
		, compress keep(`x'target `x'nt) b(%8.2f) se(%8.2f) title("`y'") mtitles nonum label /// 
		star(* 0.10 ** 0.05 *** 0.01)

	****** Export IRFs ******
	preserve
	keep if Horizon <= 12

    if "`y'" == "p" local tname "GDP deflator"
    if "`y'" == "cpi" local tname "consumer price"
	if "`y'" == "pp" local tname "GDP deflator change"
    if "`y'" == "pi" local tname "consumer price inflation"
    if "`y'" == "xr" local tname "exchange rate (LC/USD)"
    if "`y'" == "pexp" local tname "export price"
    if "`y'" == "pimp" local tname "import price"
    if "`y'" == "tot" local tname "terms of trade"

    local ytitle "100 x log"
	if inlist("`y'", "pp", "pi") local ytitle "pp yoy"

	cap drop Zero
	gen Zero=0
	qui twoway ///
		(  rarea h_target l_target Horizon if Horizon~=. , fc(navy) fi(10) lcolor(white) lpattern(solid)  )  ///
		(  rarea h_nt l_nt Horizon if Horizon~=. , fc(ltblue) fi(100) lcolor(ltblue) lpattern(solid)  )  ///
		(  line  Zero    Horizon if Horizon~=. , lc(gray)  lw(medthin) lp(dash)                     )  ///		
		(  line  b_nt     Horizon if Horizon~=. , lc(ebblue)   lw(thick) lp(solid)                 )    ///
		(  line  b_target     Horizon if Horizon~=. , lc(red)   lw(thick) lp(solid)                     ///
				xtitle("Quarter") xlab(0(4)12) ///
				ytitle("`ytitle'") ///
				legend(order(4 "Other regimes" 5 "Inflation targeting") row(2))  /// 
																				          )  ///
		, title("`tname'") name(`y'mon)
	*

	local res_pricemon `res_pricemon' `y'mon
	*
	restore
	**
}

gr combine `res_pricemon', row(2)
gr export  "$outputpath/dollar_price_monetary.pdf", replace


******* CREDIT AND INTEREST RATES *******
foreach y of local res_int {

	cap drop b_* se_* Horizon
	cap drop h_* l_*
	gen b_nt_`y'=.
	gen h_nt_`y'=.
	gen l_nt_`y'=.
	gen se_nt_`y'=.
    gen b_target_`y'=.
	gen h_target_`y'=.
	gen l_target_`y'=.
	gen se_target_`y'=.

	gen Horizon = _n-1 if _n<=12+1

	eststo clear
	
	local max 12
	
	// Regression Loop
	forvalues h=0/`max' {	

		qui reghdfe `y'`h' `x'target `x'nt, vce(robust) /// 
            a(i.cid#i.ltarget i.cid#i.lnt i.ltarget#cl(1/4).(`w') i.lnt#c.l(1/4).(`w') /// 
              i.ltarget#c.l(1/4).d`y' i.lnt#c.l(1/4).d`y' /// 
              i.ltarget#c.(`r') i.lnt#c.(`r'))
        eststo h`h'mon
			
		qui replace  b_nt_`y'    =  _b[`x'nt]                 if _n == `h'+1
		qui replace se_nt_`y'    = _se[`x'nt]                 if _n == `h'+1	
		qui replace  l_nt_`y'    = _b[`x'nt]- _se[`x'nt] 		 if _n == `h'+1 	
		qui replace  h_nt_`y'    = _b[`x'nt]+ _se[`x'nt]  		 if _n == `h'+1

		qui replace  b_target_`y'    =  _b[`x'target]                 if _n == `h'+1
		qui replace se_target_`y'    = _se[`x'target]                 if _n == `h'+1	
		qui replace  l_target_`y'    = _b[`x'target]- _se[`x'target] 		 if _n == `h'+1 	
		qui replace  h_target_`y'    = _b[`x'target]+ _se[`x'target]  		 if _n == `h'+1
		
	}
		
	****** Output tables ******

    ** dollar **
    noisily esttab ///
		h0mon h3mon h6mon h9mon h12mon  ///
		, compress keep(`x'target `x'nt) b(%8.2f) se(%8.2f) title("`y'") mtitles nonum label /// 
		star(* 0.10 ** 0.05 *** 0.01)

	****** Export IRFs ******
	preserve
	keep if Horizon <= 12

    if "`y'" == "ncredit_lc" local tname "nominal credit (LC)"
    if "`y'" == "rpol" local tname "policy rate"
    if "`y'" == "ltrates" local tname "long-term rate (LC)"
    if "`y'" == "embi" local tname "EMBI spread"
	if "`y'" == "equity" local tname "equity price (LC)"
    
    local ytitle "pp"
    if "`y'" == "ncredit_lc" local ytitle "100 x log"
	if "`y'" == "equity" local ytitle "100 x log"

	cap drop Zero
	gen Zero=0
	qui twoway ///
		(  rarea h_target l_target Horizon if Horizon~=. , fc(navy) fi(10) lcolor(white) lpattern(solid)  )  ///
		(  rarea h_nt l_nt Horizon if Horizon~=. , fc(ltblue) fi(100) lcolor(ltblue) lpattern(solid)  )  ///
		(  line  Zero    Horizon if Horizon~=. , lc(gray)  lw(medthin) lp(dash)                     )  ///		
		(  line  b_nt     Horizon if Horizon~=. , lc(ebblue)   lw(thick) lp(solid)                 )    ///
		(  line  b_target     Horizon if Horizon~=. , lc(red)   lw(thick) lp(solid)                     ///
				xtitle("Quarter") xlab(0(4)12) ///
				ytitle("`ytitle'") ylab(#3) ///
				legend(order(4 "Other regimes" 5 "Inflation targeting") row(2))  /// 
																				          )  ///
		, title("`tname'") name(`y'mon)
	*

	local res_intmon `res_intmon' `y'mon
	*
	restore
	**
}

gr combine `res_intmon', row(2)
gr export  "$outputpath/dollar_int_monetary.pdf", replace


******* PUBLISHED VERSION: 6 selected variables *******
gr combine rgdpmon rinvmon ppmon xrmon equitymon rpolmon, col(3)
gr export  "$outputpath/dollar_pub_monetary.pdf", replace


graph drop _all