*** THE GLOBAL DOLLAR CYCLE ***

* PANEL LOCAL PROJECTIONS: Dollar appreciation shocks *

* State-dependent local-projections *

clear all
set more off
cd "$masterpath"
set scheme s1color
graph drop _all
eststo clear

** read data **
use "data/lp/lp_data.dta", clear
xtset cid yq

/////////////////////////////////////////////////////////////////////
///////////////////// LOCAL PROJECTION: PREP ////////////////////////
/////////////////////////////////////////////////////////////////////

* generate change in the price level
cap drop pp
cap drop pi
gen pp = 100 * (p - l4.p) / l4.p		// % yoy change
gen pi = 100 * (cpi - l.cpi) / l.cpi	// % yoy change
replace pp = . if pp > 50 & pp < .
replace pi = . if pi > 50 & pi < .

* data in levels: log difference (quarterly)
local data_l rgdp rcons rgc rinv p cpi xr neer tot aeusd_g aeusd_avg broadusd_g ncredit_lc rexp rimp pexp pimp equity
foreach var in `data_l' {
    gen d`var' = 100 * log(`var' / l.`var')
}

* data in percentages: first difference in levels
local data_p fci rpol ffr ltrates kgdp shadow embi pp pi
foreach var in `data_p' {
    gen d`var' = d.`var'
}

* US monetary policy controls
* replace shadow rate with FFR before 2009
gen dmon = dshadow
replace dmon = dffr if year(dofq(yq)) <= 2008

* divide response variables into three buckets:
* national accounts: read gdp, private and government consumption, investment, 
* exports and imports
local res_na rgdp rcons rgc rinv rexp rimp

* price: gdp deflator, CPI, exchange rate, export/import prices, tot
local res_price pp pi xr pexp pimp tot

* equity, interest rate, nominal credit
local res_int ncredit_lc equity rpol embi

local res_all `res_na' `res_price' `res_int'

** define variables included in the regressions **

* global factors
local r factor_em dmon dfci

* local controls
local q drgdp dxr drpol

* shock: dollar index against advanced economies (EOQ)
local x daeusd_g

* rescale shock size to 10%
replace daeusd_g = daeusd_g / 10
replace daeusd_avg = daeusd_avg / 10

* combine them
local w `r' `x' `q'

** Generate forward value ***
qui forval h=0/12 {
	foreach y of local res_all {
		cap drop `y'`h'
        if !inlist("`y'", "kgdp", "rpol", "ltrates", "embi", "pp", "pi") {
            gen `y'`h' = 100 * log(f`h'.`y' / l.`y')        // cumulative IRF
        }
        if inlist("`y'", "kgdp", "rpol", "ltrates", "embi", "pp", "pi") {
            gen `y'`h' = f`h'.`y' - l.`y'
        }	
	}
}

xtset cid yq
keep if year(dofq(yq)) <= 2019


////////// STATE-DEPENDENT LOCAL PROJECTIONS: PREP ////////////

* currency exposure through dollar (dummies: above or below median, pooled sample)
gcollapse (median) medianexposure = L_USD_GDP, merge fast
gen highexp = (L_USD_GDP > medianexposure & L_USD_GDP < .)
replace highexp = . if L_USD_GDP == .

* gen netusd = A_debt_USD_GDP - L_debt_USD_GDP
* gen highexp = (netusd < 0)
* replace highexp = . if netusd == .

gen `x'highexp = `x' * l4.highexp		// lagged dummy by a year
gen `x'lowexp = `x' * (1 - l4.highexp)

gen lhighdollar = l4.highexp
gen llowdollar = 1 - l4.highexp


******* NATIONAL ACCOUNTS *******
foreach y of local res_na {

	cap drop b_* se_* Horizon
	cap drop h_* l_*
	gen b_high_`y'=.
	gen h_high_`y'=.
	gen l_high_`y'=.
	gen se_high_`y'=.
    gen b_low_`y'=.
	gen h_low_`y'=.
	gen l_low_`y'=.
	gen se_low_`y'=.

	gen Horizon = _n-1 if _n<=12+1

	eststo clear
	
	local max 12
	
	// Regression Loop
	forvalues h=0/`max' {	

		qui reghdfe `y'`h' `x'highexp `x'lowexp, vce(robust) /// 
            a(i.cid#i.lhighdollar i.cid#i.llowdollar i.lhighdollar#c.l(1/4).(`w') i.llowdollar#c.l(1/4).(`w') /// 
             i.lhighdollar#c.l(1/4).d`y' i.llowdollar#c.l(1/4).d`y' /// 
             i.lhighdollar#c.(`r') i.llowdollar#c.(`r'))
        * reghdfe `y'`h' `x'target `x'nt `interaction', vce(robust) /// 
        *     a(i.cid#i.ltarget i.cid#i.lnt i.ltarget#c.l(1/4).(`w') i.lnt#c.l(1/4).(`w') /// 
        *      i.ltarget#c.l(1/4).d`y' i.lnt#c.l(1/4).d`y')
		eststo h`h'curr
			
		qui replace  b_low_`y'    =  _b[`x'lowexp]                 if _n == `h'+1
		qui replace se_low_`y'    = _se[`x'lowexp]                 if _n == `h'+1	
		qui replace  l_low_`y'    = _b[`x'lowexp]- _se[`x'lowexp] 		 if _n == `h'+1 	
		qui replace  h_low_`y'    = _b[`x'lowexp]+ _se[`x'lowexp]  		 if _n == `h'+1

		qui replace  b_high_`y'    =  _b[`x'highexp]                 if _n == `h'+1
		qui replace se_high_`y'    = _se[`x'highexp]                 if _n == `h'+1	
		qui replace  l_high_`y'    = _b[`x'highexp]- _se[`x'highexp] 		 if _n == `h'+1 	
		qui replace  h_high_`y'    = _b[`x'highexp]+ _se[`x'highexp]  		 if _n == `h'+1
		
	}
		
	****** Output tables ******

    ** dollar **
    noisily esttab ///
		h0curr h3curr h6curr h9curr h12curr  ///
		, compress keep(`x'highexp `x'lowexp) b(%8.2f) se(%8.2f) title("`y'") mtitles nonum label /// 
		star(* 0.10 ** 0.05 *** 0.01)

	****** Export IRFs ******
	preserve
	keep if Horizon <= 12

    if "`y'" == "rgdp" local tname "real GDP"
    if "`y'" == "rcons" local tname "private consumption"
    if "`y'" == "rgc" local tname "government consumption"
    if "`y'" == "rinv" local tname "gross capital formation"
    if "`y'" == "rexp" local tname "real export"
    if "`y'" == "rimp" local tname "real import"

    local ytitle "100 x log"

	cap drop Zero
	gen Zero=0
	qui twoway ///
		(  rarea h_high l_high Horizon if Horizon~=. , fc(navy) fi(10) lcolor(white) lpattern(solid)  )  ///
		(  rarea h_low l_low Horizon if Horizon~=. , fc(ltblue) fi(100) lcolor(ltblue) lpattern(solid)  )  ///
		(  line  Zero    Horizon if Horizon~=. , lc(gray)  lw(medthin) lp(dash)                     )  ///		
		(  line  b_low     Horizon if Horizon~=. , lc(ebblue)   lw(thick) lp(solid)                 )    ///
		(  line  b_high     Horizon if Horizon~=. , lc(red)   lw(thick) lp(solid)                     ///
				xtitle("Quarter") xlab(0(4)12) ///
				ytitle("`ytitle'") ///
				legend(order(4 "Low dollar exposure" 5 "High dollar exposure") row(2))  /// 
																				          )  ///
		, title("`tname'") name(`y'currency)
	*

	local res_nacurrency `res_nacurrency' `y'currency
	*
	restore
	**
}

gr combine `res_nacurrency', row(2)
gr export  "$outputpath/dollar_na_currency.pdf", replace


******* PRICE *******
foreach y of local res_price {

	cap drop b_* se_* Horizon
	cap drop h_* l_*
	gen b_high_`y'=.
	gen h_high_`y'=.
	gen l_high_`y'=.
	gen se_high_`y'=.
    gen b_low_`y'=.
	gen h_low_`y'=.
	gen l_low_`y'=.
	gen se_low_`y'=.

	gen Horizon = _n-1 if _n<=12+1

	eststo clear
	
	local max 12
	
	// Regression Loop
	forvalues h=0/`max' {	

		qui reghdfe `y'`h' `x'highexp `x'lowexp, vce(robust) /// 
            a(i.cid#i.lhighdollar i.cid#i.llowdollar i.lhighdollar#c.l(1/4).(`w') i.llowdollar#c.l(1/4).(`w') /// 
             i.lhighdollar#c.l(1/4).d`y' i.llowdollar#c.l(1/4).d`y' /// 
             i.lhighdollar#c.(`r') i.llowdollar#c.(`r'))
        * reghdfe `y'`h' `x'target `x'nt `interaction', vce(robust) /// 
        *     a(i.cid#i.ltarget i.cid#i.lnt i.ltarget#c.l(1/4).(`w') i.lnt#c.l(1/4).(`w') /// 
        *      i.ltarget#c.l(1/4).d`y' i.lnt#c.l(1/4).d`y')
		eststo h`h'curr
			
		qui replace  b_low_`y'    =  _b[`x'lowexp]                 if _n == `h'+1
		qui replace se_low_`y'    = _se[`x'lowexp]                 if _n == `h'+1	
		qui replace  l_low_`y'    = _b[`x'lowexp]- _se[`x'lowexp] 		 if _n == `h'+1 	
		qui replace  h_low_`y'    = _b[`x'lowexp]+ _se[`x'lowexp]  		 if _n == `h'+1

		qui replace  b_high_`y'    =  _b[`x'highexp]                 if _n == `h'+1
		qui replace se_high_`y'    = _se[`x'highexp]                 if _n == `h'+1	
		qui replace  l_high_`y'    = _b[`x'highexp]- _se[`x'highexp] 		 if _n == `h'+1 	
		qui replace  h_high_`y'    = _b[`x'highexp]+ _se[`x'highexp]  		 if _n == `h'+1
		
	}
		
	****** Output tables ******

    ** dollar **
    noisily esttab ///
		h0curr h3curr h6curr h9curr h12curr  ///
		, compress keep(`x'highexp `x'lowexp) b(%8.2f) se(%8.2f) title("`y'") mtitles nonum label /// 
		star(* 0.10 ** 0.05 *** 0.01)

	****** Export IRFs ******
	preserve
	keep if Horizon <= 12

    if "`y'" == "p" local tname "GDP deflator"
    if "`y'" == "cpi" local tname "consumer price"
	if "`y'" == "pp" local tname "GDP deflator change"
    if "`y'" == "pi" local tname "consumer price inflation"
    if "`y'" == "xr" local tname "exchange rate (LC/USD)"
    if "`y'" == "pexp" local tname "export price"
    if "`y'" == "pimp" local tname "import price"
    if "`y'" == "tot" local tname "terms of trade"

    local ytitle "100 x log"
	if inlist("`y'", "pp", "pi") local ytitle "pp yoy"

	cap drop Zero
	gen Zero=0
	qui twoway ///
		(  rarea h_high l_high Horizon if Horizon~=. , fc(navy) fi(10) lcolor(white) lpattern(solid)  )  ///
		(  rarea h_low l_low Horizon if Horizon~=. , fc(ltblue) fi(100) lcolor(ltblue) lpattern(solid)  )  ///
		(  line  Zero    Horizon if Horizon~=. , lc(gray)  lw(medthin) lp(dash)                     )  ///		
		(  line  b_low     Horizon if Horizon~=. , lc(ebblue)   lw(thick) lp(solid)                 )    ///
		(  line  b_high     Horizon if Horizon~=. , lc(red)   lw(thick) lp(solid)                     ///
				xtitle("Quarter") xlab(0(4)12) ///
				ytitle("`ytitle'") ///
				legend(order(4 "Low dollar exposure" 5 "High dollar exposure") row(2))  /// 
																				          )  ///
		, title("`tname'") name(`y'currency)
	*

	local res_pricecurrency `res_pricecurrency' `y'currency
	*
	restore
	**
}

gr combine `res_pricecurrency', row(2)
gr export  "$outputpath/dollar_price_currency.pdf", replace


******* CREDIT AND INTEREST RATES *******
foreach y of local res_int {

	cap drop b_* se_* Horizon
	cap drop h_* l_*
	gen b_high_`y'=.
	gen h_high_`y'=.
	gen l_high_`y'=.
	gen se_high_`y'=.
    gen b_low_`y'=.
	gen h_low_`y'=.
	gen l_low_`y'=.
	gen se_low_`y'=.

	gen Horizon = _n-1 if _n<=12+1

	eststo clear
	
	local max 12
	
	// Regression Loop
	forvalues h=0/`max' {	

		qui reghdfe `y'`h' `x'highexp `x'lowexp, vce(robust) /// 
            a(i.cid#i.lhighdollar i.cid#i.llowdollar i.lhighdollar#c.l(1/4).(`w') i.llowdollar#c.l(1/4).(`w') /// 
             i.lhighdollar#c.l(1/4).d`y' i.llowdollar#c.l(1/4).d`y' /// 
             i.lhighdollar#c.(`r') i.llowdollar#c.(`r'))
        * reghdfe `y'`h' `x'target `x'nt `interaction', vce(robust) /// 
        *     a(i.cid#i.ltarget i.cid#i.lnt i.ltarget#c.l(1/4).(`w') i.lnt#c.l(1/4).(`w') /// 
        *      i.ltarget#c.l(1/4).d`y' i.lnt#c.l(1/4).d`y')
		eststo h`h'curr
			
		qui replace  b_low_`y'    =  _b[`x'lowexp]                 if _n == `h'+1
		qui replace se_low_`y'    = _se[`x'lowexp]                 if _n == `h'+1	
		qui replace  l_low_`y'    = _b[`x'lowexp]- _se[`x'lowexp] 		 if _n == `h'+1 	
		qui replace  h_low_`y'    = _b[`x'lowexp]+ _se[`x'lowexp]  		 if _n == `h'+1

		qui replace  b_high_`y'    =  _b[`x'highexp]                 if _n == `h'+1
		qui replace se_high_`y'    = _se[`x'highexp]                 if _n == `h'+1	
		qui replace  l_high_`y'    = _b[`x'highexp]- _se[`x'highexp] 		 if _n == `h'+1 	
		qui replace  h_high_`y'    = _b[`x'highexp]+ _se[`x'highexp]  		 if _n == `h'+1
		
	}
		
	****** Output tables ******

    ** dollar **
    noisily esttab ///
		h0curr h3curr h6curr h9curr h12curr  ///
		, compress keep(`x'highexp `x'lowexp) b(%8.2f) se(%8.2f) title("`y'") mtitles nonum label /// 
		star(* 0.10 ** 0.05 *** 0.01)

	****** Export IRFs ******
	preserve
	keep if Horizon <= 12

    if "`y'" == "ncredit_lc" local tname "nominal credit (LC)"
    if "`y'" == "rpol" local tname "policy rate"
    if "`y'" == "ltrates" local tname "long-term rate (LC)"
    if "`y'" == "embi" local tname "EMBI spread"
	if "`y'" == "equity" local tname "equity price (LC)"
    
    local ytitle "pp"
    if "`y'" == "ncredit_lc" local ytitle "100 x log"
	if "`y'" == "equity" local ytitle "100 x log"

	cap drop Zero
	gen Zero=0
	qui twoway ///
		(  rarea h_high l_high Horizon if Horizon~=. , fc(navy) fi(10) lcolor(white) lpattern(solid)  )  ///
		(  rarea h_low l_low Horizon if Horizon~=. , fc(ltblue) fi(100) lcolor(ltblue) lpattern(solid)  )  ///
		(  line  Zero    Horizon if Horizon~=. , lc(gray)  lw(medthin) lp(dash)                     )  ///		
		(  line  b_low     Horizon if Horizon~=. , lc(ebblue)   lw(thick) lp(solid)                 )    ///
		(  line  b_high     Horizon if Horizon~=. , lc(red)   lw(thick) lp(solid)                     ///
				xtitle("Quarter") xlab(0(4)12) ///
				ytitle("`ytitle'") ylab(#3) ///
				legend(order(4 "Low dollar exposure" 5 "High dollar exposure") row(2))  /// 
																				          )  ///
		, title("`tname'") name(`y'currency)
	*

	local res_intcurrency `res_intcurrency' `y'currency
	*
	restore
	**
}

gr combine `res_intcurrency', row(2)
gr export  "$outputpath/dollar_int_currency.pdf", replace


******* PUBLISHED VERSION: 6 selected variables *******
gr combine rgdpcurrency rinvcurrency ppcurrency xrcurrency equitycurrency rpolcurrency, col(3)
gr export  "$outputpath/dollar_pub_currency.pdf", replace


graph drop _all