*** The global dollar cycle ***

** Part 2: Determinants of dollar exchange rate **
** Table 1: short rate **

clear all
set more off
global masterpath "~/Dropbox (Princeton)/Research/globalcycle_brookings/replication"
cd "$masterpath"
global outputpath "$masterpath/output/fx_reg"
set scheme s1color
graph drop _all

*** Some data preparation ***
use "data/fx_reg/dollar_reg_data.dta", clear
xtset cid ym
gen year = year(dofm(ym))

* rate differential, transformation
gen logVIX = 100 * log(VIXCLS)      // log difference will be in pp
gen tbdiff3m = USDtreas3m_c - treas3m_c   // use continuously compounded returns
gen tbdiff1y = USDtreas1y - treas1y
gen lambdadiff3m = (USDibor3m_c - USDtreas3m_c) - (ibor3m_c - treas3m_c)
gen lambdadiff1y = (USDibor1y_b - USDtreas1y) - (ibor1y_b - treas1y)
gen loghkm = 100 * log(1/icr)

* flip the signs for better interpretation
replace ciptreas3m = -ciptreas3m / 100   // to pp
replace cipibor3m = -cipibor3m / 100   // to pp
replace cipibor1y = -cipibor1y / 100
replace ciptreas1y = -ciptreas1y / 100

* log-transform real exchange rate
replace rer = 100 * log(rer)

* quarterly / yearly lags
gen lqst3m = l3.tbdiff3m          // short-term rate differential
gen lqvix = l3.logVIX
gen lqebp = l3.ebp
gen lqtreasbasis = l3.ciptreas3m
gen lqlambda = l3.lambdadiff3m    // liquidity premium
gen lqhkm = l3.loghkm
gen lqiborbasis = l3.cipibor3m

gen lyst1y = l12.tbdiff1y            // short-term rate differential
gen lyvix = l12.logVIX
gen lyebp = l12.ebp
gen lytreasbasis = l12.ciptreas1y
gen lylambda = l12.lambdadiff1y    // liquidity premium
gen lyhkm = l12.loghkm
gen lyiborbasis = l12.cipibor1y

gen lqrer = l3.rer
gen lyrer = l12.rer

preserve
** 3M horizon **
keep if year >= 1999 & year <= 2021

gen dst3m = tbdiff3m - lqst3m
gen dlambda3m = lambdadiff3m - lqlambda
gen dtreasbasis3m = ciptreas3m - lqtreasbasis
gen diborbasis3m = cipibor3m - lqiborbasis

gen dvix = logVIX - lqvix
gen debp = ebp - lqebp
gen dhkm = loghkm - lqhkm
gen lrer = lqrer

gen dst1y = .
gen dlambda1y = .
gen dtreasbasis1y = .
gen diborbasis1y = .

label variable dst3m "$\Delta (i_{3m,t}^{US} - i_{3m,t}^{*})$"
label variable dst1y "$\Delta (i_{1y,t}^{US} - i_{1y,t}^{*})$"
label variable dvix "$\Delta$ log VIX"
label variable debp "$\Delta$ excess bond premium"
label variable dlambda3m "$\Delta \gamma_{3m,t} $"
label variable dlambda1y "$\Delta \gamma_{1y,t} $"
label variable dhkm "$\Delta$ log primary dealer leverage"
label variable dtreasbasis3m "$\Delta$ 3-month treasury basis (pp)"
label variable diborbasis3m "$\Delta$ 3-month IBOR basis (pp)"
label variable dtreasbasis1y "$\Delta$ 1-year treasury basis (pp)"
label variable diborbasis1y "$\Delta$ 1-year IBOR basis (pp)"
label variable lrer "Lag RER"
label variable dep_3m "fc qoq depreciation"

local format = "label r2 adjr2 nonotes nocons keep(dst3m dst1y dlambda3m diborbasis3m dtreasbasis3m dlambda1y diborbasis1y dtreasbasis1y dvix debp  lrer) sortvar(dst3m dst1y dlambda3m diborbasis3m dtreasbasis3m dlambda1y diborbasis1y dtreasbasis1y dvix debp lrer)"
local text = "addtext(Currency FE, $\checkmark$, Lagged controls, $\checkmark$, \citet{dr98} lags, 3)"

local table = "$outputpath/tab_fx_st_3m"
cap erase "`table'.tex"
cap erase "`table'.txt"

* ivreghdfe dep_3m dst3m dlambda3m dvix debp lqst3m lqlambda lqvix lqebp lrer, a(cid) bw(3) cluster(ym)
* outreg2 using "`table'.tex", tex(frag) append `format' dec(3) `text' cttop("$\Delta =$ 3 months, 99-21")

ivreghdfe dep_3m dst3m dlambda3m diborbasis3m dvix debp lqst3m lqlambda lqiborbasis lqvix lqebp lrer, a(cid) bw(3) cluster(ym)
outreg2 using "`table'.tex", tex(frag) append `format' dec(3) `text' cttop("$\Delta =$ 3 months; 99-21")

ivreghdfe dep_3m dst3m dtreasbasis3m dvix debp lqst3m lqtreasbasis lqvix lqebp lrer, a(cid) bw(3) cluster(ym)
outreg2 using "`table'.tex", tex(frag) append `format' dec(3) `text' cttop("$\Delta =$ 3 months; 99-21")

* ivreghdfe dep_3m dst3m dlambda3m dvix debp lqst3m lqlambda lqvix lqebp lqhkm lrer if inrange(year, 2010,2021), a(cid) bw(3) cluster(ym)
* outreg2 using "`table'.tex", tex(frag) append `format' dec(3) `text' cttop("$\Delta =$ 3 months, 10-21")

ivreghdfe dep_3m dst3m dlambda3m diborbasis3m dvix debp lqst3m lqlambda lqiborbasis lqvix lqebp lrer if inrange(year, 2010,2021), a(cid) bw(3) cluster(ym)
outreg2 using "`table'.tex", tex(frag) append `format' dec(3) `text' cttop("$\Delta =$ 3 months; 10-21")

ivreghdfe dep_3m dst3m dtreasbasis3m dvix debp lqst3m lqtreasbasis lqvix lqebp lrer if inrange(year, 2010,2021), a(cid) bw(3) cluster(ym)
outreg2 using "`table'.tex", tex(frag) append `format' dec(3) `text' cttop("$\Delta =$ 3 months; 10-21")

cap erase "`table'.txt"

restore

preserve
** 1-year horizon
keep if year >= 1999 & year <= 2021

gen dst1y = tbdiff1y - lyst1y
gen dlambda1y = lambdadiff1y - lylambda
gen dtreasbasis1y = ciptreas1y - lytreasbasis
gen diborbasis1y = cipibor1y - lyiborbasis
gen dvix = logVIX - lyvix
gen debp = ebp - lyebp
gen dhkm = loghkm - lyhkm
gen lrer = lyrer

gen dst3m = .
gen dlambda3m = .
gen dtreasbasis3m = .
gen diborbasis3m = .

label variable dst3m "$\Delta (i_{3m,t}^{US} - i_{3m,t}^{*})$"
label variable dst1y "$\Delta (i_{1y,t}^{US} - i_{1y,t}^{*})$"
label variable dvix "$\Delta$ log VIX"
label variable debp "$\Delta$ excess bond premium"
label variable dlambda3m "$\Delta \gamma_{3m,t} $"
label variable dlambda1y "$\Delta \gamma_{1y,t} $"
label variable dhkm "$\Delta$ log primary dealer leverage"
label variable dtreasbasis3m "$\Delta$ 3-month treasury basis (pp)"
label variable diborbasis3m "$\Delta$ 3-month IBOR basis (pp)"
label variable dtreasbasis1y "$\Delta$ 1-year treasury basis (pp)"
label variable diborbasis1y "$\Delta$ 1-year IBOR basis (pp)"

label variable lrer "Lag RER"
label variable dep_1y "fc yoy depreciation"

local table = "$outputpath/tab_fx_st_1y"
cap erase "`table'.tex"
cap erase "`table'.txt"

local format = "label r2 adjr2 nonotes nocons keep(dst3m dst1y dlambda3m diborbasis3m dtreasbasis3m dlambda1y diborbasis1y dtreasbasis1y dvix debp  lrer) sortvar(dst3m dst1y dlambda3m diborbasis3m dtreasbasis3m dlambda1y diborbasis1y dtreasbasis1y dvix debp lrer)"
local text = "addtext(Currency FE, $\checkmark$, Lagged controls, $\checkmark$, \citet{dr98} lags, 12)"

* ivreghdfe dep_1y dst1y dlambda1y dvix debp dhkm lyst1y lylambda lyvix lyebp lyhkm lrer, a(cid) bw(12) cluster(ym)
* outreg2 using "`table'.tex", tex(frag) append `format' dec(3) `text' cttop("$\Delta =$ 1 year, 99-21")

ivreghdfe dep_1y dst1y dlambda1y diborbasis1y dvix debp lyst1y lylambda lyiborbasis lyvix lyebp lrer, a(cid) bw(12) cluster(ym)
outreg2 using "`table'.tex", tex(frag) append `format' dec(3) `text' cttop("$\Delta =$ 1 year; 99-21")

ivreghdfe dep_1y dst1y dtreasbasis1y dvix debp lyst1y lytreasbasis lyvix lyebp lrer, a(cid) bw(12) cluster(ym)
outreg2 using "`table'.tex", tex(frag) append `format' dec(3) `text' cttop("$\Delta =$ 1 year; 99-21")

* ivreghdfe dep_1y dst1y dlambda1y dvix debp dhkm lyst1y lylambda lyvix lyebp lyhkm lrer if inrange(year, 2010,2021), a(cid) bw(12) cluster(ym)
* outreg2 using "`table'.tex", tex(frag) append `format' dec(3) `text' cttop("$\Delta =$ 1 year, 10-21")

ivreghdfe dep_1y dst1y dlambda1y diborbasis1y dvix debp lyst1y lylambda lyiborbasis lyvix lyebp lrer if inrange(year, 2010,2021), a(cid) bw(12) cluster(ym)
outreg2 using "`table'.tex", tex(frag) append `format' dec(3) `text' cttop("$\Delta =$ 1 year; 10-21")

ivreghdfe dep_1y dst1y dtreasbasis1y dvix debp lyst1y lytreasbasis lyvix lyebp lrer if inrange(year, 2010,2021), a(cid) bw(12) cluster(ym)
outreg2 using "`table'.tex", tex(frag) append `format' dec(3) `text' cttop("$\Delta =$ 1 year; 10-21")

cap erase "`table'.txt"

restore