*** The global dollar cycle ***

** Part 2: Determinants of dollar exchange rate **
** Table 2: long rate **

clear all
set more off
global masterpath "~/Dropbox (Princeton)/Research/globalcycle_brookings/replication"
cd "$masterpath"
global outputpath "$masterpath/output/fx_reg"
set scheme s1color
graph drop _all

*** Some data preparation ***
use "data/fx_reg/dollar_reg_data.dta", clear
xtset cid ym
gen year = year(dofm(ym))

* rate differential, transformation
gen logVIX = 100 * log(VIXCLS)      // log difference will be in pp
gen tbdiff10y = USDZC10Y - ZC10Y   // zero-coupon bond
gen tpdiff10y = USDTP10Y - TP10Y
gen lambdadiff3m = (USDibor3m_c - USDtreas3m_c) - (ibor3m_c - treas3m_c)
gen lambdadiff1y = (USDibor1y_b - USDtreas1y) - (ibor1y_b - treas1y)
gen lambdadiff10y = (USDirs10y - USDZC10Y) - (irs10y - ZC10Y)
gen loghkm = 100 * log(1/icr)

* flip the signs for better interpretation
replace ciptreas3m = -ciptreas3m / 100   // to pp
replace ciptreas1y = -ciptreas1y / 100
replace ciptreas10y = -ciptreas10y / 100
replace cipibor3m = -cipibor3m / 100
replace cipibor1y = -cipibor1y / 100
gen cipibor10y = -bs10y / 100       // to percentage point

replace rer = 100 * log(rer)

* quarterly / yearly lags
gen lqlt = l3.tbdiff10y
gen lqtp = l3.tpdiff10y
gen lqvix = l3.logVIX
gen lqebp = l3.ebp
gen lqiborbasis = l3.cipibor3m
gen lqtreasbasis = l3.ciptreas3m
gen lqlambda = l3.lambdadiff3m    // liquidity premium
gen lqlambda10 = l3.lambdadiff10y    // liquidity premium
gen lqciptreas10y = l3.ciptreas10y
gen lqcipibor10y = l3.cipibor10y
gen lqhkm = l3.loghkm

gen lylt = l12.tbdiff10y
gen lytp = l12.tpdiff10y
gen lyvix = l12.logVIX
gen lyebp = l12.ebp
gen lyiborbasis = l12.cipibor1y
gen lytreasbasis = l12.ciptreas1y
gen lylambda = l12.lambdadiff1y    // liquidity premium
gen lylambda10 = l12.lambdadiff10y    // liquidity premium
gen lyciptreas10y = l12.ciptreas10y
gen lycipibor10y = l12.cipibor10y
gen lyhkm = l12.loghkm

gen lqrer = l3.rer
gen lyrer = l12.rer

preserve
** 3M horizon **
keep if year >= 1999 & year <= 2021

gen dlt = tbdiff10y - lqlt
gen dtp = tpdiff10y - lqtp
gen dlambda3m = lambdadiff3m - lqlambda
gen dlambda10y = lambdadiff10y - lqlambda10
gen diborbasis3m = cipibor3m - lqiborbasis
gen dciptreas10y = ciptreas10y - lqciptreas10y
gen dtreasbasis3m = ciptreas3m - lqtreasbasis
gen diborbasis10y = cipibor10y - lqcipibor10y
gen dvix = logVIX - lqvix
gen debp = ebp - lqebp
gen dhkm = loghkm - lqhkm
gen lrer = lqrer

gen dlambda1y = .
gen dtreasbasis1y = .
gen diborbasis1y = .

label variable dlt "$\Delta (i_{10y,t}^{US} - i_{10y,t}^{*})$"
label variable dtp "$\Delta (tp_{10y,t}^{US} - tp_{10y,t}^{*})$"
label variable dvix "$\Delta$ log VIX"
label variable debp "$\Delta$ excess bond premium"
label variable dlambda3m "$\Delta \gamma_{3m,t} $"
label variable dlambda1y "$\Delta \gamma_{1y,t} $"
label variable dlambda10y "$\Delta \gamma_{10y,t} $"
label variable dhkm "$\Delta$ log primary dealer leverage"
label variable dtreasbasis3m "$\Delta$ 3-month treasury basis (pp)"
label variable diborbasis3m "$\Delta$ 3-month IBOR basis (pp)"
label variable diborbasis1y "$\Delta$ 1-year IBOR basis (pp)"
label variable dtreasbasis1y "$\Delta$ 1-year treasury basis (pp)"
label variable dciptreas10y "$\Delta$ 10-year treasury basis (pp)"
label variable diborbasis10y "$\Delta$ 10-year IBOR basis (pp)"
label variable lrer "Lag RER"
label variable dep_3m "fc qoq depreciation"

local format = "label r2 adjr2 nonotes nocons keep(dlt dtp dlambda3m diborbasis3m dtreasbasis3m dlambda1y diborbasis1y dtreasbasis1y dvix debp lrer) sortvar(dlt dtp dlambda3m diborbasis3m dtreasbasis3m dlambda1y diborbasis1y dtreasbasis1y dvix debp lrer)"
local format2 = "label r2 adjr2 nonotes nocons keep(dlt dlambda10y diborbasis10y dciptreas10y dvix debp lrer) sortvar(dlt dlambda10y diborbasis10y dciptreas10y dvix debp lrer)"
local text = "addtext(Currency FE, $\checkmark$, Lagged controls, $\checkmark$, \citet{dr98} lags, 3)"

local table = "$outputpath/tab_fx_lt_3m"
cap erase "`table'.tex"
cap erase "`table'.txt"

local table3 = "$outputpath/tab_fx_lt_10y_3m"
cap erase "`table3'.tex"
cap erase "`table3'.txt"

* ivreghdfe dep_3m dlt dtp dlambda3m dvix debp dhkm lqlt lqtp lqlambda lqvix lqebp lqhkm lrer, a(cid) bw(3) cluster(ym)
* outreg2 using "`table'.tex", tex(frag) append `format' dec(3) `text' cttop("$\Delta =$ 3 months, 99-21")

ivreghdfe dep_3m dlt dtp dlambda3m diborbasis3m dvix debp lqlt lqtp lqlambda lqiborbasis lqvix lqebp lrer, a(cid) bw(3) cluster(ym)
outreg2 using "`table'.tex", tex(frag) append `format' dec(3) `text' cttop("$\Delta =$ 3 months, 99-21")

ivreghdfe dep_3m dlt dtp dtreasbasis3m dvix debp lqlt lqtp lqtreasbasis lqvix lqebp lrer, a(cid) bw(3) cluster(ym)
outreg2 using "`table'.tex", tex(frag) append `format' dec(3) `text' cttop("$\Delta =$ 3 months, 99-21")

* ivreghdfe dep_3m dlt dlambda10y dvix debp dhkm lylt lqlambda10 lyvix lyebp lyhkm lrer, a(cid) bw(12) cluster(ym)
* outreg2 using "`table3'.tex", tex(frag) append `format2' dec(3) `text' cttop("$\Delta =$ 3 months, 99-21")

ivreghdfe dep_3m dlt dlambda10y diborbasis10y dvix debp lylt lqlambda10 lqcipibor10y lyvix lyebp lrer, a(cid) bw(12) cluster(ym)
outreg2 using "`table3'.tex", tex(frag) append `format2' dec(3) `text' cttop("$\Delta =$ 3 months, 99-21")

ivreghdfe dep_3m dlt dciptreas10y dvix debp lylt lqciptreas10y lyvix lyebp lrer, a(cid) bw(12) cluster(ym)
outreg2 using "`table3'.tex", tex(frag) append `format2' dec(3) `text' cttop("$\Delta =$ 3 months, 99-21")

* ivreghdfe dep_3m dlt dtp dlambda3m dvix debp dhkm lqlt lqtp lqlambda lqvix lqebp lqhkm lrer if inrange(year, 2010,2021), a(cid) bw(3) cluster(ym)
* outreg2 using "`table'.tex", tex(frag) append `format' dec(3) `text' cttop("$\Delta =$ 3 months, 10-21")

ivreghdfe dep_3m dlt dtp dlambda3m diborbasis3m dvix debp lqlt lqtp lqlambda lqiborbasis lqvix lqebp lrer if inrange(year, 2010,2021), a(cid) bw(3) cluster(ym)
outreg2 using "`table'.tex", tex(frag) append `format' dec(3) `text' cttop("$\Delta =$ 3 months, 10-21")

ivreghdfe dep_3m dlt dtp dtreasbasis3m dvix debp lqlt lqtp lqtreasbasis lqvix lqebp lrer if inrange(year, 2010,2021), a(cid) bw(3) cluster(ym)
outreg2 using "`table'.tex", tex(frag) append `format' dec(3) `text' cttop("$\Delta =$ 3 months, 10-21")

* ivreghdfe dep_3m dlt dlambda10y dvix debp dhkm lylt lqlambda10 lyvix lyebp lyhkm lrer if inrange(year, 2010,2021), a(cid) bw(12) cluster(ym)
* outreg2 using "`table3'.tex", tex(frag) append `format2' dec(3) `text' cttop("$\Delta =$ 3 months, 10-21")

ivreghdfe dep_3m dlt dlambda10y diborbasis10y dvix debp lylt lqlambda10 lqcipibor10y lyvix lyebp lrer if inrange(year, 2010,2021), a(cid) bw(12) cluster(ym)
outreg2 using "`table3'.tex", tex(frag) append `format2' dec(3) `text' cttop("$\Delta =$ 3 months, 10-21")

ivreghdfe dep_3m dlt dciptreas10y dvix debp lylt lqciptreas10y lyvix lyebp lrer if inrange(year, 2010,2021), a(cid) bw(12) cluster(ym)
outreg2 using "`table3'.tex", tex(frag) append `format2' dec(3) `text' cttop("$\Delta =$ 3 months, 10-21")

restore

preserve
** 1-year horizon
keep if year >= 1999 & year <= 2021

gen dlt = tbdiff10y - lylt
gen dtp = tpdiff10y - lytp
gen dlambda1y = lambdadiff1y - lylambda
gen diborbasis1y = cipibor1y - lyiborbasis
gen dlambda10y = lambdadiff10y - lylambda10
gen dtreasbasis1y = ciptreas1y - lytreasbasis
gen dciptreas10y = ciptreas10y - lyciptreas10y
gen dvix = logVIX - lyvix
gen debp = ebp - lyebp
gen dhkm = loghkm - lyhkm
gen lrer = lyrer
gen diborbasis10y = cipibor10y - lycipibor10y

gen dlambda3m = .
gen dtreasbasis3m = .
gen diborbasis3m = .

label variable dlt "$\Delta (i_{10y,t}^{US} - i_{10y,t}^{*})$"
label variable dtp "$\Delta (tp_{10y,t}^{US} - tp_{10y,t}^{*})$"
label variable dvix "$\Delta$ log VIX"
label variable debp "$\Delta$ excess bond premium"
label variable dlambda3m "$\Delta \gamma_{3m,t} $"
label variable dlambda1y "$\Delta \gamma_{1y,t} $"
label variable dlambda10y "$\Delta \gamma_{10y,t} $"
label variable dhkm "$\Delta$ log primary dealer leverage"
label variable dtreasbasis3m "$\Delta$ 3-month treasury basis (pp)"
label variable dtreasbasis1y "$\Delta$ 1-year treasury basis (pp)"
label variable dciptreas10y "$\Delta$ 10-year treasury basis (pp)"
label variable diborbasis10y "$\Delta$ 10-year IBOR basis (pp)"
label variable diborbasis1y "$\Delta$ 1-year IBOR basis (pp)"
label variable lrer "Lag RER"
label variable dep_1y "fc yoy depreciation"

local table2 = "$outputpath/tab_fx_lt_1y"
cap erase "`table2'.tex"
cap erase "`table2'.txt"
local table4 = "$outputpath/tab_fx_lt_10y_1y"
cap erase "`table4'.tex"
cap erase "`table4'.txt"
local text = "addtext(Currency FE, $\checkmark$, Lagged controls, $\checkmark$, \citet{dr98} lags, 12)"

* ivreghdfe dep_1y dlt dtp dlambda1y dvix debp dhkm lylt lytp lylambda lyvix lyebp lyhkm lrer, a(cid) bw(12) cluster(ym)
* outreg2 using "`table2'.tex", tex(frag) append `format' dec(3) `text' cttop("$\Delta =$ 1 year, 99-21")

ivreghdfe dep_1y dlt dtp dlambda1y diborbasis1y dvix debp lylt lytp lylambda lyiborbasis lyvix lyebp lrer, a(cid) bw(12) cluster(ym)
outreg2 using "`table2'.tex", tex(frag) append `format' dec(3) `text' cttop("$\Delta =$ 1 year, 99-21")

ivreghdfe dep_1y dlt dtp dtreasbasis1y dvix debp lylt lytp lytreasbasis lyvix lyebp lrer, a(cid) bw(12) cluster(ym)
outreg2 using "`table2'.tex", tex(frag) append `format' dec(3) `text' cttop("$\Delta =$ 1 year, 99-21")

* ivreghdfe dep_1y dlt dlambda10y dvix debp dhkm lylt lylambda10 lyvix lyebp lyhkm lrer, a(cid) bw(12) cluster(ym)
* outreg2 using "`table4'.tex", tex(frag) append `format2' dec(3) `text' cttop("$\Delta =$ 1 year, 99-21")

ivreghdfe dep_1y dlt dlambda10y diborbasis10y dvix debp lylt lylambda10 lycipibor10y lyvix lyebp lrer, a(cid) bw(12) cluster(ym)
outreg2 using "`table4'.tex", tex(frag) append `format2' dec(3) `text' cttop("$\Delta =$ 1 year, 99-21")

ivreghdfe dep_1y dlt dciptreas10y dvix debp lylt lyciptreas10y lyvix lyebp lrer, a(cid) bw(12) cluster(ym)
outreg2 using "`table4'.tex", tex(frag) append `format2' dec(3) `text' cttop("$\Delta =$ 1 year, 99-21")

* ivreghdfe dep_1y dlt dtp dlambda1y dvix debp dhkm lylt lytp lylambda lyvix lyebp lyhkm lrer if inrange(year, 2010,2021), a(cid) bw(12) cluster(ym)
* outreg2 using "`table2'.tex", tex(frag) append `format' dec(3) `text' cttop("$\Delta =$ 1 year, 10-21")

ivreghdfe dep_1y dlt dtp dlambda1y diborbasis1y dvix debp lylt lytp lylambda lyiborbasis lyvix lyebp lrer if inrange(year, 2010,2021), a(cid) bw(12) cluster(ym)
outreg2 using "`table2'.tex", tex(frag) append `format' dec(3) `text' cttop("$\Delta =$ 1 year, 10-21")

ivreghdfe dep_1y dlt dtp dtreasbasis1y dvix debp lylt lytp lytreasbasis lyvix lyebp lrer if inrange(year, 2010,2021), a(cid) bw(12) cluster(ym)
outreg2 using "`table2'.tex", tex(frag) append `format' dec(3) `text' cttop("$\Delta =$ 1 year, 10-21")

* ivreghdfe dep_1y dlt dlambda10y dvix debp dhkm lylt lylambda10 lyvix lyebp lyhkm lrer if inrange(year, 2010,2021), a(cid) bw(12) cluster(ym)
* outreg2 using "`table4'.tex", tex(frag) append `format2' dec(3) `text' cttop("$\Delta =$ 1 year, 10-21")

ivreghdfe dep_1y dlt dlambda10y diborbasis10y dvix debp lylt lylambda10 lycipibor10y lyvix lyebp lrer if inrange(year, 2010,2021), a(cid) bw(12) cluster(ym)
outreg2 using "`table4'.tex", tex(frag) append `format2' dec(3) `text' cttop("$\Delta =$ 1 year, 10-21")

ivreghdfe dep_1y dlt dciptreas10y dvix debp lylt lyciptreas10y lyvix lyebp lrer if inrange(year, 2010,2021), a(cid) bw(12) cluster(ym)
outreg2 using "`table4'.tex", tex(frag) append `format2' dec(3) `text' cttop("$\Delta =$ 1 year, 10-21")

cap erase "`table'.txt"
cap erase "`table2'.txt"
cap erase "`table3'.txt"
cap erase "`table4'.txt"

restore
