%% The global dollar cycle
% simple Bayesian VAR and variance decomposition

clear;
cd("/Users/haonanzhou/Dropbox (Princeton)/Research/globalcycle_brookings/replication");

% use the BVAR toolbox by Canova-Ferroni 2022
addpath("code/misc/var/library/bvartools/");
addpath("code/misc/var/library/cmintools/");
addpath("code/misc/var/library/table2latex/");

% load data
data = readtable('code/misc/var/data_var.csv');

% reorder: Cholesky: Interest rate - EBP - Treasury basis - NER

% interest rate is set at one-year horizon
% y = table2array(data(:,[6, 3, 7, 2]));

% interest rate is set at three-month horizon
y = table2array(data(:,[4, 3, 5, 2]));
% y = table2array(data(:,[11, 3, 9, 2]));

% y = table2array(data(:,[3, 5, 4, 2]));
% y = y(133:end, :);

y(:, 4) = 100 * log(y(:, 4));       % to 100*log


%% BVAR

lags                = 12;
options.hor         = 24;
options.prior.name     = 'Minnesota';
% options.minn_prior_tau = 6.5;
% options.minn_prior_decay = 0.95;
% options.minn_prior_lambda = 5;
options.max_compute = 7;
options.max_minn_hyper = 1;

bvar6                  = bvar_(y,lags,options);

% Define the IRF of Interest
% index of the shocks of interest (shock to ebp)
indx_sho              = 2;
% order IRFs: EBP, Interest rate diff, treasury basis, NER
% note the order of IRFs is NOT the order of Cholesky identification.
indx_var              = [2, 1, 3, 4];
% indx_sho              = 1;
% indx_var              = [1, 2, 3, 4];

% IRF to PLOT
% bvar6.ir_draws: the first dimension corresponds to the variables, 
% the second to the horizon, 
% the third to the disturbances, 
% and the fourth to the responses obtained with particular draw from the posterior distribution of the VAR parameter. 
irf_sort    = sort(bvar6.ir_draws,4);
irfs_to_plot           = irf_sort(indx_var,:,indx_sho,:);


% Customize the IRF plot
% variables names for the plots
options.varnames      = {'EBP','Interest rate differential', '3-month Treasury Basis', 'NER'};  
% options.varnames      = {'EBP','Interest rate differential', '3-month IBOR Basis', 'NER'};  
% options.varnames      = {'EBP','3-month Treasury Basis', 'Interest rate differential', 'NER'};  

% name of the shock
options.shocksnames   = {'EBP'};  
% additional 90% HPD set
options.conf_sig_2    = 0.9;

% finally, the plotting command
plot_irfs_(irfs_to_plot,options)

% output
% print("irf_EBP",'-depsc2');
print("output/misc/irf_EBP_iborbasis",'-depsc2');


%% Extra part 1/: Forecast Error variance decomposition with Cholesky (bvar1)
% compute the contribution of shocks to the H-step ahead forecast error  of
% observables

% consider the mean of the posterior distribution 
Phi   = mean(bvar6.Phi_draws,3);
Sigma = mean(bvar6.Sigma_draws,3);
% index of the shocks of interest (shock to EBP)
% indx_sho              = 2;

% index of the variable of interest
indx_var              = 4;      % ner

horizon = [1 3 6 9 12 24];

% FEVD is a 4 × 4 matrix where rows correspond to variables
% (in the same order as in the VAR) and columns to shocks.
var_explained = zeros(3, size(horizon,2));
for ii = 1:size(horizon,2)
    hh = horizon(1,ii);
    FEVD = fevd(hh,Phi,Sigma);
    fevd_exp = FEVD(:,[1, 2, 3])';  % interest rate, ebp, treasury basis
    var_explained(:, ii) = fevd_exp(:, 4);  % 4 is NER
    var_explained = round(var_explained, 2);
end

C = num2cell(var_explained);
% Convert the cells to strings with 2 decimals
fun = @(x) sprintf('%0.2f', x);
D = cellfun(fun, C, 'UniformOutput',0);
T = cell2table(D);

T.Properties.VariableNames = {'\textbf{1m}', '\textbf{3m}', '\textbf{6m}', ... 
                              '\textbf{9m}', '\textbf{12m}', '\textbf{24m}'};
T.Properties.RowNames = {'Interest rate differential', 'EBP', 'Treasury basis'};
% T.Properties.RowNames = {'Interest rate differential', 'EBP', 'IBOR basis'};

table2latex(T, 'output/misc/var_explained.tex');

% 3 month ahead FEVD
% hh      = 3;
% FEVD    = fevd(hh,Phi,Sigma);

% disp('%=====================================================%')
% disp('% Forecast Error Variance Decomposition               %')
% disp('% Percentage of volatility explained by EBP  %')
% disp('    Interest       EBP     basis     ner ')
% disp('    EBP     basis    Interest    ner ')
% disp(FEVD(:,indx_sho)')
% disp('%                                                     %')
% disp('%=====================================================%')






