clear all
set more off
global masterpath "~/Dropbox (Princeton)/Research/globalcycle_brookings/replication"
cd "$masterpath"
set scheme s1color
graph drop _all

use "data/fx_reg/dollar_reg_data.dta", clear
keep if currency == "EUR"
keep if year(dofm(ym)) >= 1999 & year(dofm(ym)) <= 2021
gen hkm = 1/icr

gcollapse (mean) VIXCLS ebp hkm aedollar, by(yq)
gen date = dofq(yq)
keep date VIXCLS ebp hkm yq aedollar
format date %dCCYY
drop if date == .

preserve
    freduse USRECM, clear
    gen yq = yq(year(daten), quarter(daten))
    sort daten
    gcollapse (last) USRECM, by(yq) 

    tempfile recession
    save `recession', replace
restore

merge 1:1 yq using `recession', keep(1 3) nogen

qui sum ebp
generate recession = 4 if USRECM == 1
replace recession  = -1 if recession != 4

tsset yq, quarterly
graph twoway (bar recession yq, yaxis(1) bcolor(gs14) base(-1) fi(100)) /// 
    (tsline ebp, yaxis(1) lc(red)) (tsline VIXCLS, yaxis(2) lp(dash) lc(ebblue)), ///
    legend(order(2 "Excess bond premium (lhs)" 3 "VIX index (rhs)") row(3)) /// 
    ytitle("Percent", axis(1)) ytitle("Level", axis(2)) xtitle("") tlabel(, format(%tqCCYY)) ylabel(10(10)60, axis(2)) plotr(m(t=0 b=0))
graph export "output/desc/fig12a_ebp_vix.pdf", replace

tsset yq, quarterly
graph twoway (bar recession yq, bcolor(gs14) fi(100) base(-1) yaxis(1)) ///
    (tsline ebp, yaxis(1) lc(red)) (tsline aedollar, lp(shortdash) lc(black) yaxis(2)), ///
    legend(order(2 "Excess bond premium (lhs)" 3 "Nominal dollar index against AE (2006M1=100, rhs)") row(2)) /// 
    ytitle("Level", axis(2)) ytitle("Precent", axis(1)) xtitle("") tlabel(, format(%tqCCYY)) plotr(m(t=0 b=0))
graph export "output/desc/fig12b_ebp_dollar.pdf", replace


** Also plot EM demand factor, term premium estimates **
import delimited "output/misc/EM_demand.csv", clear
gen dd = date(date, "DMY")
format dd %d
gen yq = yq(year(dd), quarter(dd))
format yq %tq
drop dd date
order yq
tsset yq

preserve
    freduse USRECM, clear
    gen yq = yq(year(daten), quarter(daten))
    sort daten
    gcollapse (last) USRECM, by(yq) 

    tempfile recession
    save `recession', replace
restore

merge 1:1 yq using `recession', keep(1 3) nogen
replace USRECM = 0 if !inrange(year(dofq(yq)), 2007, 2009)
generate recession = 3 if USRECM == 1
replace recession  = -2 if recession != 3

tsset yq, quarterly
graph twoway (bar recession yq, bcolor(gs14) fi(100) base(-2) yaxis(1)) ///
    (tsline var2, yaxis(1) lc(red)), ///
    legend(order(2 "EM demand factor" 1 "07-09 recession") row(1)) /// 
    ytitle("Level", axis(1)) xtitle("") tlabel(, format(%tqCCYY)) plotr(m(t=0 b=0))
graph export "output/desc/figa7_em_demand.pdf", replace


** Term premium **
use "data/fx_reg/dollar_reg_data.dta", clear
keep currency ym TP10Y ZC10Y fitted10Y 

drop if TP10Y == .
gen country = ""
replace country = "Australia" if currency == "AUD"
replace country = "Canada" if currency == "CAD"
replace country = "Switzerland" if currency == "CHF"
replace country = "Denmark" if currency == "DKK"
replace country = "Germany (€)" if currency == "EUR"
replace country = "United Kingdom" if currency == "GBP"
replace country = "Japan" if currency == "JPY"
replace country = "Norway" if currency == "NOK"
replace country = "New Zealand" if currency == "NZD"
replace country = "Sweden" if currency == "SEK"

format ym %tmCCYY
graph twoway (line ZC10Y ym) (line fitted10Y ym) (line TP10Y ym), /// 
    by(country, yrescale note("") row(2)) xtitle("") /// 
    legend(order(1 "10-year zero-coupon yield" 2 "fitted yield" 3 "term premium") row(3) size(small)) 
graph export "output/desc/figa8a_tp10y.pdf", replace


use "data/fx_reg/dollar_reg_data.dta", clear

preserve
    freduse THREEFYTP10, clear
    drop if THREEFYTP10 == .
    gen ym = ym(year(daten), month(daten))
    gcollapse (last) THREEFYTP10, by(ym)

    tempfile kw05
    save `kw05', replace
restore

preserve
    use "data/misc/ACMTermPremium.dta", clear
    keep date ACMTP10
    drop if ACMTP10 == .
    gen ym = ym(year(date), month(date))
    gcollapse (last) ACMTP10, by(ym)

    tempfile ACM
    save `ACM', replace
restore

merge m:1 ym using `kw05', keep(1 3) nogen
merge m:1 ym using `ACM', keep(1 3) nogen
sort currency ym

*** Plot term premia ***
format ym %tmYY

graph twoway (line USTP10Y_nss ym) (line USDTP10Y ym) (line THREEFYTP10 ym) (line ACMTP10 ym) ///
      if inlist(currency, "GBP"), xtitle("") /// 
      legend(order(1 "10-year US treasury term premium (Nelson-Siegel, ACM)" 2 "10-year US treasury term premium (Bloomberg, ACM)" /// 
                   3 "Kim and Wright (2005) estimate" 4 "Official ACM estimate") size(small) row(4))
graph export "output/desc/figa8b_tp.pdf", replace


** daily cip basis **
use "data/fx_reg/basis3m_daily.dta", clear

drop if inlist(currency, "AUD", "NZD")
keep if date > d(04jan1999) & date < d(01jan2022)
gcollapse (mean) cipibor3m ciptreas3m, by(date)

* smooth
tsset date
tssmooth ma ibor = cipibor3m, window(7 1 7) // 10-day moving average (excluding weekends)
tssmooth ma treas = ciptreas3m, window(7 1 7) // 10-day moving average (excluding weekends)

replace ibor = -ibor
replace treas = -treas
label variable ibor "3-month IBOR basis"
label variable treas "3-month treasury basis"
format date %dCCYY

gen Zero = 0
local t = d(01sep2008)

sum cipibor3m ciptreas3m if date < `t'
corr cipibor3m ciptreas3m if date < `t'
local rho1 = round(r(rho),.01)
sum cipibor3m ciptreas3m if date >= `t'
corr cipibor3m ciptreas3m if date >= `t'
local rho2 = round(r(rho),.01)
local t1 = d(01jan2004)
local t2 = d(01jan2016)

graph twoway (line ibor date) (line treas date) /// 
             (line Zero date, lc(gray)  lw(medthin) lp(dash)), /// 
             legend(order(1 2)) ytitle("bps") xtitle("") xline(`t', lw(medthick) lc(gray)) /// 
             text(200 `t1' "Corr (99M1-08M8): 0`rho1'") /// 
             text(200 `t2' "Corr (08M9-21M12): 0`rho2'")
graph export "output/desc/fig13a_basis3m.pdf", replace


use "data/fx_reg/basis3m_daily.dta", clear

drop if inlist(currency, "AUD", "NZD")
keep if date > d(04jan1999) & date < d(01jan2022)
gcollapse (mean) cipibor1y ciptreas1y, by(date)

* smooth
tsset date
tssmooth ma ibor = cipibor1y, window(7 1 7) // 10-day moving average (excluding weekends)
tssmooth ma treas = ciptreas1y, window(7 1 7) // 10-day moving average (excluding weekends)

replace ibor = -ibor
replace treas = -treas
label variable ibor "1-year IBOR basis"
label variable treas "1-year treasury basis"
format date %dCCYY

gen Zero = 0
local t = d(01sep2008)

sum cipibor1y ciptreas1y if date < `t'
corr cipibor1y ciptreas1y if date < `t'
local rho1 = round(r(rho),0.01)
sum cipibor1y ciptreas1y if date >= `t'
corr cipibor1y ciptreas1y if date >= `t'
local rho2 = round(r(rho),0.01)
local t1 = d(01jan2004)
local t2 = d(01jan2016)

graph twoway (line ibor date) (line treas date) /// 
             (line Zero date, lc(gray)  lw(medthin) lp(dash)), /// 
             legend(order(1 2)) ytitle("bps") xtitle("") xline(`t', lw(medthick) lc(gray)) /// 
             text(140 `t1' "Corr (99M1-08M8): 0`rho1'") /// 
             text(140 `t2' "Corr (08M9-21M12): 0`rho2'")
graph export "output/desc/fig13b_basis1y.pdf", replace