* Optionally replicate Ball, Leigh, and Mishra Figures 17 and 19

scalar replicate = 1

/*******************************************************************************
* Import blmsim program
*******************************************************************************/
cap program drop blmsim

do prog/blm_simulations.ado

/*******************************************************************************
* Optionially replicate Ball, Leigh, and Mishra using blmsim program
*******************************************************************************/
if replicate{
	do "prog/replicate/Figure 17 - SEP.do"
	blmsim, simnum(21) simdesc("Pessim. BC, expectations revert") ursim("SEP") beveridge("remain") expectations("revert") gamma(0.945)
	blmsim, simnum(22) simdesc("Pessim. BC, expectations drift ({&gamma}=0.98)") ursim("SEP") beveridge("remain") expectations("drift") gamma(0.98)
	blmsim, simnum(23) simdesc("Pessim. BC, expectations drift ({&gamma}=0.94)") ursim("SEP") beveridge("remain") expectations("drift") gamma(0.945)
	blmsim, simnum(24) simdesc("Optim. BC, expectations revert") ursim("SEP") beveridge("revert") expectations("revert") gamma(0.945)
	blmsim, simnum(25) simdesc("Optim. BC, expectations drift ({&gamma}=0.98)") ursim("SEP") beveridge("revert") expectations("drift") gamma(0.98)
	blmsim, simnum(26) simdesc("Optim. BC, expectations drift ({&gamma}=0.94)") ursim("SEP") beveridge("revert") expectations("drift") gamma(0.945)
	
	forvalues w = 1/6 {
		use output/sim2`w', clear
		rename *2`w' *`w'
		cf _all using "output/sim`w'.dta"
		
	}
	
	do "prog/replicate/Figure 19 - IMF.do"
	blmsim, simnum(31) simdesc("Pessim. BC, expectations revert") ursim("IMF") beveridge("remain") expectations("revert") gamma(0.945)
	blmsim, simnum(32) simdesc("Pessim. BC, expectations drift ({&gamma}=0.98)") ursim("IMF") beveridge("remain") expectations("drift") gamma(0.98)
	blmsim, simnum(33) simdesc("Pessim. BC, expectations drift ({&gamma}=0.94)") ursim("IMF") beveridge("remain") expectations("drift") gamma(0.945)
	blmsim, simnum(34) simdesc("Optim. BC, expectations revert") ursim("IMF") beveridge("revert") expectations("revert") gamma(0.945)
	blmsim, simnum(35) simdesc("Optim. BC, expectations drift ({&gamma}=0.98)") ursim("IMF") beveridge("revert") expectations("drift") gamma(0.98)
	blmsim, simnum(36) simdesc("Optim. BC, expectations drift ({&gamma}=0.94)") ursim("IMF") beveridge("revert") expectations("drift") gamma(0.945)

	
	forvalues w = 1/6 {
		use output/sim3`w', clear
		rename *3`w' *`w'
		cf _all using "output/sim`w'.dta"
		
	}
	
	do "prog/replicate/Figure 19 - HigherU.do"
	blmsim, simnum(41) simdesc("Pessim. BC, expectations revert") ursim("HigherU") beveridge("remain") expectations("revert") gamma(0.945)
	blmsim, simnum(42) simdesc("Pessim. BC, expectations drift ({&gamma}=0.98)") ursim("HigherU") beveridge("remain") expectations("drift") gamma(0.98)
	blmsim, simnum(43) simdesc("Pessim. BC, expectations drift ({&gamma}=0.94)") ursim("HigherU") beveridge("remain") expectations("drift") gamma(0.945)
	blmsim, simnum(44) simdesc("Optim. BC, expectations revert") ursim("HigherU") beveridge("revert") expectations("revert") gamma(0.945)
	blmsim, simnum(45) simdesc("Optim. BC, expectations drift ({&gamma}=0.98)") ursim("HigherU") beveridge("revert") expectations("drift") gamma(0.98)
	blmsim, simnum(46) simdesc("Optim. BC, expectations drift ({&gamma}=0.94)") ursim("HigherU") beveridge("revert") expectations("drift") gamma(0.945)
	
	forvalues w = 1/6 {
		use output/sim4`w', clear
		rename *4`w' *`w'
		cf _all using "output/sim`w'.dta"
	}
}

/*******************************************************************************
* Specify exogenous shocks
*******************************************************************************/
use workdata/simdata, clear

gen zshock = 0

* Specify 0.3 pp exogenous shock to inflation expectations occurring over 9 months
gen exogenous_dspe = 0
replace exogenous_dspe = -0.1/3 if inrange(t, tm(2022m10), tm(2023m6))

keep t zshock exogenous_dspe
save workdata/tmpvars.dta, replace

/*******************************************************************************
* Scenarios for Furman Figure 1
*******************************************************************************/

use  workdata/tmpvars, clear
blmsim, simnum(28) simdesc("Furman - Partial BC Revert, expectations drift ({&gamma}=0.99) + exog.") ursim("SEP") beveridge("partial") expectations("drift") gamma(0.991) expshock(exogenous_dspe)

use  workdata/tmpvars, clear
blmsim, simnum(38) simdesc("Furman - Partial BC Revert, expectations drift ({&gamma}=0.99) + exog.") ursim("IMF") beveridge("partial") expectations("drift") gamma(0.991) expshock(exogenous_dspe)

use  workdata/tmpvars, clear
blmsim, simnum(48) simdesc("Furman - Partial BC Revert, expectations drift ({&gamma}=0.99) + exog.") ursim("HigherU") beveridge("partial") expectations("drift") gamma(0.991) expshock(exogenous_dspe)

/*******************************************************************************
* Scenarios for Furman Table 2 / Figure 2
*******************************************************************************/

local u1 = 9.044	// gamma = 0.90	
local u2 = 8.470	// gamma = 0.945
local u3 = 7.697 	// gamma = 0.991
local u4 = 6.707 	// gamma = 0.991 + 0.3 pp reduction in expectations
local u5 = 4.896	// Expectations Revert
local u6 = 4.648	// gamma = 0.90, target 4.0% PCE (4.5% median CPI)


use  workdata/tmpvars, clear
blmsim, simnum(51) simdesc("Furman - Pi Target, expectations drift ({&gamma}=0.90)") ursim("Target, `u1'") beveridge("partial") expectations("drift") gamma(0.90) 
use  workdata/tmpvars, clear
blmsim, simnum(52) simdesc("Furman - Pi Target, expectations drift ({&gamma}=0.945)") ursim("Target, `u2'") beveridge("partial") expectations("drift") gamma(0.945)
use  workdata/tmpvars, clear
blmsim, simnum(53) simdesc("Furman - Pi Target, expectations drift ({&gamma}=0.991)") ursim("Target, `u3'") beveridge("partial") expectations("drift") gamma(0.991) 
use  workdata/tmpvars, clear
blmsim, simnum(54) simdesc("Furman - Pi Target, expectations drift ({&gamma}=0.991) + exog.") ursim("Target, `u4'") beveridge("partial") expectations("drift") gamma(0.991) expshock(exogenous_dspe) 
use  workdata/tmpvars, clear
blmsim, simnum(55) simdesc("Furman - Pi Target, expectations revert") ursim("Target, `u5'") beveridge("partial") expectations("revert") gamma(0.991) 
use  workdata/tmpvars, clear
blmsim, simnum(56) simdesc("Furman - Pi Target, expectations drift ({&gamma}=0.90)") ursim("Target, `u6'") beveridge("partial") expectations("drift") gamma(0.90) 

use output/sim51, clear
forvalues s = 2/6{
	merge 1:1 t using output/sim5`s', nogen
}

* Confirm that target inflation reached by end of 2024 (PCE ~= Core CPI - 0.5)
clist t spa51 spa52 spa53 spa54 spa55 spa56 if t>=tm(2022m6) & t<=tm(2024m12), noobs

/*******************************************************************************
* Scenarios for Furman Table 3 / Figure 2
*******************************************************************************/

local u1 = 6.707	// 2.0 percent PCE inflation target
local u2 = 4.705	// 2.5 percent PCE inflation target
local u3 = 4.116	// 3.0 percent PCE inflation target
local u4 = 3.881	// 3.5 percent PCE inflation target
local u5 = 3.736	// 4.0 percent PCE inflation target

use  workdata/tmpvars, clear
blmsim, simnum(61) simdesc("Inflation target: 2.0%") ursim("Target, `u1'") beveridge("partial") expectations("drift") gamma(0.991) expshock(exogenous_dspe) 
use  workdata/tmpvars, clear
blmsim, simnum(62) simdesc("Inflation target: 2.5%") ursim("Target, `u2'") beveridge("partial") expectations("drift") gamma(0.991) expshock(exogenous_dspe) 
use  workdata/tmpvars, clear
blmsim, simnum(63) simdesc("Inflation target: 3.0%") ursim("Target, `u3'") beveridge("partial") expectations("drift") gamma(0.991) expshock(exogenous_dspe) 
use  workdata/tmpvars, clear
blmsim, simnum(64) simdesc("Inflation target: 3.5%") ursim("Target, `u4'") beveridge("partial") expectations("drift") gamma(0.991) expshock(exogenous_dspe) 
use  workdata/tmpvars, clear
blmsim, simnum(65) simdesc("Inflation target: 4.0%") ursim("Target, `u5'") beveridge("partial") expectations("drift") gamma(0.991) expshock(exogenous_dspe) 

use output/sim61, clear
forvalues s = 2/5{
	merge 1:1 t using output/sim6`s', nogen
}

* Confirm that target inflation reached by end of 2024 (PCE ~= Core CPI - 0.5)
clist t spa61 spa62 spa63 spa64 spa65 if t>=tm(2022m6) & t<=tm(2024m12), noobs