***************************************************************
* Read in data
***************************************************************
	
set more off
clear
* Put name of your main directory path here:
local main = ""
cd "`main'"

use rawdata/data_monthly.dta, clear

***************************************************************
* Data work
***************************************************************

* Define measure of "CORE" (Median, XFE, and so on)
* Defined measure of HEADLINE (CPI, PCE, and so on)
g CORE			= Median
g HEADLINE		= CPI
g CORE_12		= Median_12
g HEADLINE_12	= CPI_12

* Relative price fluctuations (supply fluctuations)
g z			= HEADLINE - CORE
* 12-month average
gen z_12ma	= (1/12)*(z + z[_n-1] + z[_n-2] + z[_n-3] + z[_n-4] + z[_n-5] + z[_n-6] + z[_n-7] + z[_n-8] + z[_n-9] + z[_n-10] + z[_n-11])
* Lag
g L1z		= z[_n-1]

* Dates and sample
local latest = tm(2022m9)	
local latestpe = tm(2022m9)
local latestbc = tm(2022m8)

* Sample dummies
forval s = 1/4 {
	g sample`s' = 0
}
replace sample1 = 1 if (t>=tm(1960m1)) & (t<=tm(1972m12))
replace sample2 = 1 if (t>=tm(1973m1)) & (t<=tm(1984m12))
replace sample3 = 1 if (t>=tm(1985m1)) & (t<=tm(2019m12))
replace sample4 = 1 if (t>=tm(2020m1)) & (t<=`latest')
	
replace qsample = qsample[_n-4] if t>=tm(2022m12)
replace qsample = 1 if t==tm(2024m12)
replace qsample = 1 if t==tm(2025m12)

***************************************************************
* SIMULATION ASSUMPTIONS
***************************************************************

***************************************************************
***** Assumption #1. Unemployment rate path *****
***************************************************************
//* Projections similar to FOMC September 2022 SEP
replace u = 3.8 if t ==tm(2022m11)
replace u = 4.4 if t ==tm(2023m11)
replace u = 4.4 if t ==tm(2024m11)
replace u = 4.3 if t ==tm(2025m11)
*/
* Interpolate ("int") between missing datapoints
ipolate u t if t>=`latest', generate(uint)
replace u = uint if t>=`latest' & u==.

***************************************************************
* Save simulation dataset with this U path and run simulations
***************************************************************
save workdata/simdata, replace