set more off
clear

* INPUT PATH TO DIRECTORY HERE:
cd ""

* Dates and sample
local latest = tm(2022m9)

***************************************************************
* TABLE 2: Point Years - Parameters
***************************************************************
use output/sim51, clear
forvalues s = 2/5{
	merge 1:1 t using output/sim5`s', nogen
	keep t su*
}

keep if t > `latest' & t <= tm(2024m12)

* Calculate elevation above 3.7 percent inflation
forvalues w = 51/55{
	gen Udiff`w' = su`w' - 3.7
}

collapse (max) su* (sum) Udiff*

* Divide by 12 to get point years of unemployment
forvalues w =51/55{
	replace Udiff`w' = Udiff`w' / 12
}

gen id = 1
reshape long su Udiff, i(id) j(scenario)

label de SCENARIO 51 "Expectations drift (gamma=0.90)" 52 "Expectations drift (gamma=0.945)" 53 "Expectations drift (gamma=0.991)" 54 "Expectations drift (gamma=0.991) + exog." 55 "Revert to 2.2" 

label val scenario SCENARIO
label var scenario "Inflation Expectations"
label var su "Unemployment in 2023 and 2024 Needed for 2% PCE Inflation"
label var Udiff "Point Years of Added Unemployment"
format su Udiff %3.1f
drop id
list 

export excel using "Tab2. Unemployment Rate Needed to Achieve 2 Percent Inflation Under Different Assumptions About Inflation Expectations.xlsx", sheet(tab, modify) firstrow(varl)

***************************************************************
* TABLE 3: Point Years - Inflation
***************************************************************

use output/sim61, clear
forvalues s = 2/5{
	merge 1:1 t using output/sim6`s', nogen
	keep t su*
}

keep if t > `latest' & t <= tm(2024m12)

* Calculate elevation above 3.7 percent inflation
forvalues w = 61/65{
	gen Udiff`w' = su`w' - 3.7
}

collapse (max) su* (sum) Udiff*

* Divide by 12 to get point years of unemployment
forvalues w = 61/65{
	replace Udiff`w' = Udiff`w' / 12
}

gen id = 1
reshape long su Udiff, i(id) j(scenario)

gen sacrifice = 2 * (Udiff - Udiff[_n+1])

label de SCENARIO 61 "2.0" 62 "2.5" 63 "3.0" 64 "3.5" 65 "4.0" 

label val scenario SCENARIO
label var scenario "PCE Inflation at End of 2024"
label var su "Unemployment in 2023 and 2024"
label var Udiff "Point Years of Added Unemployment"
label var sacrifice "Sacrifice Ratio"
format su Udiff sacrifice %3.1f
drop id
list

export excel using "Tab3. Unemployment Rate Needed to Achieve Different Inflation Targets.xlsx", sheet(tab, modify) firstrow(varl)