clear all
set more off

cd ""

********************************************************************************
*** 1. Import data and define parameters:									 ***
********************************************************************************

import excel "rawdata/phillips_curve_inflation_data.xlsx", sheet("Stata") firstrow clear

gen quarter = qofd(date)

tsset quarter, q

# delimit
local timeperiods `" "yq(2001, 1), yq(2018, 4)" "';
# delimit cr

local latest = yq(2021, 2)

local slack   	pa_nonemp ur unemp_open open_unemp open_rate quit_rate

local nominal 	

local price 	cpi_growth	corecpi_growth	trimmeancpi_growth	mediancpi_growth	

local real		

local yvarlist price


********************************************************************************
*** 2. Label and Create Additional Variables:							 	 ***
********************************************************************************

label var cpi_growth "CPI"
label var corecpi_growth "Core CPI"
label var trimmeancpi_growth "Trimmed-mean CPI"
label var mediancpi_growth "Median CPI"

label var pa_nonemp "PA Non-employment"
label var ur "U3"
label var unemp_open "Unemployed/Openings"
label var open_unemp "Openings/Unemployed"
label var open_rate "Openings rate"
label var quit_rate "Quits Rate"

********************************************************************************
*** 3. Traditional Regressions		:									 	 ***
********************************************************************************
local count = 0
foreach xvar of local slack{
	local per = 1 
	foreach t of local timeperiods{
		qui su quarter if inrange(quarter, `t')
		local n = r(N)
		local period = substr("`t'", 4, 4) + "-" + substr("`t'", 17, 4) 

		tempfile `xvar'_`per' `xvar'_`per'_R2 

		qui postfile `xvar'_`per'    int ord str25 (yvar stat) double `xvar'_`per' str3 sig using ``xvar'_`per'', replace
		qui postfile `xvar'_`per'_R2 int ord str25 (yvar stat) double `xvar'_`per' using ``xvar'_`per'_R2', replace
		
		local ord = 1 
		foreach varset of local yvarlist{
		post `xvar'_`per'    (`ord') ("`varset'") ("HEADER") (.) ("")
		post `xvar'_`per'_R2 (`ord') ("`varset'") ("HEADER") (.)
		local ord = `ord' + 1 
		
		foreach yvar of local `varset'{
			qui reg `yvar' `xvar' if inrange(quarter, `t')
			
			* Only report if data available for full period
			if e(N) == `n' {
				post `xvar'_`per'_R2 (`ord') ("`yvar'") ("R2") (e(r2_a))
				
				qui newey `yvar' `xvar' if inrange(quarter, `t'), lag(8)
				
				local p = ttail(e(df_r),abs(_b[`xvar']/_se[`xvar']))*2	
				local sig = ""
				if `p' < 0.10 local sig = "*"
				if `p' < 0.05 local sig = "**"
				if `p' < 0.01 local sig = "***"
				
				post `xvar'_`per'    (`ord') ("`yvar'") ("be") (_b[`xvar']) ("`sig'")
				local ord = `ord' + 1 
				post `xvar'_`per'    (`ord') ("`yvar'") ("se") (_se[`xvar']) ("")
				local ord = `ord' + 1 
				}
			else {
				post `xvar'_`per'_R2 (`ord') ("`yvar'") ("R2") (.)
				post `xvar'_`per'    (`ord') ("`yvar'") ("be") (.) ("")
				local ord = `ord' + 1 
				post `xvar'_`per'    (`ord') ("`yvar'") ("se") (.) ("")	
				local ord = `ord' + 1 
				}
		}
		}
	
	postclose `xvar'_`per'  
	postclose `xvar'_`per'_R2  

	preserve
	
	qui use ``xvar'_`per'', clear
	qui tostring `xvar'_`per', format(%10.3f) force replace
	qui replace `xvar'_`per' = `xvar'_`per' + sig
	qui replace `xvar'_`per' = "" if `xvar'_`per' == "." 
	qui replace `xvar'_`per' = "(" + `xvar'_`per' + ")" if stat == "se" 
	qui replace `xvar'_`per' = "" if `xvar'_`per' ==  "()"
	drop sig
	qui save ``xvar'_`per'', replace
	
	qui use ``xvar'_`per'_R2', clear
	qui tostring `xvar'_`per', format(%10.3f) force replace
	qui replace `xvar'_`per' = "" if `xvar'_`per' == "." 
	qui save ``xvar'_`per'_R2', replace
	
	if `count' == 0{
		qui use ``xvar'_`per'', clear
		qui save workdata/betas_trad, replace
		
		qui use ``xvar'_`per'_R2', clear
		qui save workdata/r2_trad, replace
		}
	
	else{
		qui use workdata/betas_trad, clear
		qui merge 1:1 ord yvar stat using ``xvar'_`per'', assert(3) nogen
		qui save workdata/betas_trad, replace

		qui use workdata/r2_trad, clear
		qui merge 1:1 ord yvar stat using ``xvar'_`per'_R2', assert(3) nogen
		qui save workdata/r2_trad, replace
		}
		
	local per = `per' + 1
	local count = `count' + 1
	restore
	}
}

********************************************************************************
*** 4. Compile						:									 	 ***
********************************************************************************
preserve
foreach reg in trad{
	foreach stat in betas r2{ 
		use workdata/`stat'_`reg', clear
		export excel using "Tab1. Phillips Curve Regression Inflation Output.xlsx", sheet(`reg'_`stat') sheetreplace firstrow(variable)
	}
}
restore
