set more off
clear 

* INPUT PATH TO DIRECTORY HERE:
cd ""

* Dates and sample
local latest = tm(2022m9)

/*******************************************************************************
* Set color scheme (optional)
*******************************************************************************/

set scheme s1color

/*******************************************************************************
* Plot results
*******************************************************************************/
use output/sim61, clear

g plotsample = 1 if t>=tm(2020m1) & t<=tm(2024m12)

local title = "Unemployment"
local index = "2a"
preserve
keep if plotsample==1
sum t
local t0 = r(min)
local t1 = `t0'+(5*12)
gen y1 = su61 if t>=`latest'
gen y2 = su61 if t<=`latest'
twoway (line y1 y2 t, ///
lcolor(red midblue black) ///
lpattern(solid solid solid dash .-) ///
lwidth(medthick medthick medthick medthick medthick) ///
title("`title'") ///
xmtick(#19) xlabel(`t0'(12)`t1', format(%tmCY) angle(90)) xline(`latest', lcolor(ebg) lwidth(medthick)) xlabel(,labsize(medium)) ylabel(,labsize(medium) angle(0)) xtitle("") ytitle("") ///
legend(off) xsize(6) ///
saving(output/`index'.gph, replace))
restore

local title = "Headline Inflation, 12-month"
local index = "2b"
preserve
keep if plotsample==1
* For presentation, cut axis below 0 [and above 10]
// replace headline = 0 if headline<0
// replace headline = 20 if headline>20
sum t
local t0 = r(min)
local t1 = `t0'+(5*12)
gen y3 = headlinea61 if t<=`latest'
gen y4 = headlinea61 if t>=`latest' 
label variable y4 "Simulated"
label variable y3 "Actual"
twoway (line y3 y4 t, ///
yline(0, lcolor(ebg)) ///
lcolor(midblue red) ///
lpattern(solid solid dash dash ) ///
lwidth(medthick medthick medthick medthick medthick medthick) ///
title("`title'") ///
xmtick(#19) xlabel(`t0'(12)`t1', format(%tmCY) angle(90)) xline(`latest', lcolor(ebg) lwidth(medthick)) xlabel(,labsize(medium)) ylabel(0(2)10,labsize(medium) angle(0)) xtitle("") ytitle("") ///
legend(row(2) symxsize(6) ring(0) position(11) bmargin(none) region(style(none))) ///
legend(order(1 2)) ///
legend(size(small)) ysize(5) ///
xsize(6) ///
saving(output/`index'.gph, replace))
restore

graph combine output/2a.gph output/2b.gph, row(1)
graph export "Fig2. Unemployment and Inflation for 2 Percent PCE.svg", replace