set more off
clear

* INPUT PATH TO DIRECTORY HERE:
cd ""

* Dates and sample
local latest = tm(2022m9)

/*******************************************************************************
* Set color scheme (optional)
*******************************************************************************/

set scheme s1color

/*******************************************************************************
* Plot results
*******************************************************************************/
* Import and merge data
use workdata/simdata.dta, clear
keep t CORE_12
merge 1:1 t using output/sim28, nogen
merge 1:1 t using output/sim38, nogen
merge 1:1 t using output/sim48, nogen

g plotsample = 1 if t>=tm(2020m1) & t<=tm(2024m12)

format spa* %4.2fc

foreach var in spa28 spa38 spa48{
	replace `var' = . if t < `latest'
}

rename spa28 SEP_spa8
rename spa38 IMF_spa8
rename spa48 HigherU_spa8

label var SEP_spa8 "Conditional on SEP Unemployment Path" 
label var IMF_spa8 "Conditional on IMF Staff Unemployment Path"
label var HigherU_spa8 "Conditional on Higher Unemployment Path"

* Make the plots

local title = ""
local index = 4
preserve
keep if plotsample==1
sum t
local t0 = r(min)
local t1 = `t0'+(5*12)
twoway (line CORE_12 SEP_spa8 IMF_spa8 HigherU_spa8 t, ///
yline(2.5, lcolor(ebg) lwidth(medthick) lpattern(dash)) xline(`latest', lcolor(ebg) lwidth(medthick)) ///
lcolor(blue red red red) ///	
lpattern(solid solid dash shortdash) ///
lwidth(medthick medthick medthick medthick)) ///
(scatter SEP_spa8 t if t==tm(2024m12), mlabposition(12) msize(small) mcolor(black) mfcolor(red) mlabel(SEP_spa8) mlabcolor(black) mlabsize(small)) ///
(scatter IMF_spa8 t if t==tm(2024m12), mlabposition(7) msize(small) mcolor(black) mfcolor(red) mlabel(IMF_spa8) mlabcolor(black) mlabsize(small)) ///
(scatter HigherU_spa8 t if t==tm(2024m12), mlabposition(7) msize(small) mcolor(black) mfcolor(red) mlabel(HigherU_spa8) mlabcolor(black) mlabsize(small) ///
title("`title'", size(medium)) ///
xmtick(#19) xlabel(`t0'(12)`t1', format(%tmCY) angle(90)) xlabel(,labsize(medium)) ylabel(1(1)11,labsize(medium) angle(0)) xtitle("") ytitle("") ///
legend(row(11) symxsize(6) ring(0) position(11) bmargin(none) region(style(none))) ///
legend(order(2 3 4)) ///
legend(size(small)) ysize(5) ///
xsize(6) ///
saving(output/furman1.gph, replace))
graph export "Fig1. Core Inflation Under Alternative Assumptions and Different Unemployment Rates.svg", replace
restore