clear all
set more off
	
global savpath "../output" // save path
global scfpath "../data" // data path

/* Wage gap */
clear
set more off

use "${scfpath}/Wage(earnwt).dta"

collapse lwagegap  , by(year)

gen timeline = year
format %ty timeline

tsset timeline

tsline lwagegap, lc(gs0) xtitle("") ytitle(" ") lwidth(thick)  graphregion(color(white)) bgcolor(white) yscale(r(0.0 0.25))  ylabel(0(0.05)0.25 ,labsize(medlarge)) xlabel(, angle(0) labsize(medlarge))  name("Rawannual" , replace)
graph export "${savpath}/figure_5b.pdf", replace

keep year lwagegap

export excel using "${savpath}/figure_5.xlsx", sheet("wagegap", replace)


/* Unemployment gap */
clear

import excel "${scfpath}/unemploymentgap.xlsx", sheet("unemployment rates") cellrange(A12:F814) firstrow

qui g year = year(observation_date)

collapse  blackwhiteunemploymentgap , by(year)
drop if blackwhiteunemploymentgap >= .
gen timeline = year
format %ty timeline

tsset timeline

tsline blackwhiteunemploymentgap if year >= 1972, lc(gs0) xtitle("") ytitle("unemployment gap") lwidth(thick)   plotregion(color(white)) graphregion(color(white)) bgcolor(white) xlabel(1970(10)2020 , labsize(medlarge)) yscale(r()) ylabel(, angle(0) labsize(medlarge)) ///
ytitle("") xtitle("") name("URannual" , replace)
graph export "${savpath}/figure_5a.pdf", replace

keep if year >= 1972
keep year blackwhiteunemploymentgap

export excel using "${savpath}/figure_5.xlsx", sheet("unemploymentgap", replace)