clear all
set more off
	
global savpath "../output" // save path
global scfpath "../data" // data path

********************************************************************************
* Figure 8
********************************************************************************

set matsize 500

** MODEL SETUP:
local IV ON // ON or empty; deploy LP-IV
local horizon 60 // LP horizons, in months*/
local controls trend dp ffr ffr_d sp500_r_log realm_d ip_log_d cpi_log_d spreadbaa baa_d treasury unrate zlb  /* sp500_r_log house_prices_r_log cpi_log ip_log dp spreadbaa ffr trend  sp500_r_log baa unrate ip_log_d cpi_log_d sp500_r_log house_prices_r_log unrate treasury ffr*/ // controls  or empty
local dependents ugap wagegap sp500_r_log  house_prices_r_log treasury div_r_log cpi_log baa /*ew_w_m_l ew_b_m_l unrate baa mortgage  cpi_log */
local controlslag 1
//local shockseries ns
* choose and run for  rr(Coibion/Romer/Romer), bke (Bernanke/Kuttner), gk(Gertler/Karadi), pp (Pascal Paul)

** LOAD DATA:
clear
import excel using "${scfpath}/MacroData.xls", first case(lower) sheet("Data")
	** PREPARE:
	
		** TIME VARIABLES:
		g time = ym(year, month) 
		drop if time == .
		format time %tm
		tsset time

		foreach shockseries in "rr_ex" {
	
	    **HOUSEKEEPING
		
		replace `shockseries' =. if year>2012 /*projections reach end of sample */
		drop if `shockseries' == bke & year>2008  /*BKE method no longer applicable */

				
		** GENERATE VARIABLES:
		gen crisis=0
		replace crisis = 1 if year==2008 
		replace crisis = 1 if year==2009 
		g zlb = 0
		replace zlb = 1 if year>=2009
		
		g ew_w_m_l = ln(ew_w_m/cpi)
		g ew_b_m_l = ln(ew_w_m/cpi)
		g ew_w_med_l = ln(ew_w_med/cpi)
		g ew_b_med_l = ln(ew_w_med/cpi)
		
		
		g loans_r_log = ln(loans/cpi)
		g loans_r_log_d = d.loans_r_log
		g dp = div / sp500
		g dp_log =ln(div/sp500)
		g house_prices_r_log = ln(house_prices/cpi)
		g sp500_r = sp500/cpi
		g sp500_r_ch = (sp500_r/l.sp500_r-1)*100
		g sp500_log = ln(sp500)
		g sp500_log_d= d.sp500_log
		g sp500_r_log = ln(sp500/cpi)
		g div_r_log=ln(div/cpi)
		g div_log=ln(div)
		g cpi_log = ln(cpi)
		g ffr_d = D.ffr
		g ip_log = ln(ip)
		g ip_log_d = d.ip_log
		g div_r_log_d  = d.div_r_log
		g cpi_log_d=d.cpi_log
		g ffr_r = ffr - cpi_log_d
		g house_prices_r_log_d = d.house_prices_r_log
		g sp500_r_log_d= sp500_r_log-l.sp500_r_log
		g treasury_d = d.treasury
		g spreadbaa_d = d.spreadbaa
		g mortgage_d = d.mortgage
		g baa_d = d.baa
		g unrate_d=d.unrate
		g ugap_d=d.ugap
		g lloans=ln(loans)
		g lloans_d = d.lloans
		g house_prices_log = ln(house_prices)
		g ebp_d=d.ebp
		g vix_d=d.vix
		g trend = _n
		g trend2 = trend*trend
		g trend3 = trend*trend*trend
		g lrealm = ln(realm)
		g realm_d = d.lrealm
		g lm = ln(money)
		g m_d = d.lm
		
		
		
		** GENERATE LAGS OF CONTROLS FOR NEWEY2 COMMAND
		local laggedcontrols ""
		foreach v in `controls'{
			forval i = 1/`=`controlslag'+1'{
				gen L`i'_`v' = l`i'.`v'
				local laggedcontrols = "`laggedcontrols' L`i'_`v'"
			}
		}
		
		disp "`laggedcontrols'"
		
		** GENERATE VARS TO STORE LPs:
		g t_point = 0
		g t_upper = 0
		g t_lower = 0
		g t_p = 0
		g t_obs = 0
		g t_horizon = 0
		g t_zeros = 0
		
		** GET SHOCK SIZE:
		if "`IV'" == "ON" {
			qui sum `shockseries'		
		}
		else {
			qui sum `shockseries'
		}
		local shock = -1
		dis r(sd)
		dis r(mean)
		


** ESTIMATE AND PLOT:
if "`IV'" == "ON" {
	dis as result _skip(5) "First stage:"
	newey  ffr_d `shockseries' `laggedcontrols', lag(2) force
	predict yhat
	corr ffr_d yhat
	
}
foreach D of varlist `dependents' {
	
	if "`D'" == "sp500_r_log"  replace `D' = `D' * 100
	if "`D'" == "house_prices_r_log"  replace `D' = `D' * 100
	if "`D'" == "sp500_r"  replace `D' = `D' * 100
	if "`D'" == "div_r_log"  replace `D' = `D' * 100
	
	dis as result _newline(3) "Analyse `D':"
	
	** ESTIMATE LP:
	dis as result _skip(5) "Estimate local projections..."
	forvalues H = 0/`horizon' {
		dis as result _skip(7) "...for horizon `H'..."
		qui g dep = F`H'.`D' - L.`D'
		if "`IV'" == "ON" {
			qui newey2 dep (ffr_d = `shockseries') `laggedcontrols', lag(2) force
		}
		else {
			qui newey dep `shockseries' `laggedcontrols', lag(2)
		}
		local obs = e(N)
		qui drop dep
		
			** STORE LP PLOT INFORMATION:
		quietly{
				if "`IV'" == "ON" {
					lincom ffr_d
				}
				else {
					lincom `shockseries'
				}
				replace t_point = `shock'*r(estimate) ///
					if _n == `H' + 1
				replace t_upper = `shock'*(r(estimate) + 1.64*r(se)) ///
					if _n == `H' + 1
				replace t_lower = `shock'*(r(estimate) - 1.64*r(se)) ///
					if _n == `H' + 1
				replace t_p = 2*(1-t(e(df_r),abs(r(estimate))/r(se))) ///
					if _n == `H' + 1
				replace t_obs = `obs' ///
					if _n == `H' + 1
				replace t_horizon = `H' if _n == `H' + 1
			}
	}	
	
	if "`D'" == "sp500_r_log" local name = "Stock prices"
	if "`D'" == "sp500_r" local name = "Stock prices"
	if "`D'" == "house_prices_r_log" local name = "House prices"
	if "`D'" == "treasury" local name = "Treasury"
	if "`D'" == "ugap" local name = "Unemployment gap"	  
	if "`D'" == "div_r_log" local name = "Dividends"	
	if "`D'" == "wagegap" local name = "Wage gap"
	if "`D'" == "sp500_r_log"  | "`D'" == "house_prices_r_log" | "`D'" == "div_r_log" local ylab = "percent"
	if "`D'" == "treasury"  | "`D'" == "ugap"  local ylab = "percentage points"

	if "`D'" == "sp500_r_log" local ysc "-5(5)10"
	if "`D'" == "house_prices_r_log" local ysc "-5(5)10"
	if "`D'" == "treasury" local ysc "-2(1)2"
	if "`D'" == "ugap" local ysc "-1(0.5)1"
	if "`D'" == "div_r_log" local ysc "-2(1)2"
	if "`D'" == "wagegap" local ysc "-0.1(0.05)0.1"
	
	** PLOT:
	dis as result _skip(5) "Plot local projections..." 
	twoway 	///
	(rarea t_upper t_lower t_horizon, color(edkblue*0.25)) ///
	(line t_point t_horizon, lcolor(edkblue) lwidth(thick)) ///
	(line t_zeros t_horizon, lcolor(gs4) lwidth(medium)) ///
	if _n <= `horizon'+1 ///
	, graphregion(color(white) margin(zero)) title("`name'", position(12)) ///
	plotregion(lcolor(black) style(none)) ///
	xtitle("months") ytitle("`ylab'", margin(zero)) ///
	ylab(`ysc',angle(90)) xlabel(0(12)60, angle(0)) ///
	legend(off) name(`D', replace)	nodraw
		
    gen irf_`D'_`shockseries' = t_point 
	gen irf_`D'_`shockseries'_lb = t_lower 
	gen irf_`D'_`shockseries'_ub = t_upper
 
}

keep t_horizon irf* 
duplicates drop // for some reason a lot of 0'd out obs
tempfile irf_`shockseries'
export excel t_horizon *ugap* *wagegap* *sp500* *house* *treasury* *div* using "${savpath}/figure_8.xlsx", firstrow(var) replace

** COMBINE AND EXPORT PLOTS:

***FOR REVISED FIGURES ONLY INTERESTED IN A SUBSET OF RESULTS
local dependents ugap wagegap sp500_r_log house_prices_r_log treasury div_r_log

local N : word count `dependents'
scalar cols = min(2, `N')
scalar xsize = 3
scalar ysize = 2
graph combine `dependents' ///
, graphregion(color(white)) altshrink cols(`=cols') ///
xsize(`=xsize') ysize(`=ysize') imargin(b=5 r=10) ///
name(`main', replace)
graph export "${savpath}/figure_8.pdf", replace
}	

********************************************************************************
* Table 3
********************************************************************************

drop *lb *ub 

keep if t_horizon==0 | t_horizon == 6 | t_horizon == 12  | t_horizon == 24 | t_horizon ==  36 | t_horizon == 48 | t_horizon == 60

// rename variables to make reshaping convienent later on
rename (irf_ugap_* irf_wagegap_* irf_sp500_r_log_* irf_house_prices_r_log_* irf_treasury_* irf_div_r_log_* irf_cpi_log_* irf_baa_*) ///
(ugap_* wagegap_* stocks_* houses_* treasury_* div_* cpi_log_* baa_*)

replace t_horizon = . in 8
replace ugap_rr_ex = . in 8
replace wagegap_rr_ex = . in 8
replace stocks_rr_ex = . in 8
replace houses_rr_ex = . in 8
replace treasury_rr_ex = . in 8
replace div_rr_ex = . in 8
replace cpi_log_rr_ex = . in 8
replace baa_rr_ex = . in 8

replace div = div/100 // same scaling as in old version of irfs.xlsx, s.th. replication_scf runs properly

export excel "${scfpath}/irfs.xlsx", cell(A2) sheet("rr_ex") sheetreplace

// Now for dynamic excel formatting
putexcel set "${scfpath}/irfs.xlsx", sheet ("rr_ex") modify 

putexcel A1="t_horizon" B1="Ugap" C1="Wage gap" D1="Stocks" E1="Houses" F1="Treasury" G1="Dividends" H1="cpi_log" I1="baa"

********************************************************************************
* Figure 9
********************************************************************************

set matsize 500
set more off

** MODEL SETUP:
local IV ON // ON or empty; deploy LP-IV
local horizon 60 // LP horizons, in months*/
local controls trend dp ffr ffr_d sp500_r_log realm_d ip_log_d cpi_log_d spreadbaa baa_d treasury unrate zlb  /* sp500_r_log house_prices_r_log cpi_log ip_log dp spreadbaa ffr trend  sp500_r_log baa unrate ip_log_d cpi_log_d sp500_r_log house_prices_r_log unrate treasury ffr*/ // controls  or empty
local dependents ewgap_m ewgap_med /*unrate baa mortgage  cpi_log */
local controlslag 1
//local shockseries ns
* choose and run for  rr(Coibion/Romer/Romer), bke (Bernanke/Kuttner), gk(Gertler/Karadi), pp (Pascal Paul)

foreach shockseries in "rr" {
** LOAD DATA:
clear
import excel using "${scfpath}/MacroData.xls", first case(lower) sheet("Data")
	** PREPARE:
	
		** TIME VARIABLES:
		g time = ym(year, month) 
		drop if time == .
		format time %tm
		tsset time
		
		**HOUSEKEEPING
		
		replace `shockseries' =. if year>2012 /*projections reach end of sample */
		drop if `shockseries' == bke & year>2008  /*BKE method no longer applicable */

		
	
		** GENERATE VARIABLES:
		gen crisis=0
		replace crisis = 1 if year==2008 
		replace crisis = 1 if year==2009 
		g zlb = 0
		replace zlb = 1 if year>=2009
		
		g ew_w_m_l = ln(ew_w_m/cpi)
		g ew_b_m_l = ln(ew_b_m/cpi)
		g ew_w_med_l = ln(ew_w_med/cpi)
		g ew_b_med_l = ln(ew_b_med/cpi)
		
		g ewgap_m = ew_b_m_l/ew_w_m_l
		g ewgap_med = ew_b_med_l / ew_w_med_l
		
		label var ewgap_m "Weekly earnings gap (mean)"
		label var ewgap_med "Weekly earnings gap (median)"
		
		
		g loans_r_log = ln(loans/cpi)
		g loans_r_log_d = d.loans_r_log
		g dp = div / sp500
		g dp_log =ln(div/sp500)
		g house_prices_r_log = ln(house_prices/cpi)
		g sp500_r = sp500/cpi
		g sp500_r_ch = (sp500_r/l.sp500_r-1)*100
		g sp500_log = ln(sp500)
		g sp500_log_d= d.sp500_log
		g sp500_r_log = ln(sp500/cpi)
		g div_r_log=ln(div/cpi)
		g div_log=ln(div)
		g cpi_log = ln(cpi)
		g ffr_d = D.ffr
		g ip_log = ln(ip)
		g ip_log_d = d.ip_log
		g div_r_log_d  = d.div_r_log
		g cpi_log_d=d.cpi_log
		g ffr_r = ffr - cpi_log_d
		g house_prices_r_log_d = d.house_prices_r_log
		g sp500_r_log_d= sp500_r_log-l.sp500_r_log
		g treasury_d = d.treasury
		g spreadbaa_d = d.spreadbaa
		g mortgage_d = d.mortgage
		g baa_d = d.baa
		g unrate_d=d.unrate
		g ugap_d=d.ugap
		g lloans=ln(loans)
		g lloans_d = d.lloans
		g house_prices_log = ln(house_prices)
		g ebp_d=d.ebp
		g vix_d=d.vix
		g trend = _n
		g trend2 = trend*trend
		g trend3 = trend*trend*trend
		g lrealm = ln(realm)
		g realm_d = d.lrealm
		g lm = ln(money)
		g m_d = d.lm
		
		
		
		** GENERATE LAGS OF CONTROLS FOR NEWEY2 COMMAND
		local laggedcontrols ""
		foreach v in `controls'{
			forval i = 1/`=`controlslag'+1'{
				gen L`i'_`v' = l`i'.`v'
				local laggedcontrols = "`laggedcontrols' L`i'_`v'"
			}
		}
		
		disp "`laggedcontrols'"
		
		** GENERATE VARS TO STORE LPs:
		g t_point = 0
		g t_upper = 0
		g t_lower = 0
		g t_horizon = 0
		g t_zeros = 0
		
		** GET SHOCK SIZE:
		if "`IV'" == "ON" {
			qui sum `shockseries'		
		}
		else {
			qui sum `shockseries'
		}
		local shock = -1
		dis r(sd)
		dis r(mean)
		


** ESTIMATE AND PLOT:
if "`IV'" == "ON" {
	dis as result _skip(5) "First stage:"
	newey  ffr_d `shockseries' `laggedcontrols', lag(2) force
	predict yhat
	corr ffr_d yhat
	
}
foreach D of varlist `dependents' {
	
	if "`D'" == "sp500_r_log"  replace `D' = `D' * 100
	if "`D'" == "house_prices_r_log"  replace `D' = `D' * 100
	if "`D'" == "sp500_r"  replace `D' = `D' * 100
	
	
	dis as result _newline(3) "Analyse `D':"
	
	** ESTIMATE LP:
	dis as result _skip(5) "Estimate local projections..."
	forvalues H = 0/`horizon' {
		dis as result _skip(7) "...for horizon `H'..."
		qui g dep = F`H'.`D' - L.`D'
		if "`IV'" == "ON" {
			qui newey2 dep (ffr_d = `shockseries') `laggedcontrols', lag(2) force
		}
		else {
			qui newey dep `shockseries' `laggedcontrols', lag(2)
		}
		local obs = e(N)
		qui drop dep
		
			** STORE LP PLOT INFORMATION:
		quietly{
				if "`IV'" == "ON" {
					lincom ffr_d
				}
				else {
					lincom `shockseries'
				}
				replace t_point = `shock'*r(estimate) ///
					if _n == `H' + 1
				replace t_upper = `shock'*(r(estimate) + 1.64*r(se)) ///
					if _n == `H' + 1
				replace t_lower = `shock'*(r(estimate) - 1.64*r(se)) ///
					if _n == `H' + 1
				replace t_horizon = `H' if _n == `H' + 1
			}
	}	
	
	if "`D'" == "sp500_r_log" local name = "Stock prices"
	if "`D'" == "sp500_r" local name = "Stock prices"
	if "`D'" == "house_prices_r_log" local name = "House prices"
	if "`D'" == "treasury" local name = "Treasury"
	if "`D'" == "ugap" local name = "Unemployment gap"	  
	if "`D'" == "div_r_log" local name = "Dividends"	
	if "`D'" == "wagegap" local name = "Wage gap"
	if "`D'" == "ewgap_m" local name = "Weekly earnings gap (mean)"
	if "`D'" == "ewgap_med" local name = "Weekly earnings gap (median)"
	if "`D'" == "sp500_r_log"  | "`D'" == "house_prices_r_log" local ylab = "percent"
	if "`D'" == "treasury"  | "`D'" == "ugap" | "`D'" == "ewgap_med" | "`D'" == "ewgap_m" local ylab = "percentage points" 

	if "`D'" == "sp500_r_log" local ysc "-10(5)10"
	if "`D'" == "house_prices_r_log" local ysc "-5(5)10"
	if "`D'" == "treasury" local ysc "-1(0.5)1"
	if "`D'" == "ugap" local ysc "-3(0.5)3"
	if "`D'" == "div_r_log" local ysc "-0.1(0.05)0.1"
	if "`D'" == "wagegap" local ysc "-0.1(0.05)0.1"
	if "`D'" == "ewgap_m" local ysc "-0.1(0.05)0.1"
	if "`D'" == "ewgap_med" local ysc "-0.1(0.05)0.1"
	
	** PLOT:
	dis as result _skip(5) "Plot local projections..." 
	twoway 	///
		(rarea t_upper t_lower t_horizon, color(edkblue*0.25)) ///
		(line t_point t_horizon, lcolor(edkblue) lwidth(thick)) ///
		(line t_zeros t_horizon, lcolor(gs4) lwidth(medium)) ///
		if _n <= `horizon'+1 ///
		, graphregion(color(white) margin(zero)) title("`name'", position(12)) ///
		plotregion(lcolor(black) style(none)) ///
		xtitle("months") ytitle("`ylab'", margin(zero)) ///
		ylab(`ysc',angle(90)) xlabel(0(12)60, angle(0)) ///
		legend(off) name(`D', replace)	nodraw
 
	gen irf_`D'_`shockseries' = t_point 
	gen irf_`D'_`shockseries'_lb = t_lower 
	gen irf_`D'_`shockseries'_ub = t_upper
 
}

keep t_horizon irf* 
duplicates drop // for some reason a lot of 0'd out obs
tempfile irf_`shockseries'
export excel using "${savpath}/figure_9.xlsx", firstrow(var) replace

** COMBINE AND EXPORT PLOTS:

***FOR REVISED FIGURES ONLY INTERESTED IN A SUBSET OF RESULTS
local dependents  ewgap_m ewgap_med

local N : word count `dependents'
scalar cols = min(2, `N')
scalar xsize = 2
scalar ysize = 1
graph combine `dependents' ///
, graphregion(color(white)) altshrink cols(`=cols') ///
xsize(`=xsize') ysize(`=ysize') imargin(b=5 r=10) ///
name(`main', replace)
graph export "${savpath}/figure_9.pdf", replace
}	

********************************************************************************
* Figure A5
********************************************************************************

set matsize 500
set more off

** MODEL SETUP:
local IV empty // ON or empty; deploy LP-IV
local horizon 60 // LP horizons, in months*/
local controls trend dp ffr ffr_d sp500_r_log realm_d ip_log_d cpi_log_d spreadbaa baa_d treasury unrate zlb  /* sp500_r_log house_prices_r_log cpi_log ip_log dp spreadbaa ffr trend  sp500_r_log baa unrate ip_log_d cpi_log_d sp500_r_log house_prices_r_log unrate treasury ffr*/ // controls  or empty
local dependents ugap wagegap sp500_r_log house_prices_r_log treasury div_r_log /* ew_w_m_l ew_b_m_l unrate baa mortgage  cpi_log */
local controlslag 1
//local shockseries ns
* choose and run for  rr(Coibion/Romer/Romer), bke (Bernanke/Kuttner), gk(Gertler/Karadi), pp (Pascal Paul)


** LOAD DATA:
clear
import excel using "${scfpath}/MacroData.xls", first case(lower) sheet("Data")
	** PREPARE:
	
		** TIME VARIABLES:
		g time = ym(year, month) 
		drop if time == .
		format time %tm
		tsset time
g ffr_d = D.ffr

		foreach shockseries in "ffr_d" {
	
	**HOUSEKEEPING
		
		replace `shockseries' =. if year>2012 /*projections reach end of sample */
		drop if `shockseries' == bke & year>2008  /*BKE method no longer applicable */

				
	
		** GENERATE VARIABLES:
		gen crisis=0
		replace crisis = 1 if year==2008 
		replace crisis = 1 if year==2009 
		g zlb = 0
		replace zlb = 1 if year>=2009
		
		g ew_w_m_l = ln(ew_w_m/cpi)
		g ew_b_m_l = ln(ew_w_m/cpi)
		g ew_w_med_l = ln(ew_w_med/cpi)
		g ew_b_med_l = ln(ew_w_med/cpi)
		
		
		g loans_r_log = ln(loans/cpi)
		g loans_r_log_d = d.loans_r_log
		g dp = div / sp500
		g dp_log =ln(div/sp500)
		g house_prices_r_log = ln(house_prices/cpi)
		g sp500_r = sp500/cpi
		g sp500_r_ch = (sp500_r/l.sp500_r-1)*100
		g sp500_log = ln(sp500)
		g sp500_log_d= d.sp500_log
		g sp500_r_log = ln(sp500/cpi)
		g div_r_log=ln(div/cpi)
		g div_log=ln(div)
		g cpi_log = ln(cpi)
		
		g ip_log = ln(ip)
		g ip_log_d = d.ip_log
		g div_r_log_d  = d.div_r_log
		g cpi_log_d=d.cpi_log
		g ffr_r = ffr - cpi_log_d
		g house_prices_r_log_d = d.house_prices_r_log
		g sp500_r_log_d= sp500_r_log-l.sp500_r_log
		g treasury_d = d.treasury
		g spreadbaa_d = d.spreadbaa
		g mortgage_d = d.mortgage
		g baa_d = d.baa
		g unrate_d=d.unrate
		g ugap_d=d.ugap
		g lloans=ln(loans)
		g lloans_d = d.lloans
		g house_prices_log = ln(house_prices)
		g ebp_d=d.ebp
		g vix_d=d.vix
		g trend = _n
		g trend2 = trend*trend
		g trend3 = trend*trend*trend
		g lrealm = ln(realm)
		g realm_d = d.lrealm
		g lm = ln(money)
		g m_d = d.lm
		
		
		
		** GENERATE LAGS OF CONTROLS FOR NEWEY2 COMMAND
		local laggedcontrols ""
		foreach v in `controls'{
			forval i = 1/`=`controlslag'+1'{
				gen L`i'_`v' = l`i'.`v'
				local laggedcontrols = "`laggedcontrols' L`i'_`v'"
			}
		}
		
		disp "`laggedcontrols'"
		
		** GENERATE VARS TO STORE LPs:
		g t_point = 0
		g t_upper = 0
		g t_lower = 0
		g t_p = 0
		g t_obs = 0
		g t_horizon = 0
		g t_zeros = 0
		
		** GET SHOCK SIZE:
		if "`IV'" == "ON" {
			qui sum `shockseries'		
		}
		else {
			qui sum `shockseries'
		}
		local shock = -1
		dis r(sd)
		dis r(mean)
		


** ESTIMATE AND PLOT:
if "`IV'" == "ON" {
	dis as result _skip(5) "First stage:"
	newey  ffr_d `shockseries' `laggedcontrols', lag(2) force
	predict yhat
	corr ffr_d yhat
	
}
foreach D of varlist `dependents' {
	
	if "`D'" == "sp500_r_log"  replace `D' = `D' * 100
	if "`D'" == "house_prices_r_log"  replace `D' = `D' * 100
	if "`D'" == "sp500_r"  replace `D' = `D' * 100
	if "`D'" == "div_r_log"  replace `D' = `D' * 100
	
	dis as result _newline(3) "Analyse `D':"
	
	** ESTIMATE LP:
	dis as result _skip(5) "Estimate local projections..."
	forvalues H = 0/`horizon' {
		dis as result _skip(7) "...for horizon `H'..."
		qui g dep = F`H'.`D' - L.`D'
		if "`IV'" == "ON" {
			qui newey2 dep (ffr_d = `shockseries') `laggedcontrols', lag(2) force
		}
		else {
			qui newey dep `shockseries' `laggedcontrols', lag(2)
		}
		local obs = e(N)
		qui drop dep
		
			** STORE LP PLOT INFORMATION:
		quietly{
				if "`IV'" == "ON" {
					lincom ffr_d
				}
				else {
					lincom `shockseries'
				}
				replace t_point = `shock'*r(estimate) ///
					if _n == `H' + 1
				replace t_upper = `shock'*(r(estimate) + 1.64*r(se)) ///
					if _n == `H' + 1
				replace t_lower = `shock'*(r(estimate) - 1.64*r(se)) ///
					if _n == `H' + 1
				replace t_p = 2*(1-t(e(df_r),abs(r(estimate))/r(se))) ///
					if _n == `H' + 1
				replace t_obs = `obs' ///
					if _n == `H' + 1
				replace t_horizon = `H' if _n == `H' + 1
			}
	}	
	
	if "`D'" == "sp500_r_log" local name = "Stock prices"
	if "`D'" == "sp500_r" local name = "Stock prices"
	if "`D'" == "house_prices_r_log" local name = "House prices"
	if "`D'" == "treasury" local name = "Treasury"
	if "`D'" == "ugap" local name = "Unemployment gap"	  
	if "`D'" == "div_r_log" local name = "Dividends"	
	if "`D'" == "wagegap" local name = "Wage gap"
	if "`D'" == "sp500_r_log"  | "`D'" == "house_prices_r_log" | "`D'" == "div_r_log"  local ylab = "percent"
	if "`D'" == "treasury"  | "`D'" == "ugap"  local ylab = "percentage points"
	
	if "`D'" == "sp500_r_log" local ysc "-1(1)4"
	if "`D'" == "house_prices_r_log" local ysc "-1(1)4"
	if "`D'" == "treasury" local ysc "-0.4(0.1)0.1"
	if "`D'" == "ugap" local ysc "-0.4(0.1)0.1"
	if "`D'" == "div_r_log" local ysc "-1(1)2"
	if "`D'" == "wagegap" local ysc "-0.01(0.005)0.01"
	
	** PLOT:
	dis as result _skip(5) "Plot local projections..." 
	twoway 	///
		(rarea t_upper t_lower t_horizon, color(edkblue*0.25)) ///
		(line t_point t_horizon, lcolor(edkblue) lwidth(thick)) ///
		(line t_zeros t_horizon, lcolor(gs4) lwidth(medium)) ///
		if _n <= `horizon'+1 ///
		, graphregion(color(white) margin(zero)) title("`name'", position(12)) ///
		plotregion(lcolor(black) style(none)) ///
		xtitle("months") ytitle("`ylab'", margin(zero)) ///
		ylabel(`ysc', angle(90)) xlabel(0(12)60, angle(0)) ///
		legend(off) name(`D', replace)	nodraw
	
	gen irf_`D'_`shockseries' = t_point 
	gen irf_`D'_`shockseries'_lb = t_lower 
	gen irf_`D'_`shockseries'_ub = t_upper
 
}

keep t_horizon irf* 
duplicates drop // for some reason a lot of 0'd out obs
tempfile irf_`shockseries'
export excel t_horizon *ugap* *wagegap* *sp500* *house* *treasury* *div* using "${savpath}/figure_A5.xlsx", firstrow(var) replace

** COMBINE AND EXPORT PLOTS:

***FOR REVISED FIGURES ONLY INTERESTED IN A SUBSET OF RESULTS
local dependents ugap wagegap sp500_r_log house_prices_r_log treasury div_r_log /*ew_w_m_l ew_b_m_l */

local N : word count `dependents'
scalar cols = min(2, `N')
scalar xsize = 3
scalar ysize = 2
graph combine `dependents' ///
, graphregion(color(white)) altshrink cols(`=cols') ///
xsize(`=xsize') ysize(`=ysize') imargin(b=5 r=10) ///
name(`main', replace)
graph export "${savpath}/figure_A5.pdf", replace
}	

********************************************************************************
* Figure A6
********************************************************************************

set matsize 500
set more off


** MODEL SETUP:
local IV ON // ON or empty; deploy LP-IV
local horizon 60 // LP horizons, in months*/
local controls trend dp ffr ffr_d sp500_r_log realm_d ip_log_d cpi_log_d spreadbaa baa_d treasury unrate zlb  /* sp500_r_log house_prices_r_log cpi_log ip_log dp spreadbaa ffr trend  sp500_r_log baa unrate ip_log_d cpi_log_d sp500_r_log house_prices_r_log unrate treasury ffr*/ // controls  or empty
local dependents   ugap wagegap sp500_r_log  house_prices_r_log /*treasury div_r_log ew_w_m_l ew_b_m_l unrate baa mortgage  cpi_log */
local controlslag 1
//local shockseries 
* choose and run for  rr(Coibion/Romer/Romer), bke (Bernanke/Kuttner), gk(Gertler/Karadi), pp (Pascal Paul)

foreach shockseries in "bke" "pp" "gk" {
** LOAD DATA:
clear
import excel using "${scfpath}/MacroData.xls", first case(lower) sheet("Data")

	** PREPARE:
	
		** TIME VARIABLES:
		g time = ym(year, month) 
		format time %tm
		tsset time
		
		**HOUSEKEEPING
		
		replace `shockseries' =. if year>2012 /*projections reach end of sample */
		drop if `shockseries' == bke & year>2008  /*BKE method no longer applicable */

		
		** GENERATE VARIABLES:
		gen crisis=0
		replace crisis = 1 if year==2008 
		replace crisis = 1 if year==2009 
		g zlb = 0
		replace zlb = 1 if year>=2009
		
		g ew_w_m_l = ln(ew_w_m/cpi)
		g ew_b_m_l = ln(ew_w_m/cpi)
		g ew_w_med_l = ln(ew_w_med/cpi)
		g ew_b_med_l = ln(ew_w_med/cpi)
		
		
		g loans_r_log = ln(loans/cpi)
		g loans_r_log_d = d.loans_r_log
		g dp = div / sp500
		g dp_log =ln(div/sp500)
		g house_prices_r_log = ln(house_prices/cpi)
		g sp500_r = sp500/cpi
		g sp500_r_ch = (sp500_r/l.sp500_r-1)*100
		g sp500_log = ln(sp500)
		g sp500_log_d= d.sp500_log
		g sp500_r_log = ln(sp500/cpi)
		g div_r_log=ln(div/cpi)
		g div_log=ln(div)
		g cpi_log = ln(cpi)
		g ffr_d = D.ffr
		g ip_log = ln(ip)
		g ip_log_d = d.ip_log
		g div_r_log_d  = d.div_r_log
		g cpi_log_d=d.cpi_log
		g ffr_r = ffr - cpi_log_d
		g house_prices_r_log_d = d.house_prices_r_log
		g sp500_r_log_d= sp500_r_log-l.sp500_r_log
		g treasury_d = d.treasury
		g spreadbaa_d = d.spreadbaa
		g mortgage_d = d.mortgage
		g baa_d = d.baa
		g unrate_d=d.unrate
		g ugap_d=d.ugap
		g lloans=ln(loans)
		g lloans_d = d.lloans
		g house_prices_log = ln(house_prices)
		g ebp_d=d.ebp
		g vix_d=d.vix
		g trend = _n
		g trend2 = trend*trend
		g trend3 = trend*trend*trend
		g lrealm = ln(realm)
		g realm_d = d.lrealm
		g lm = ln(money)
		g m_d = d.lm
		
** GENERATE LAGS OF CONTROLS FOR NEWEY2 COMMAND
		local laggedcontrols ""
		foreach v in `controls'{
			forval i = 1/`=`controlslag'+1'{
				gen L`i'_`v' = l`i'.`v'
				local laggedcontrols = "`laggedcontrols' L`i'_`v'"
			}
		}
		
		disp "`laggedcontrols'"
		
		** GENERATE VARS TO STORE LPs:
		g t_point = 0
		g t_upper = 0
		g t_lower = 0
		g t_horizon = 0
		g t_zeros = 0
		
		** GET SHOCK SIZE:
		if "`IV'" == "ON" {
			qui sum `shockseries'		
		}
		else {
			qui sum `shockseries'
		}
		local shock = -1
		*r(sd)
		dis r(sd)
		dis r(mean)
		


** ESTIMATE AND PLOT:
if "`IV'" == "ON" {
	dis as result _skip(5) "First stage:"
	newey  ffr_d `shockseries' `laggedcontrols', lag(2) force
	predict yhat
	corr ffr_d yhat
	*sleep 3000
}
foreach D of varlist `dependents' {
	dis as result _newline(3) "Analyse `D':"
	
	if "`D'" == "sp500_r_log"  replace `D' = `D' * 100
	if "`D'" == "house_prices_r_log"  replace `D' = `D' * 100
	if "`D'" == "sp500_r"  replace `D' = `D' * 100
	
	** ESTIMATE LP:
	dis as result _skip(5) "Estimate local projections..."
	forvalues H = 0/`horizon' {
		dis as result _skip(7) "...for horizon `H'..."
		qui g dep = F`H'.`D' - L.`D'
		if "`IV'" == "ON" {
			qui newey2 dep (ffr_d = `shockseries') `laggedcontrols', lag(2) force
		}
		else {
			qui newey dep `shockseries' `laggedcontrols', lag(2)
		}
		local obs = e(N)
		qui drop dep
		
			** STORE LP PLOT INFORMATION:
			quietly{
				if "`IV'" == "ON" {
					lincom ffr_d
				}
				else {
					lincom `shockseries'
				}
				replace t_point = `shock'*r(estimate) ///
					if _n == `H' + 1
				replace t_upper = `shock'*(r(estimate) + 1.64*r(se)) ///
					if _n == `H' + 1
				replace t_lower = `shock'*(r(estimate) - 1.64*r(se)) ///
					if _n == `H' + 1
				replace t_horizon = `H' if _n == `H' + 1
			}
	}	
	
	
	
	** Save IRF
	gen irf_`D'_`shockseries'0 = t_point 
	gen irf_`D'_`shockseries'1 = t_lower 
	gen irf_`D'_`shockseries'2 = t_upper 
}
	keep t_horizon irf* 
	duplicates drop // for some reason a lot of 0'd out obs
	tempfile irf_`shockseries'
	save `irf_`shockseries'', replace
}

use `irf_bke'
drop if t_horizon == 0 & irf_ugap_bke0 == 0
save "${scfpath}/mainset.dta", replace
use `irf_pp', clear // 0 kommt zerimal vor
drop if t_horizon == 0 & irf_ugap_pp0 == 0
save "${scfpath}/merge1.dta", replace
use `irf_gk', clear // 0 kommt zerimal vor
drop if t_horizon == 0 & irf_ugap_gk0 == 0
save "${scfpath}/merge2.dta", replace
use "${scfpath}/mainset.dta", clear
merge 1:1 t_horizon using "${scfpath}/merge1.dta", nogen
merge 1:1 t_horizon using "${scfpath}/merge2.dta", nogen

erase "${scfpath}/merge1.dta"
erase "${scfpath}/merge2.dta"
erase "${scfpath}/mainset.dta"

/*
foreach shockseries in "pp" "gk" {
	merge 1:1 t_horizon using `irf_`shockseries'', nogen
}	
*/
g t_zeros = 0

*** =ne graph each for stocks, houses, cpi_log ugap with the IRFs for all shocks 
*** (no confidence intervals). So one chart for the stock response showing  
*** lines for the effects on stocks, houses, ugap.

foreach meas in "sp500_r_log" "house_prices_r_log"  "ugap" "wagegap" /*"treasury" "div_r_log"*/ {
if "`meas'" == "sp500_r_log"{
local title "Stock prices"
}
if "`meas'" == "house_prices_r_log"{
local title "House prices"
}
*if "`meas'" == "treasury"{
*local title "Treasury yield"
*}
if "`meas'" == "ugap"{
local title "Unemployment gap"
}
if "`meas'" == "wagegap"{
local title "Wage gap"
}
*if "`meas'" == "div_r_log"{
*local title "Dividends"
*}
if "`meas'" == "sp500_r_log"  | "`meas'" == "house_prices_r_log" /*| "`meas'" == "div_r_log" */ local ylab = "percent"
if /*"`meas'" == "treasury"  |*/ "`meas'" == "ugap" | "`meas'" == "wagegap"   local ylab = "percentage points"

grstyle init
grstyle set color economist

twoway 	///
	(line irf_`meas'_pp0 t_horizon, lwidth(thick)) ///
	(line irf_`meas'_bke0 t_horizon, lwidth(thick) lp(dash)) ///
	(line irf_`meas'_gk0 t_horizon, lwidth(thick) lp(shortdash)) ///
	(line t_zeros t_horizon, lcolor(gs4) lwidth(medium)) ///
	, graphregion(color(white) margin(zero)) title("`title'") ///
	plotregion(lcolor(black) style(none)) ///
	xtitle("") ytitle("`ylab'", margin(zero)) ///
	ylabel(#5, angle(90)) xlabel(0(12)60, angle(0)) ///
	leg (pos(6) r(1) order( ///
	1 "PP shocks" 2 "BK shocks" 3 "GK shocks" )) ///
	name("`meas'", replace)	
}	

ren *0 *
drop *1 *2 t_zeros
export excel *ugap* *wagegap* *sp500* *house* using "${savpath}/figure_A6.xlsx", firstrow(var) replace

***FOR REVISED FIGURES ONLY INTERESTED IN A SUBSET OF RESULTS
local dependents ugap wagegap sp500_r_log house_prices_r_log /*  treasury div_r_log ew_w_m_l ew_b_m_l */

local N : word count `dependents'
scalar cols = min(2, `N')
scalar xsize = 2.5
scalar ysize = 2
graph combine `dependents' ///
,graphregion(color(white)) altshrink cols(`=cols') ///
xsize(`=xsize') ysize(`=ysize') imargin(b=5 r=5)/*imargin(right=vlarge)*/ ///
name(lp_iv_allshocks, replace)
graph export "${savpath}/figure_A6.pdf", replace
