clear
set more off
set trace off

/* Choose for which population the analysis is done
0 : All households (baseline)
1 : Single women
2 : Single men
*/
global SUBGROUP = 1

use "../data/newvars.dta", clear

label define laborforcestatus 1 "employed" 2 "unemployed" 3 "out of the labor force" 

foreach pgroup in head spouse { 
	gen laborforcestatus`pgroup'_orig = laborforcestatus`pgroup'
	recode laborforcestatus`pgroup' (11/15 = 1) (16/17 = 2) (20 = 2) (21 = 3) (22 = 3) (23 = 3) (24 = 3) (30 = 2) (50/85 = 3) (90 = 1) (96 = 1) (97 = 3)
	label values laborforcestatus`pgroup' laborforcestatus
	}

keep year id impnum unemployed laborincome laborforcestatus*

tempfile unempdata
save `unempdata'

use "../data/HSCF_2019.dta" , clear

merge 1:1 year id impnum using `unempdata'
keep if _merge == 3
drop _merge
replace marstat = 1 if marstatdetail == 4

if(${SUBGROUP} == 1) {
	/* Sample selection only single females */
	keep if sexh == 2 & marstat == 0
	}
	
if(${SUBGROUP} == 2) {
	/* Sample selection only single males */
	keep if sexh == 1 & marstat == 0
	}

/* Keep only black and white households */
drop if raceh == 0

/* Last 12 months unemployed */
recode unemployed (1 = 1) (5 = 0)
/* Current unemployment */
gen currentunemployed = (laborforcestatushead == 2)

label define unemployed_lbl 1 "unemployed" 0 "not unemployed"
label value  unemployed currentunemployed unemployed_lbl
ren blackh black
ren wgtI95W95 wgt1

sum ffanw if black == 1 & unemployed == 1 [aw = wgt1], d

version 16: table black unemployed if inrange(age,25,55) [aw = wgt1], c(mean laborincome)
/* Means */
version 16: table black currentunemployed if inrange(age,25,55) & laborforcestatushead <= 2 [aw = wgt1], c(mean ffanw mean ffanfin mean vehi mean ffafin /* mean debt*/ count ffanw)
/* Medians*/
version 16: table black currentunemployed if inrange(age,25,55) & laborforcestatushead <= 2 [aw = wgt1], c(p50 ffanw p50 ffanfin p50 vehi p50 ffafin  /*p50 debt*/ count ffanw)
/* Medians for past 12 months unemployment */
version 16: table black unemployed if inrange(age,25,55) & laborforcestatushead <= 2 [aw = wgt1], c(p50 ffanw p50 ffanfin p50 vehi p50 ffafin  /*p50 debt*/ count ffanw)

tabstat unemployed [aw = wgt1], by(race)

/* Get unemployment gap estimates */
preserve
clear
import excel "../data/irfs.xlsx", sheet("rr_ex") cellrange(A1:B9) firstrow clear
keep if inlist(t_horizon, 0, 12,24,36,48,60)
sort t_horizon
gen year = round(t_horizon /12)
drop t_horizon
rename Ugap RomerRomer
/* Multiply unemployment gap by minus -1 for later calculation of employment effect */
replace RomerRomer = - RomerRomer
mkmat RomerRomer, matrix(unemploymenteffect) rownames(year)
restore

matrix colnames unemploymenteffect = "Romer & Romer"
matrix rownames unemploymenteffect = "year 0" "year 1" "year 2" "year 3" "year 4" "year 5"
matrix list unemploymenteffect



if(${SUBGROUP} == 0) {
	 
	matrix earnignseffect_abs = J(6,1,.)
	matrix colnames earnignseffect_abs = "Romer & Romer" 
	matrix rownames earnignseffect_abs = "year 0" "year 1" "year 2" "year 3" "year 4" "year 5"

	matrix earnignseffect_rel = J(6,1,.)
	matrix colnames earnignseffect_rel = "Romer & Romer"
	matrix rownames earnignseffect_rel = "year 0" "year 1" "year 2" "year 3" "year 4" "year 5"
	
	local res_string = "" 
	}
else if(${SUBGROUP} == 1) {
	 
	matrix earnignseffect_abs = J(6,1,.)
	matrix colnames earnignseffect_abs = "Romer & Romer"  
	matrix rownames earnignseffect_abs = "year 0" "year 1" "year 2" "year 3" "year 4" "year 5"

	matrix earnignseffect_rel = J(6,1,.)
	matrix colnames earnignseffect_rel = "Romer & Romer"
	matrix rownames earnignseffect_rel = "year 0" "year 1" "year 2" "year 3" "year 4" "year 5"
	
	local res_string = "_singlewomen" 
	}
else if(${SUBGROUP} == 2) {
		 
	matrix earnignseffect_abs = J(6,1,.)
	matrix colnames earnignseffect_abs = "Romer & Romer"
	matrix rownames earnignseffect_abs = "year 0" "year 1" "year 2" "year 3" "year 4" "year 5"

	matrix earnignseffect_rel = J(6,1,.)
	matrix colnames earnignseffect_rel = "Romer & Romer"
	matrix rownames earnignseffect_rel = "year 0" "year 1" "year 2" "year 3" "year 4" "year 5"

	local res_string = "_singlemen" 
	}
	
	
local nshock = colsof(unemploymenteffect)
	
/* i year index */	
forvalues i = 1(1)6 {
    /* j shock series index */
	forvalues j = 1(1)`nshock' {
		quietly {
			sum laborincome if black == 1 & unemployed == 1 & inrange(age,25,55) [aw = wgt1]
			local unempl_black_labinc = `r(mean)'
			sum laborincome if black == 1 & unemployed == 0 & inrange(age,25,55) [aw = wgt1]
			local empl_black_labinc = `r(mean)'
			sum unemployed if black == 1 & inrange(age,25,55) [aw = wgt1]
			local black_urate = `r(mean)'
			sum laborincome if black == 1 & inrange(age,25,55) [aw = wgt1]
			local earningslevel_alt = `r(mean)'
			
			local monetarypolicyDelta = unemploymenteffect[`i',`j'] * 0.01
			
			/* Earnings gains */
			local earningsgain_ph = (`empl_black_labinc' - `unempl_black_labinc') 
			local earningsgain = `earningsgain_ph' * `monetarypolicyDelta'
			local earningslevel = `empl_black_labinc' * (1 - `black_urate') + `unempl_black_labinc' * `black_urate'
			
			matrix earnignseffect_abs[`i',`j'] = `earningsgain'
			matrix earnignseffect_rel[`i',`j'] = `earningsgain'/`earningslevel'
			}
		}
	}
	
display "Average earnings gain per household (in $)" %8.1f `earningsgain_ph' _newline /*
	 */ "Average labor income of black households  " %8.1f `earningslevel' " alternative " %8.1f `earningslevel_alt'


putexcel set "../data/earningseffect`res_string'.xlsx" , sheet("earningseffect") replace

matrix list unemploymenteffect

putexcel A1=matrix(unemploymenteffect) , names
putexcel A1=("Negative unemployment gap shock")

matrix list earnignseffect_abs

putexcel A8=matrix(earnignseffect_abs) , names
putexcel A8=("Earnings effect in dollar")

matrix list earnignseffect_rel

putexcel A15=matrix(earnignseffect_rel) , names
putexcel A15=("Earnings effect in percent of income")
