clear all
set more off
	
global savpath "../output" // save path
global scfpath "../data" // data path

********************************************************************************
* Table 1
********************************************************************************	
	
use if year == 2019 using "${scfpath}/HSCF_2019.dta", clear
merge 1:1 year id impnum using "${scfpath}/newvars.dta"
keep if _merge==3
mi unset, asis

drop if raceh == 0

replace wgtI95W95 = wgtI95W95 * 1000

qui g housing = house + nnresre + oresre // oest is net position
replace equity = equity + ffabus

qui g housing_int = housing if housing > 0 
qui g housing_ext = housing > 0 if !mi(housing)

* oest is net position
qui replace ffaass = ffaass + oestdebt
qui replace tdebt = tdebt + oestdebt
* egen ffaass_new = rowtotal(liq cds nmmf stocks bond retqliq savbnd cashli othma othfin vehic houses oresre nnresre bus othnfin)
* DEBT=MRTHEL+RESDBT+OTHLOC+CCBAL+INSTALL+ODEBT
* ASSET=FIN+NFIN = LIQ+CDS+NMMF+STOCKS+BOND+RETQLIQ+SAVBND+CASHLI+OTHMA+OTHFIN   +   VEHIC+HOUSES+ORESRE+NNRESRE+BUS+OTHNFIN
* subtract indirect holdings via savings
qui replace liqcer = liqcer - ind_bnd_savings - ind_equ_savings

drop ffanfin
qui egen ffanfin = rowtotal(vehi onfin)

qui egen aux_assets = rowtotal(all_bonds housing equity ffanfin liqcer)

qui g ffaothfin = ffaass - aux_assets // includes ofin and life

replace ffaothfin = 0 if inrange(ffaothfin, -150, -1) // rounding error

replace ffanw = ffaass - tdebt

foreach v in all_bonds housing equity ffanfin liqcer ffaothfin ffanw tdebt tinc {
	qui g has_`v' = `v' > 0 if !mi(`v')
	local means = "`means' mean_`v' = `v' has_`v' = has_`v'"
	local medians = "`medians' median_`v' = `v'"
}

collapse (mean) `means' (median) `medians' [aw=wgtI95W95], by(blackh)

tostring blackh, replace force
replace blackh = "_white" if blackh == "0"
replace blackh = "_black" if blackh == "1"

reshape long mean median has, i(blackh) j(asset) str
replace mean = round(mean)
replace median = round(median)
replace has = round(has,0.01) * 100
reshape wide mean median has, i(asset) j(blackh) str

g order = .
replace order = 1 if asset == "_all_bonds"
replace order = 3 if asset == "_equity"
replace order = 2 if asset == "_housing"
replace order = 4 if asset == "_ffanfin"
replace order = 7 if asset == "_ffanw"
replace order = 6 if asset == "_ffaothfin"
replace order = 5 if asset == "_liqcer"
replace order = 8 if asset == "_tdebt"
replace order = 9 if asset == "_tinc"

replace asset = "Bonds" if asset == "_all_bonds"
replace asset = "Equity" if asset == "_equity"
replace asset = "Housing" if asset == "_housing"
replace asset = "Other non-financial assets" if asset == "_ffanfin"
replace asset = "Net wealth" if asset == "_ffanw"
replace asset = "Other financial assets" if asset == "_ffaothfin"
replace asset = "Liquid assets" if asset == "_liqcer"
replace asset = "Debt" if asset == "_tdebt"
replace asset = "Income" if asset == "_tinc"

sort order
drop order
order asset mean_white mean_black median_white median_black has_white has_black

replace has_white = . if asset == "Net wealth" | asset == "Debt" | asset == "Income"
replace has_black = . if asset == "Net wealth" | asset == "Debt" | asset == "Income"

foreach j of numlist 1/9 {
	foreach v in asset mean_white mean_black median_white median_black has_white has_black {
		qui levelsof `v' if _n == `j', clean
		if "`v'" != "has_black" local end = "&"
		else local end = ""
		local line`j' = `"`line`j'' `r(levels)' `end' "'
	}
}

export excel using "${savpath}/table_1.xlsx", firstrow(var) replace

********************************************************************************
* Figure 2
********************************************************************************	
	
use if year == 2019 using "${scfpath}/HSCF_2019.dta", clear
merge 1:1 year id impnum using "${scfpath}/newvars.dta"
keep if _merge==3
mi unset, asis

drop if raceh == 0

replace wgtI95W95 = wgtI95W95 * 1000

qui g housing = house + nnresre + oresre // oest is net position
replace equity = equity + ffabus

* oest is net position
qui replace ffaass = ffaass + oestdebt
qui replace tdebt = tdebt + oestdebt
* subtract indirect holdings via savings
qui replace liqcer = liqcer - ind_bnd_savings - ind_equ_savings

drop ffanfin
qui egen ffanfin = rowtotal(vehi onfin)

qui egen aux_assets = rowtotal(all_bonds housing equity ffanfin liqcer)

qui g ffaothfin = ffaass - aux_assets // includes ofin and life

replace ffaothfin = 0 if inrange(ffaothfin, -150, -1) // rounding error

foreach v in all_bonds housing equity ffanfin liqcer ffaothfin {
	qui g pshare_`v' = `v' / ffaass * 100
}

collapse pshare* [aw=wgtI95W95], by(blackh)

label def label_blackh_c 0 "white", modify
label val blackh label_blackh_c

grstyle init
grstyle set color edkblue emidblue eltblue ebblue navy gs10

graph bar pshare_all_bonds pshare_housing pshare_equity pshare_liqcer pshare_ffaothfin pshare_ffanfin, ///
over(blackh, gap(*1)) ///
legend(row(2) lab(1 "bonds") lab(2 "housing") lab(3 "equity") ///
lab(4 "liquid assets") lab(5 "other financial assets") lab(6 "non-financial assets")) ///
plotregion(color(white)) graphregion(color(white)) bgcolor(white) ///
ylabel(, angle(0) labsize(large)) xsize(12) ytitle("percent") name("portfolio_by_race_average_rat", replace)
graph export "${savpath}/figure_2.pdf", replace	

export excel blackh pshare_all_bonds pshare_housing pshare_equity pshare_liqcer pshare_ffaothfin pshare_ffanfin using "${savpath}/figure_2", replace firstrow(var)

********************************************************************************
* Figures 3 and A1
********************************************************************************
	
use "${scfpath}/HSCF_2019.dta", clear
mi unset, asis

drop if raceh == 0

* drop outliers from imputation (id == "19510501" | id == "19511580" | id == "19512188" | id == "19530750")
replace ffanw = . if yearmerge == 1953 & blackh == 1 & ffanw > 1500000
* drop outliers from imputation (19490073 19491564 19491877 19493216 19495489 19495496 19495504 19500507 19500936)
replace ffanw = . if yearm == 1950 & blackh == 0 & ffanw > 10000000 

qui egen ofin_life = rowtotal(ofin life)
qui egen equ_bus = rowtotal(ffabus ffaequ oman mfun)
qui egen house_oest = rowtotal(house oest)
qui egen vehi_onfin = rowtotal(vehi onfin)
qui g homeequ = house_oest - hdebt

foreach var in ffanw tinc equ_bus house_oest { 
    
	preserve

	winsor2 `var', cuts(1 99) by(year blackh) replace

	collapse `var' (median) `var'_med=`var' [aw=wgtI95W95], by(yearmerge blackh)

	reshape wide `var' `var'_med, i(year) j(blackh)

	sort year

	g rat = `var'1 / `var'0 * 100
	g rat_med = `var'_med1 / `var'_med0 * 100	 
	
	if "`var'" == "ffanw" {
		local yl = "5(5)30"
		local yr = "2.5 30"
		local nme = "figure_3a"
	}
	if "`var'" == "tinc" {
		local yl = "30(10)80"
		local yr = "30 80"
		local nme = "figure_3b"
	}
	if "`var'" == "equ_bus" {
		local yl = "-5(5)20"
		local yr = "-5 20"
		local nme = "figure_A1a"
	}
	if "`var'" == "house_oest" {
		local yl = "10(10)50"
		local yr = "10 55"
		local nme = "figure_A1b"
	}

	twoway ///
	connected rat yearmerge, lc(gs0) msym(o) msize(large) mfc(gs0) mlc(gs0) ///
	plotregion(color(white)) graphregion(color(white)) bgcolor(white) ///
	xlabel(1950(3)2019, angle(45)) yscale(r(`yr')) ylabel(`yl', angle(0)) ///
	ytitle("percent") xtitle("") xsize(7) name("`var'_rat_over_time", replace)
	graph export "${savpath}/`nme'.pdf", replace
	
	if "`var'" == "tinc" ren rat income_ratio
	if "`var'" == "ffanw" ren rat wealth_ratio
	if "`var'" == "equ_bus" ren rat equ_bus_ratio
	if "`var'" == "house_oest" ren rat housing_ratio
	
	if "`var'" == "tinc" {
		export excel yearmerge income_ratio using "${savpath}/figure_3a", cell(A1) sheet("over time") sheetmodify firstrow(var)
	}
	if "`var'" == "ffanw" {
		export excel wealth_ratio using "${savpath}/figure_3b", cell(C1) sheet("over time") sheetmodify firstrow(var)
	}
	if "`var'" == "equ_bus" {
		export excel yearmerge equ_bus_ratio using "${savpath}/figure_A1", cell(A1) sheet("over time") sheetmodify firstrow(var)
	}
	if "`var'" == "house_oest" {
		export excel housing_ratio using "${savpath}/figure_A1", cell(C1) sheet("over time") sheetmodify firstrow(var)
	}
	
	restore
	
} // var

********************************************************************************
* Figures 4 and A2
********************************************************************************	

qui use "${scfpath}/HSCF_2019.dta", clear

drop if raceh == 0

* drop outliers from imputation (id == "19510501" | id == "19511580" | id == "19512188" | id == "19530750")
replace ffanw = . if yearmerge == 1953 & blackh == 1 & ffanw > 1500000
* drop outliers from imputation (19490073 19491564 19491877 19493216 19495489 19495496 19495504 19500507 19500936)
replace ffanw = . if yearm == 1950 & blackh == 0 & ffanw > 10000000 

g equbuspen = ffaequ + mfun + oman + ffabus + pen

collapse (mean) /*wti*/ ffanw equbuspen tinc [aw=wgtI95W95], by(yearmerge blackh)

qui gen wti = ffanw / tinc

qui g ffanw_cf = ffanw

foreach j of numlist 0/1 {
	qui sum equbuspen if year == 1971 & blackh == `j'
	qui replace ffanw_cf = ffanw_cf - equbuspen + `r(mean)' if year > 1971 & blackh == `j'
	}

qui gen wti_cf = ffanw_cf / tinc

	foreach v in ffanw wti wti_cf {
	g `v'_rel = .
		foreach g in 0 1 {
		qui sum `v' if inrange(yearmerge, 1971, 1971) & blackh == `g'
		replace `v'_rel = `v' - r(mean) if blackh == `g'
		}
	}

replace ffanw_rel = ffanw_rel / 10000

twoway ///
connected ffanw_rel yearmerge if blackh == 0, lc(gs0) msym(o) msize(large) mfc(gs16) mlc(gs0) || ///
connected ffanw_rel yearmerge if blackh == 1, lc(gs0) msym(o) msize(large) mfc(gs0) mlc(gs0)  ///
plotregion(color(white)) graphregion(color(white)) bgcolor(white) ///
xlabel(1950(3)2019, angle(45)) yscale(r()) ylabel(, angle(0)) ///
legend( lab(1 "white") lab(2 "black") symxsize(6)) ///
ytitle("10,000 dollars") xtitle("") name("ffanw_rel", replace)
graph export "${savpath}/figure_4a.pdf", replace

twoway ///
connected wti_rel yearmerge if blackh == 0, lc(gs0) msym(o) msize(large) mfc(gs16) mlc(gs0) || ///
connected wti_rel yearmerge if blackh == 1, lc(gs0) msym(o) msize(large) mfc(gs0) mlc(gs0)  ///
plotregion(color(white)) graphregion(color(white)) bgcolor(white) ///
xlabel(1950(3)2019, angle(45)) yscale(r(0 4)) ylabel(0(1)4, angle(0)) ///
legend( lab(1 "white") lab(2 "black") symxsize(6)) ///
ytitle("") xtitle("") name("wti_rel", replace)
graph export "${savpath}/figure_4b.pdf", replace

export excel yearmerge blackh ffanw_rel wti_rel using "${savpath}/figure_4", replace firstrow(var)
	
twoway ///
connected wti_cf_rel yearmerge if blackh == 0, lc(gs0) msym(o) msize(large) mfc(gs16) mlc(gs0) || ///
connected wti_cf_rel yearmerge if blackh == 1, lc(gs0) msym(o) msize(large) mfc(gs0) mlc(gs0)  ///
plotregion(color(white)) graphregion(color(white)) bgcolor(white) ///
xlabel(1950(3)2019, angle(45)) yscale(r(0 4)) ylabel(0(1)4, angle(0)) ///
legend( lab(1 "white") lab(2 "black") symxsize(6)) ///
ytitle("") xtitle("") name("wti_cf_rel", replace)
graph export "${savpath}/figure_A2.pdf", replace

export excel yearmerge blackh wti_cf_rel using "${savpath}/figure_A2", replace firstrow(var)

********************************************************************************
* Figure A4
********************************************************************************

qui use "${scfpath}/HSCF_2019.dta", clear

drop if raceh == 0

preserve
collapse bshare = blackh [aw=wgtI95W95], by(yearmerge)
replace bshare = bshare * 100
tempfile bshare
save `bshare'
restore

ren (ffanw ffanwgroups) (wealth wealthgroups)

foreach v in wealth {
	
	preserve
	
	qui levelsof yearmerge, clean local (mys)
	
	collapse blackh [aw=wgtI95W95], by(yearmerge `v'groups)

	merge m:1 yearmerge using `bshare'

	replace blackh = blackh * 100 - bshare
	
	grstyle init
	grstyle set color economist

	twoway ///
	connected blackh yearmerge if `v'groups == 1, msym(o) msize(large) || ///
	connected blackh yearmerge if `v'groups == 2, msym(s) msize(medlarge) || ///
	connected blackh yearmerge if `v'groups == 3, msym(d) msize(medlarge) ///
	plotregion(color(white)) graphregion(color(white)) bgcolor(white) ///
	xlabel(1950(3)2019, angle(45)) yscale(r()) ylabel(, angle(0)) ///
	leg(lab(1 "bottom 50%") lab(2 "50% - 90%") lab(3 "top 10%") row(1)) ///
	ytitle("percentage points") xtitle("") name("black_share_`v'_dist", replace)
	graph export "${savpath}/figure_A4.pdf", replace
	
	ren blackh rel_share
	export excel yearmerge rel_share `v'groups using "${savpath}/figure_A4", replace firstrow(var)
	
	restore
	
}

********************************************************************************
* Figures 6, 7, 11, 15 and A.7
********************************************************************************	

* import IRF data
import excel using "${scfpath}/irfs.xlsx", sheet("rr_ex") firstrow clear
qui sum Treasury if t_horizon == 12
global treasyldRR = - `r(mean)' / 100
qui sum baa if t_horizon == 12
global corpyldRR = - `r(mean)' / 100
qui sum Dividends if t_horizon == 12
global diviRR = `r(mean)' 
	
use if year == 2019 using "${scfpath}/HSCF_2019.dta", clear
merge 1:1 year id impnum using "${scfpath}/newvars.dta"
keep if _merge==3
mi unset, asis

drop if raceh == 0

foreach v of varlist *mort? *payment* {
	replace `v' = `v' / CPI
}

global p_inc_equity = 10
global p_inc_housing = 10
global p_inc_bond_all_state_muni = 10
global p_inc_bond_all_mb = 10
global p_inc_bond_all_gov = 10
global p_inc_bond_all_corp_for = 10
global interestchange = 100
global inflationchange = 10

/*
notxbnd		state and municipal + other tax-exempt bonds 
mortbnd		mortgage-backed bonds
govtbnd		US government or treasury bills
obnd		corporate and foreign bonds

tfbmutf		tax-free bond mutual funds (municipal)
gbmutf		government and government-sponsored bond mutual funds
obmutf		other bond mutual funds (corporate and foreign)
*/

replace wgtI95W95 = wgtI95W95 * 1000

drop bnd savbnd

rename notxbnd	bond_state_muni
rename mortbnd 	bond_mb
rename govtbnd 	bond_gov
rename obnd 	bond_corp_for

rename tfbmutf	bmutf_state_muni
rename obmutf 	bmutf_corp_for

qui egen bonds = rowtotal(bond_*)

* note: already in 2019 prices
qui g FFA_bond_gov = 19426.0 * 1000000000 // L.210 FL893061105 All sectors; Treasury securities; asset https://www.federalreserve.gov/apps/fof/DisplayTable.aspx?t=L.210
qui g FFA_bond_mb = 9628.5 * 1000000000 // L.211 FL893061705 All sectors; agency- and GSE-backed securities; asset https://www.federalreserve.gov/apps/fof/DisplayTable.aspx?t=L.211
qui g FFA_bond_state_muni = 4151.7 * 1000000000 // L.212, FL893062005 All sectors; municipal securities; asset https://www.federalreserve.gov/apps/fof/DisplayTable.aspx?t=L.212
qui g FFA_bond_corp_for = 14228.4 * 1000000000 // L.213, FL893063005 All sectors; corporate and foreign bonds; asset https://www.federalreserve.gov/apps/fof/DisplayTable.aspx?t=L.213

qui egen FFA_bonds = rowtotal(FFA_bond_*)

* allocate government and government-sponsored bond mutual funds
egen aux_mb_gov = rowtotal(FFA_bond_mb FFA_bond_gov) // rowtotal(bond_mb bond_gov)

g FFA_bond_mb_share = FFA_bond_mb / aux_mb_gov
qui sum FFA_bond_mb_share [aw=wgtI95W95]
qui g av_FFA_bond_mb_share = `r(mean)'

g FFA_bond_gov_share = FFA_bond_gov / aux_mb_gov
qui sum FFA_bond_gov_share [aw=wgtI95W95]
qui g av_FFA_bond_gov_share = `r(mean)'

egen check = rowtotal(av_*)
qui sum check
	if `r(mean)' != 1 {
	exit
	}
	else drop check
	
qui g bmutf_mb = gbmutf * av_FFA_bond_mb_share
qui g bmutf_gov = gbmutf * av_FFA_bond_gov_share

qui drop *share aux* gbmutf

	foreach v of varlist FFA_bond_* {
	qui g av_`v'_share = `v' / FFA_bonds
	}

egen check = rowtotal(av_*)
qui sum check
	if `r(mean)' != 1 {
	exit
	}
	else drop check
	
	foreach v of varlist miscbmutf ind_bnd_* {
		foreach group in state_muni mb gov corp_for {
		g aux_`v'_`group' = `v' * av_FFA_bond_`group'_share
		}
	}

	foreach group in state_muni mb gov corp_for {
	*ds bond_`group' bmutf_`group' aux_*_`group'
	egen bond_all_`group' = rowtotal(bond_`group' bmutf_`group' aux_*_`group')
	}
	
qui drop *share aux* miscbmutf ind_bnd_*

g housing = house + nnresre + oresre // oest is net position
replace equity = equity + ffabus

	foreach asset of varlist equity housing bond_all* {
	g cg_`asset' = `asset' * ${p_inc_`asset'} / 100 // if ffanw > 0
	}
	
qui egen cg_all_bonds = rowtotal(cg_bond_all*)
	
	foreach j of numlist 1/3 {
	g int_gain_mort`j' = $interestchange / 10000 * mort`j' * remaining_dur`j'
	}

	foreach j of numlist 1/2 {
	g int_gain_oest_mort`j' = $interestchange / 10000 * oest_mort`j' * oest_remaining_dur`j'
	}

qui egen int_gain = rowtotal(int_gain_*) // if ffanw > 0
qui egen tot_gain = rowtotal(cg_equity cg_housing cg_all_bonds int_gain)
egen payments = rowtotal(payment? oest_payment?) // if ffanw > 0
egen new_payments = rowtotal(new_payment? new_oest_payment?) // if ffanw > 0
egen RR_new_payments = rowtotal(RR_new_payment? RR_new_oest_payment?)

* general_ 100 bp; specific: RR response for BAA and treasury yield after 1 year 
* new rollover fraction: ISSUANCE - CHANGE IN OUTSTANDING as % of OUTSTANDING, 
* 10y average, from SIFA: 13.4% of corporate bonds and 20.6% MBS turnover in a year 
qui gen int_loss_gen = - $interestchange / 10000 * liqcer - 0.01 * (0.134 * bond_all_corp_for + 0.206 * bond_all_mb) // if ffanw > 0
qui gen int_loss_spec = - $interestchange / 10000 * liqcer - ${corpyldRR} * 0.134 * bond_all_corp_for -  ${treasyldRR}  * 0.206 * bond_all_mb // if ffanw > 0

g housing_int = housing if housing > 0
g int_gain_int = int_gain if int_gain > 0

g homeowner = housing > 0 if !mi(housing)
g gainer = int_gain > 0 if !mi(int_gain)

foreach vrs in "" "_40_60" {
	
	preserve

	if "`vrs'" == "_40_60" {
		
		qui xtile ffanw_dec_b = ffanw if blackh == 1 [aw=wgtI95W95], nq(5)	
		qui xtile ffanw_dec_w = ffanw if blackh == 0 [aw=wgtI95W95], nq(5)
		qui keep if inrange(ffanw_dec_b, 3, 3) | inrange(ffanw_dec_w, 3, 3)
		
	}	

	collapse (rawsum) pop=wgtI95W95 (mean) homeowner gainer housing_int int_gain_int ///
	(sum) *payments incdivi cg_* int_gain int_loss* tot_gain ffanw tinc [pw=wgtI95W95], by(blackh)

	qui sum homeowner if blackh == 0
	qui g pop_owners_cf = pop * `r(mean)'
	qui g housing_cf_ext = housing_int * pop_owners_cf
	qui g cg_housing_cf_ext = housing_cf_ext * ${p_inc_housing} / 100 

	qui sum gainer if blackh == 0
	qui g pop_gainers_cf = pop * `r(mean)'
	qui g int_gain_cf_ext = int_gain_int * pop_gainers_cf

	qui egen tot_gain_cf_ext = rowtotal(cg_equity cg_housing_cf_ext cg_all_bonds int_gain_cf_ext)


	qui sum housing_int if blackh == 0
	g housing_int_cf = `r(mean)'
	qui g housing_cf_int = housing_int_cf * pop * homeowner
	qui g cg_housing_cf_int = housing_cf_int * ${p_inc_housing} / 100 

	qui sum int_gain_int if blackh == 0
	g int_gain_int_cf = `r(mean)'
	qui g int_gain_cf_int = int_gain_int_cf * pop * gainer

	qui egen tot_gain_cf_int = rowtotal(cg_equity cg_housing_cf_int cg_all_bonds int_gain_cf_int)

	g pay_diff = -(new_payments - payments) + 0.01*incdivi
	g RR_pay_diff = -(RR_new_payments - payments) + ${diviRR}*incdivi
	qui drop incdivi

	foreach cg of varlist cg_* int_gain int_loss* tot_gain* *pay_diff {
		g rel_`cg' = `cg' / tinc * 100 // ffanw * 100
	}	

	foreach v in pay_diff RR_pay_diff ///
		cg_housing cg_equity cg_all_bonds int_gain tot_gain ///
		cg_bond_all_state_muni cg_bond_all_mb cg_bond_all_gov cg_bond_all_corp_for ///
		cg_housing_cf_ext tot_gain_cf_ext cg_housing_cf_int tot_gain_cf_int int_loss_gen int_loss_spec {
		g pc_`v' = `v' / pop
	}
		
	mi unset, asis
	g aux = 1
	drop ffanw tinc pop

	drop *payments homeowner housing_int* pop_*_cf housing_cf* gainer 

	reshape wide cg_* rel_cg_* pc_cg_* *int_gain* *int_loss* *tot_gain* *pay_diff*, i(aux) j(blackh)

	* counterfactuals

	if "`vrs'" == "" {
		graph bar ///
		pc_cg_housing0 pc_cg_housing1 pc_cg_housing_cf_ext1 pc_cg_housing_cf_int1, ///
		bar(1, color(white) lc(gs0) lwidth(thin)) bar(2, color(gs0) lc(gs0) lwidth(thin)) ///
		bar(3, color(gs8) lc(gs0) lwidth(thin)) bar(4, color(gs12) lc(gs0) lwidth(thin)) ///
		plotregion(color(white)) graphregion(color(white)) bgcolor(white) yscale(r()) ///
		legend(lab(1 "white") lab(2 "black") lab(3 "black, CF ext.") lab(4 "black, CF int.") symxsize(5)) ///
		ylabel(, angle(0)) ytitle("Gain from 10% price change in % of group income") name("rel_cg_housing_pc_bw", replace) xsize(5)
		graph export "${savpath}/figure_A7a.pdf", replace

		graph bar ///
		rel_cg_housing0 rel_cg_housing1 rel_cg_housing_cf_ext1 rel_cg_housing_cf_int1, ///
		bar(1, color(white) lc(gs0) lwidth(thin)) bar(2, color(gs0) lc(gs0) lwidth(thin)) ///
		bar(3, color(gs8) lc(gs0) lwidth(thin)) bar(4, color(gs12) lc(gs0) lwidth(thin)) ///
		plotregion(color(white)) graphregion(color(white)) bgcolor(white) yscale(r()) ///
		legend(lab(1 "white") lab(2 "black") lab(3 "black, CF ext.") lab(4 "black, CF int.") symxsize(5)) ///
		ylabel(, angle(0)) ytitle("Gain from 10% price change in % of group income") name("rel_cg_housing_rel_bw", replace) xsize(5)
		graph export "${savpath}/figure_A7b.pdf", replace

		export excel pc_cg_housing0 pc_cg_housing1 pc_cg_housing_cf_ext1 pc_cg_housing_cf_int1 using "${savpath}/figure_A7.xlsx", firstrow(var) sheet("per_capita") replace 
		export excel rel_cg_housing0 rel_cg_housing1 rel_cg_housing_cf_ext1 rel_cg_housing_cf_int1 using "${savpath}/figure_A7.xlsx", firstrow(var) sheetmodify sheet("rel_to_income")
	}

		foreach v of varlist *0 {
		local hlp = subinstr("`v'", "0", "", .)
		rename `v' w_`hlp'
		}
		
		foreach v of varlist *1 {
		local hlp = subinstr("`v'", "1", "", .)
		rename `v' b_`hlp'
		}
		
	reshape long w_rel_cg b_rel_cg w_cg b_cg w_pc_cg b_pc_cg, i(aux) j(asset) string

	g aux_cat = .
	replace aux_cat = 1 if _n == 1
	replace aux_cat = 2 if _n == 2

	label def aux_cat_lab 1 "gain from mortgage interest change + dividends" 2 "loss from savings + bond interest change", replace
	label val aux_cat aux_cat_lab

	g aux_cat_all = .
	replace aux_cat_all = 1 if _n == 1
	replace aux_cat_all = 2 if _n == 2

	label def aux_cat_all_lab 1 "gain from mortgage interest change + dividends" ///
							  2 "loss from savings + bond interest change" , replace
	label val aux_cat_all aux_cat_all_lab

	* interest

	qui g 		w_rel_combi = w_rel_pay_diff if aux_cat == 1
	qui replace w_rel_combi = w_rel_int_loss_gen if aux_cat == 2
	qui g 		b_rel_combi = b_rel_pay_diff if aux_cat == 1
	qui replace b_rel_combi = b_rel_int_loss_gen if aux_cat == 2

	if "`vrs'" == "" {
		graph bar ///
		w_rel_cg b_rel_cg if inlist(asset, "_housing", "_equity", "_all_bonds"), ///
		over(asset, gap(*0.5) relabel(1 "bonds" 2 "equity" 3 "housing")) ///
		bar(1, color(white) lc(gs0) lwidth(thin)) bar(2, color(gs0) lc(gs0) lwidth(thin)) ///
		plotregion(color(white)) graphregion(color(white)) bgcolor(white) yscale(r()) ///
		legend(lab(1 "white") lab(2 "black") symxsize(5)) ///
		ylabel(, angle(0)) ytitle("Capital gain in % of group income") name("cg_heb_rel_tinc_bw", replace) xsize(5)
		graph export "${savpath}/figure_6b.pdf", replace

		graph bar ///
		w_pc_cg b_pc_cg if inlist(asset, "_housing", "_equity", "_all_bonds"), ///
		over(asset, gap(*0.5) relabel(1 "bonds" 2 "equity" 3 "housing")) ///
		bar(1, color(white) lc(gs0) lwidth(thin)) bar(2, color(gs0) lc(gs0) lwidth(thin)) ///
		plotregion(color(white)) graphregion(color(white)) bgcolor(white) yscale(r()) ///
		legend(lab(1 "white") lab(2 "black") symxsize(5)) ///
		ylabel(, angle(0)) ytitle("Capital gain per household") name("cg_heb_bw", replace) xsize(5)
		graph export "${savpath}/figure_6a.pdf", replace

		export excel asset w_pc_cg b_pc_cg using "${savpath}/figure_6.xlsx" if inlist(asset, "_housing", "_equity", "_all_bonds"), firstrow(var) sheet("per_capita") replace 
		export excel asset w_rel_cg b_rel_cg using "${savpath}/figure_6.xlsx" if inlist(asset, "_housing", "_equity", "_all_bonds"), firstrow(var) sheetmodify sheet("rel_to_income")
			

		local yl = "-.6(.2).8"
		local ys = "-.6 .8"

		splitvallabels aux_cat, length(20)
		graph bar ///
		w_rel_combi b_rel_combi, ///
		over(aux_cat, gap(*0.5) relabel(`r(relabel)')) ///
		bar(1, color(white) lc(gs0) lwidth(thin)) bar(2, color(gs0) lc(gs0) lwidth(thin)) ///
		bar(3, color(white) lc(gs0) lwidth(thin)) bar(4, color(gs0) lc(gs0) lwidth(thin)) ///
		plotregion(color(white)) graphregion(color(white)) bgcolor(white) yscale(r(`ys')) ///
		legend(lab(1 "white") lab(2 "black") order( 1 2) symxsize(5)) ///
		ylabel(`yl', angle(0)) ytitle("In % of group income") name("pay_diff_int_loss_rel_bw", replace) xsize(5)	
		graph export "${savpath}/figure_7b.pdf", replace

		qui g 		w_pc_combi = w_pc_pay_diff if aux_cat == 1
		qui replace w_pc_combi = w_pc_int_loss_gen if aux_cat == 2
		qui g 		b_pc_combi = b_pc_pay_diff if aux_cat == 1
		qui replace b_pc_combi = b_pc_int_loss_gen if aux_cat == 2

		local yl = "-600(200)800"
		local ys = "-600 800"

		splitvallabels aux_cat, length(20)
		graph bar ///
		w_pc_combi b_pc_combi, ///
		over(aux_cat, gap(*0.5) relabel(`r(relabel)')) ///
		bar(1, color(white) lc(gs0) lwidth(thin)) bar(2, color(gs0) lc(gs0) lwidth(thin)) ///
		bar(3, color(white) lc(gs0) lwidth(thin)) bar(4, color(gs0) lc(gs0) lwidth(thin)) ///
		plotregion(color(white)) graphregion(color(white)) bgcolor(white) yscale(r(`ys')) ///
		legend(lab(1 "white") lab(2 "black") symxsize(5)) ///
		ylabel(`yl', angle(0)) ytitle("Per household") name("pay_diff_int_loss_pc_bw", replace) xsize(5)
		graph export "${savpath}/figure_7a.pdf", replace

		export excel aux_cat w_pc_combi b_pc_combi using "${savpath}/figure_7.xlsx", firstrow(var) sheet("per_capita") replace 
		export excel aux_cat w_rel_combi b_rel_combi using "${savpath}/figure_7.xlsx", firstrow(var) sheetmodify sheet("rel_to_income")
	}

	* all shocks jointly

	qui g 		w_pc_combi_all = w_pc_RR_pay_diff if aux_cat_all == 1
	qui replace w_pc_combi_all = w_pc_int_loss_spec if aux_cat_all == 2
	qui g 		b_pc_combi_all = b_pc_RR_pay_diff if aux_cat_all == 1
	qui replace b_pc_combi_all = b_pc_int_loss_spec if aux_cat_all == 2

	local yl = "-600(200)600"
	local ys = "-600 600"

	splitvallabels aux_cat_all, length(20)
	graph bar ///
	w_pc_combi_all b_pc_combi_all, ///
	over(aux_cat_all, gap(*1) relabel(`r(relabel)')) ///
	bar(1, color(white) lc(gs0) lwidth(thin)) bar(2, color(gs0) lc(gs0) lwidth(thin)) ///
	bar(3, color(white) lc(gs0) lwidth(thin)) bar(4, color(gs0) lc(gs0) lwidth(thin)) ///
	plotregion(color(white)) graphregion(color(white)) bgcolor(white) yscale(r(`ys')) ///
	legend(lab(1 "white") lab(2 "black") symxsize(5)) ///
	ylabel(`yl', angle(0)) ytitle("Per household") name("all_pay_diff_int_loss_pc_bw", replace) xsize(5)
	if "`vrs'" == "" {
		graph export "${savpath}/figure_11.pdf", replace
		export excel aux_cat_all w_pc_combi_all b_pc_combi_all using "${savpath}/figure_11.xlsx", firstrow(var) replace
	}
	else if "`vrs'" == "_40_60" {
		graph export "${savpath}/figure_15.pdf", replace
		export excel aux_cat_all w_pc_combi_all b_pc_combi_all using "${savpath}/figure_15.xlsx", firstrow(var) replace
	}
	
	restore
	
} // vrs

********************************************************************************
* Figures 10, 13, 14 and A.3
********************************************************************************	
clear all

grstyle init
grstyle set color economist

foreach vrs in "" "_40_60" "_40_60_agg" "_40_60_agg_tinc" {
		
global maxhorizon = 5
global duration_corp = 7.07
global duration_treasury = 9.47
global duration_mbs = 5.43

import excel using "${scfpath}/irfs.xlsx", sheet("rr_ex") firstrow clear
	
drop if inlist(t_horizon, 6, 18)
replace t_horizon = t_horizon / 12
rename t_horizon Horizon

drop *Wagegap* *Ugap*

g Shock = "RR" 

rename (Stocks Houses baa Treasury cpi_log) ///
(sp hp corpyield treasuryyield inflation)

foreach v in inflation {
	replace `v' = `v' * 100
}

tostring Horizon, replace
replace Horizon = Horizon + "Y"

* MS: use treasury yield
qui g interest = treasuryyield

tempfile irfs_joint
save `irfs_joint', replace

if "`vrs'" != "_40_60_agg" local types = "RR" // "BK RR GK"
if strpos("`vrs'", "_40_60_agg") > 0 local types = "RR"

	foreach shocktype in `types'  { // BK RR GK // Paul 
	
	use if year == 2019 using "${scfpath}/HSCF_2019.dta", clear
	*collapse blackh [aw=wgtI95W95], by(ffanwgroups)
	
	drop if raceh == 0
	
	if "`vrs'" == "_40_60" {
		qui xtile ffanw_dec_b = ffanw if blackh == 1 [aw=wgtI95W95], nq(5)	
		qui xtile ffanw_dec_w = ffanw if blackh == 0 [aw=wgtI95W95], nq(5)
		qui keep if inrange(ffanw_dec_b, 3, 3) | inrange(ffanw_dec_w, 3, 3)
	}		
	if "`vrs'" == "_40_60_agg" {
		qui xtile ffanw_dec = ffanw [aw=wgtI95W95], nq(5)	
		*sum blackh [aw=wgtI95W95]
		qui keep if inrange(ffanw_dec, 3, 3)
		*di "no. in P40-P60:"
		*count if blackh == 1 & impnum == 1
		*count if blackh == 0 & impnum == 1
		*sum blackh [aw=wgtI95W95]
	}	
	if "`vrs'" == "_40_60_agg_tinc" {
		qui xtile tinc_dec = tinc [aw=wgtI95W95], nq(5)	
		*sum blackh [aw=wgtI95W95]
		qui keep if inrange(tinc_dec, 3, 3)
		*di "no. in P40-P60:"
		*count if blackh == 1 & impnum == 1
		*count if blackh == 0 & impnum == 1
		*sum blackh [aw=wgtI95W95]
	}	
	
	merge 1:1 year id impnum using "${scfpath}/newvars.dta"
	keep if _merge==3
	drop _merge
	mi unset, asis	

		foreach v of varlist *mort? *payment* {
		replace `v' = `v' / CPI
		}

		foreach spec of numlist 0/$maxhorizon {
		
		preserve
		
		use `irfs_joint', clear
		
		keep if Shock == "`shocktype'"		
		
		keep if Horizon == "`spec'Y"
		
		drop Shock
		
		qui ds Horizon, not
		
		qui levelsof sp, local(p_inc_equity)
		qui levelsof hp, local(p_inc_housing)
		qui levelsof interest, local(interestchange)
		qui levelsof inflation, local(inflationchange)
		
		* duration: % change in value for 1pp change in yield
		qui g corppchange = - $duration_corp * corpyield - `inflationchange'
		qui levelsof corppchange, local(p_inc_bond_all_corp_for)
		qui g govpchange = - $duration_treasury * treasuryyield - `inflationchange'
		qui levelsof govpchange, local(p_inc_bond_all_gov)
		local p_inc_bond_all_state_muni = `p_inc_bond_all_gov'
		qui g mbpchange = - $duration_mbs * corpyield - `inflationchange'
		qui levelsof mbpchange, local(p_inc_bond_all_mb)
		
		restore
		
		preserve

		replace wgtI95W95 = wgtI95W95 * 1000

		drop bnd savbnd

		rename notxbnd	bond_state_muni
		rename mortbnd 	bond_mb
		rename govtbnd 	bond_gov
		rename obnd 	bond_corp_for

		rename tfbmutf	bmutf_state_muni
		rename obmutf 	bmutf_corp_for

		qui egen bonds = rowtotal(bond_*)

		* note: already in 2019 prices
		qui g FFA_bond_gov = 19426.0 * 1000000000 // L.210 FL893061105 All sectors; Treasury securities; asset https://www.federalreserve.gov/apps/fof/DisplayTable.aspx?t=L.210
		qui g FFA_bond_mb = 9628.5 * 1000000000 // L.211 FL893061705 All sectors; agency- and GSE-backed securities; asset https://www.federalreserve.gov/apps/fof/DisplayTable.aspx?t=L.211
		qui g FFA_bond_state_muni = 4151.7 * 1000000000 // L.212, FL893062005 All sectors; municipal securities; asset https://www.federalreserve.gov/apps/fof/DisplayTable.aspx?t=L.212
		qui g FFA_bond_corp_for = 14228.4 * 1000000000 // L.213, FL893063005 All sectors; corporate and foreign bonds; asset https://www.federalreserve.gov/apps/fof/DisplayTable.aspx?t=L.213

		qui egen FFA_bonds = rowtotal(FFA_bond_*)

		* allocate government and government-sponsored bond mutual funds
		egen aux_mb_gov = rowtotal(FFA_bond_mb FFA_bond_gov) // rowtotal(bond_mb bond_gov)

		g FFA_bond_mb_share = FFA_bond_mb / aux_mb_gov
		qui sum FFA_bond_mb_share [aw=wgtI95W95]
		qui g av_FFA_bond_mb_share = `r(mean)'

		g FFA_bond_gov_share = FFA_bond_gov / aux_mb_gov
		qui sum FFA_bond_gov_share [aw=wgtI95W95]
		qui g av_FFA_bond_gov_share = `r(mean)'

		egen check = rowtotal(av_*)
		qui sum check
			if `r(mean)' != 1 {
			exit
			}
			else drop check
			
		qui g bmutf_mb = gbmutf * av_FFA_bond_mb_share
		qui g bmutf_gov = gbmutf * av_FFA_bond_gov_share

		qui drop *share aux* gbmutf

			foreach v of varlist FFA_bond_* {
			qui g av_`v'_share = `v' / FFA_bonds
			}

		egen check = rowtotal(av_*)
		qui sum check
			if `r(mean)' != 1 {
			exit
			}
			else drop check
			
			foreach v of varlist miscbmutf ind_bnd_* {
				foreach group in state_muni mb gov corp_for {
				g aux_`v'_`group' = `v' * av_FFA_bond_`group'_share
				}
			}

			foreach group in state_muni mb gov corp_for {
			*ds bond_`group' bmutf_`group' aux_*_`group'
			egen bond_all_`group' = rowtotal(bond_`group' bmutf_`group' aux_*_`group')
			}
			
		qui drop *share aux* miscbmutf ind_bnd_*

		g housing = house + nnresre + oresre // oest is net position
		replace equity = equity + ffabus

			foreach asset of varlist equity housing bond_all* {
			g cg_`asset' = `asset' * `p_inc_`asset'' / 100 // if ffanw > 0
			}
			
		qui egen cg_all_bonds = rowtotal(cg_bond_all*)
			
		qui egen tot_gain = rowtotal(cg_equity cg_housing cg_all_bonds) // int_gain int_loss_liqcer
		
		qui g share_below_1 = (tot_gain/tinc*100) < 1 if !mi(tot_gain)
		qui g share_below_5 = (tot_gain/tinc*100) < 5 if !mi(tot_gain)
		
		qui replace share_below_1 = share_below_1 * 100
		qui replace share_below_5 = share_below_5 * 100

		collapse (mean) share_below* (rawsum) pop=wgtI95W95 (sum) cg_equity cg_housing cg_all_bonds *tot_gain ///
		/*inflation_effect*/ tinc ffanw [pw=wgtI95W95], by(blackh) // int_gain int_loss_liqcer

			foreach cg of varlist cg_equity cg_housing cg_all_bonds tot_gain ///
			{ // inflation_effect int_gain int_loss_liqcer 
			g rel_`cg' = `cg' / tinc * 100 // ffanw * 100
			}	

			foreach v in cg_equity cg_housing cg_all_bonds tot_gain ///
			{ // inflation_effect int_gain int_loss_liqcer 
			g pc_`v' = `v' / pop
			}
			
		mi unset, asis
		g aux = 1
		drop tinc
		
		g horizon = `spec'
		
		tempfile interim`spec'
		save `interim`spec''
		
		restore
		
		} // spec
		
	clear

		foreach spec of numlist 0/$maxhorizon {
		append using `interim`spec''	
		}

	label def label_blackh_c 0 "W" 1 "B", modify
	label val blackh label_blackh_c

	label def label_h 0 "0 years" 1 "1 year" 2 "2 years" 3 "3 years" 4 "4 years" 5 "5 years", replace
	label val horizon label_h
	
	qui g new_wealth = ffanw + tot_gain
	qui g new_wealth_rel = (ffanw + tot_gain) / ffanw * 100
	
	if "`vrs'" == "" {
		export excel horizon blackh *tot* using "${scfpath}/total_effect`vrs'.xlsx", ///
		sheet("`shocktype'") firstrow(var) sheetmodify
	}
	
	preserve
	
	keep ffanw new_wealth blackh horizon share_below* pop*
	reshape wide ffanw new_wealth share_below* pop*, i(horizon) j(blackh) 
	
	qui rename (share_below_10 share_below_50 share_below_11 share_below_51) ///
	(share_below_1_w share_below_5_w share_below_1_b share_below_5_b)
	
	if "`vrs'" == "" {
		export excel horizon share_below* using "${savpath}/share_small_effect`vrs'.xlsx", ///
		sheet("`shocktype'") firstrow(var) sheetmodify
	}
	
	restore
	
	graph bar ///
	pc_cg_equity pc_cg_housing pc_cg_all_bonds, stack ///
	over(blackh, gap(*1)) over(horizon, gap(*0.8) label(labsize(medsmall))) ///
	plotregion(color(white)) graphregion(color(white)) bgcolor(white) yscale(r()) ///
	legend(lab(1 "equity effect") lab(2 "housing effect") lab(3 "bond effect") symxsize(5) row(1)) ///
	ylabel(, angle(0)) ytitle("Total net gain per household") ///
	name("pc_`shocktype'`vrs'", replace) xsize(5)
	if "`vrs'" == "" {
		graph export "${savpath}/figure_10.pdf", replace
		export excel blackh pc_cg_equity pc_cg_housing pc_cg_all_bonds using "${savpath}/figure_10.xlsx", firstrow(var) replace
	}
	else if "`vrs'" == "_40_60" {
		graph export "${savpath}/figure_13.pdf", replace
		export excel blackh pc_cg_equity pc_cg_housing pc_cg_all_bonds using "${savpath}/figure_13.xlsx", firstrow(var) replace 
	}
	else if "`vrs'" == "_40_60_agg" {
		graph export "${savpath}/figure_14a.pdf", replace
		export excel blackh pc_cg_equity pc_cg_housing pc_cg_all_bonds using "${savpath}/figure_14a.xlsx", firstrow(var) replace
	}	
	else if "`vrs'" == "_40_60_agg_tinc" {
		graph export "${savpath}/figure_14b.pdf", replace
		export excel blackh pc_cg_equity pc_cg_housing pc_cg_all_bonds using "${savpath}/figure_14b.xlsx", firstrow(var) replace
	}
	
	if "`vrs'" == "_40_60_agg" {
		graph bar ///
		rel_cg_equity rel_cg_housing rel_cg_all_bonds, stack ///
		over(blackh, gap(*1)) over(horizon, gap(*0.8) label(labsize(medsmall))) ///
		plotregion(color(white)) graphregion(color(white)) bgcolor(white) yscale(r()) ///
		legend(lab(1 "equity effect") lab(2 "housing effect") lab(3 "bond effect") symxsize(5) row(1)) ///
		ylabel(, angle(0)) ytitle("Total net gain per household") ///
		name("rel_`shocktype'`vrs'", replace) xsize(5)
		graph export "${savpath}/figure_A3.pdf", replace
		export excel blackh rel_cg_equity rel_cg_housing rel_cg_all_bonds using "${savpath}/figure_A3.xlsx", firstrow(var) replace
	}

	} // shocktype
	
} // vrs

********************************************************************************
* Figures A8 and A10
********************************************************************************
	
global maxhorizon = 5
global duration_corp = 7.07
global duration_treasury = 9.47
global duration_mbs = 5.43

import excel using "${scfpath}/irfs.xlsx", sheet("rr_ex") firstrow clear
	
drop if inlist(t_horizon, 6, 18)
replace t_horizon = t_horizon / 12
rename t_horizon Horizon

drop *Wagegap* *Ugap*

g Shock = "RR" 

rename (Stocks Houses baa Treasury cpi_log) ///
(sp hp corpyield treasuryyield inflation)

foreach v in inflation {
	replace `v' = `v' * 100
}

tostring Horizon, replace
replace Horizon = Horizon + "Y"

* MS: use treasury yield
qui g interest = treasuryyield

tempfile irfs_joint
save `irfs_joint', replace

	foreach shocktype in RR { // BK RR GK // Paul 
	
	use if year == 2019 using "${scfpath}/HSCF_2019.dta", clear
	*collapse blackh [aw=wgtI95W95], by(ffanwgroups)	
	
	*keep if ageh < 65 // inrange(ageh, 25, 64)

	replace marstat = 1 if marstatdetail == 4 & marstat == 0
	drop if raceh == 0
	
	if "`midgroups'" == "_40_60" {
		qui xtile ffanw_dec_b = ffanw if blackh == 1 [aw=wgtI95W95], nq(5)	
		qui xtile ffanw_dec_w = ffanw if blackh == 0 [aw=wgtI95W95], nq(5)
		qui keep if inrange(ffanw_dec_b, 3, 3) | inrange(ffanw_dec_w, 3, 3)
		*qui keep if inrange(ffanw_dec_b, 4, 7) | inrange(ffanw_dec_w, 4, 7)
	}			
	
	merge 1:1 year id impnum using "${scfpath}/newvars.dta"
	keep if _merge==3
	drop _merge
	mi unset, asis

		foreach v of varlist *mort? *payment* {
		replace `v' = `v' / CPI
		}

		foreach spec of numlist 0/$maxhorizon {
		
		preserve
		
		use `irfs_joint', clear
		
		keep if Shock == "`shocktype'"		
		
		keep if Horizon == "`spec'Y"
		
		drop Shock
		
		qui ds Horizon, not
		
		*replace sp = sp/3	
			
		qui levelsof sp, local(p_inc_equity)
		qui levelsof hp, local(p_inc_housing)
		qui levelsof interest, local(interestchange)
		qui levelsof inflation, local(inflationchange)
		
		qui g corppchange = - $duration_corp * corpyield - `inflationchange'
		qui levelsof corppchange, local(p_inc_bond_all_corp_for)
		qui g govpchange = - $duration_treasury * treasuryyield - `inflationchange'
		qui levelsof govpchange, local(p_inc_bond_all_gov)
		local p_inc_bond_all_state_muni = `p_inc_bond_all_gov'
		qui g mbpchange = - $duration_mbs * corpyield - `inflationchange'
		qui levelsof mbpchange, local(p_inc_bond_all_mb)
		
		restore
		
		preserve

		replace wgtI95W95 = wgtI95W95 * 1000

		drop bnd savbnd

		rename notxbnd	bond_state_muni
		rename mortbnd 	bond_mb
		rename govtbnd 	bond_gov
		rename obnd 	bond_corp_for

		rename tfbmutf	bmutf_state_muni
		rename obmutf 	bmutf_corp_for

		qui egen bonds = rowtotal(bond_*)

		* note: already in 2019 prices
		qui g FFA_bond_gov = 19426.0 * 1000000000 // L.210 FL893061105 All sectors; Treasury securities; asset https://www.federalreserve.gov/apps/fof/DisplayTable.aspx?t=L.210
		qui g FFA_bond_mb = 9628.5 * 1000000000 // L.211 FL893061705 All sectors; agency- and GSE-backed securities; asset https://www.federalreserve.gov/apps/fof/DisplayTable.aspx?t=L.211
		qui g FFA_bond_state_muni = 4151.7 * 1000000000 // L.212, FL893062005 All sectors; municipal securities; asset https://www.federalreserve.gov/apps/fof/DisplayTable.aspx?t=L.212
		qui g FFA_bond_corp_for = 14228.4 * 1000000000 // L.213, FL893063005 All sectors; corporate and foreign bonds; asset https://www.federalreserve.gov/apps/fof/DisplayTable.aspx?t=L.213

		qui egen FFA_bonds = rowtotal(FFA_bond_*)

		* allocate government and government-sponsored bond mutual funds
		egen aux_mb_gov = rowtotal(FFA_bond_mb FFA_bond_gov) // rowtotal(bond_mb bond_gov)

		g FFA_bond_mb_share = FFA_bond_mb / aux_mb_gov
		qui sum FFA_bond_mb_share [aw=wgtI95W95]
		qui g av_FFA_bond_mb_share = `r(mean)'

		g FFA_bond_gov_share = FFA_bond_gov / aux_mb_gov
		qui sum FFA_bond_gov_share [aw=wgtI95W95]
		qui g av_FFA_bond_gov_share = `r(mean)'

		egen check = rowtotal(av_*)
		qui sum check
			if `r(mean)' != 1 {
			exit
			}
			else drop check
			
		qui g bmutf_mb = gbmutf * av_FFA_bond_mb_share
		qui g bmutf_gov = gbmutf * av_FFA_bond_gov_share

		qui drop *share aux* gbmutf

			foreach v of varlist FFA_bond_* {
			qui g av_`v'_share = `v' / FFA_bonds
			}

		egen check = rowtotal(av_*)
		qui sum check
			if `r(mean)' != 1 {
			exit
			}
			else drop check
			
			foreach v of varlist miscbmutf ind_bnd_* {
				foreach group in state_muni mb gov corp_for {
				g aux_`v'_`group' = `v' * av_FFA_bond_`group'_share
				}
			}

			foreach group in state_muni mb gov corp_for {
			*ds bond_`group' bmutf_`group' aux_*_`group'
			egen bond_all_`group' = rowtotal(bond_`group' bmutf_`group' aux_*_`group')
			}
			
		qui drop *share aux* miscbmutf ind_bnd_*

		g housing = house + nnresre + oresre // oest is net position
		replace equity = equity + ffabus

			foreach asset of varlist equity housing bond_all* {
			g cg_`asset' = `asset' * `p_inc_`asset'' / 100 // if ffanw > 0
			}
			
		qui egen cg_all_bonds = rowtotal(cg_bond_all*)
			
		qui egen tot_gain = rowtotal(cg_equity cg_housing cg_all_bonds) // int_gain int_loss_liqcer
		
		qui g share_below_1 = (tot_gain/tinc*100) < 1 if !mi(tot_gain)
		qui g share_below_5 = (tot_gain/tinc*100) < 5 if !mi(tot_gain)
		
		qui replace share_below_1 = share_below_1 * 100
		qui replace share_below_5 = share_below_5 * 100
		
		********************************************************************************
		*** race ***
		********************************************************************************

		collapse (mean) share_below* (rawsum) pop=wgtI95W95 (sum) cg_equity cg_housing cg_all_bonds *tot_gain ///
		/*inflation_effect*/ tinc ffanw [pw=wgtI95W95], by(blackh marstat) // int_gain int_loss_liqcer

			foreach cg of varlist cg_equity cg_housing cg_all_bonds tot_gain ///
			{ // inflation_effect int_gain int_loss_liqcer 
			g rel_`cg' = `cg' / tinc * 100 // ffanw * 100
			}	

			foreach v in cg_equity cg_housing cg_all_bonds tot_gain ///
			{ // inflation_effect int_gain int_loss_liqcer 
			g pc_`v' = `v' / pop
			}
			
		mi unset, asis
		g aux = 1
		drop tinc
		
		g horizon = `spec'
		
		tempfile interim`spec'
		save `interim`spec''
		
		restore
		
		} // spec
		
	clear

		foreach spec of numlist 0/$maxhorizon {
		append using `interim`spec''	
		}
		
	qui g com = 1       if blackh == 0 & marstat == 1
	qui replace com = 2 if blackh == 0 & marstat == 0
	qui replace com = 3 if blackh == 1 & marstat == 1
	qui replace com = 4 if blackh == 1 & marstat == 0

	label def label_com_c 1 "white, married" 2 "white, single" 3 "black, married" 4 "black, single", modify
	label val com label_com_c

	label def label_h 0 "0 years" 1 "1 year" 2 "2 years" 3 "3 years" 4 "4 years" 5 "5 years", replace
	label val horizon label_h

	grstyle init
	grstyle set color economist
	
	splitvallabels com, length(7)
	
	graph bar ///
	pc_cg_equity pc_cg_housing pc_cg_all_bonds, stack ///
	over(com, gap(*1) relabel(`r(relabel)') label(labsize(small) angle(90))) over(horizon, gap(*1) label(labsize(medsmall))) ///
	plotregion(color(white)) graphregion(color(white)) bgcolor(white) yscale(r()) ///
	legend(lab(1 "equity effect") lab(2 "housing effect") lab(3 "bond effect") symxsize(5) row(1)) ///
	ylabel(, angle(0)) ytitle("Total net gain per household") ///
	name("tot_gain_pc_`shocktype'`midgroups'_marstat", replace) xsize(10)
	graph export "${savpath}/figure_A8.pdf", replace
	export excel com pc_cg_equity pc_cg_housing pc_cg_all_bonds using "${savpath}/figure_A8.xlsx", firstrow(var) replace
	
	} // shocktype
	
*** interest effects by race and marstat ***

* import IRF data
import excel using "${scfpath}/irfs.xlsx", sheet("rr_ex") firstrow clear
sum Treasury if t_horizon == 12
global treasyldRR = - `r(mean)' / 100
sum baa if t_horizon == 12
global corpyldRR = - `r(mean)' / 100
sum Dividends if t_horizon == 12
global diviRR = - `r(mean)' / 100
	
use if year == 2019 using "${scfpath}/HSCF_2019.dta", clear
merge 1:1 year id impnum using "${scfpath}/newvars.dta"
keep if _merge==3
mi unset, asis

replace marstat = 1 if marstatdetail == 4 & marstat == 0
drop if raceh == 0

	foreach v of varlist *mort? *payment* {
	replace `v' = `v' / CPI
	}

local pchange_spec = "same_pchange"	// diff_pchange
	
	if "`pchange_spec'" == "diff_pchange" {
	global p_inc_equity = 10
	global p_inc_housing = 4
	global p_inc_bond_all_state_muni = 10
	global p_inc_bond_all_mb = 10
	global p_inc_bond_all_gov = 5
	global p_inc_bond_all_corp_for = 5
	global interestchange = 100
	}
	else if "`pchange_spec'" == "same_pchange" {
	global p_inc_equity = 10
	global p_inc_housing = 10
	global p_inc_bond_all_state_muni = 10
	global p_inc_bond_all_mb = 10
	global p_inc_bond_all_gov = 10
	global p_inc_bond_all_corp_for = 10
	global interestchange = 100
	global inflationchange = 10
	}

/*
notxbnd		state and municipal + other tax-exempt bonds 
mortbnd		mortgage-backed bonds
govtbnd		US government or treasury bills
obnd		corporate and foreign bonds

tfbmutf		tax-free bond mutual funds (municipal)
gbmutf		government and government-sponsored bond mutual funds
obmutf		other bond mutual funds (corporate and foreign)
*/

replace wgtI95W95 = wgtI95W95 * 1000

drop bnd savbnd

rename notxbnd	bond_state_muni
rename mortbnd 	bond_mb
rename govtbnd 	bond_gov
rename obnd 	bond_corp_for

rename tfbmutf	bmutf_state_muni
rename obmutf 	bmutf_corp_for

qui egen bonds = rowtotal(bond_*)

* note: already in 2019 prices
qui g FFA_bond_gov = 19426.0 * 1000000000 // L.210 FL893061105 All sectors; Treasury securities; asset https://www.federalreserve.gov/apps/fof/DisplayTable.aspx?t=L.210
qui g FFA_bond_mb = 9628.5 * 1000000000 // L.211 FL893061705 All sectors; agency- and GSE-backed securities; asset https://www.federalreserve.gov/apps/fof/DisplayTable.aspx?t=L.211
qui g FFA_bond_state_muni = 4151.7 * 1000000000 // L.212, FL893062005 All sectors; municipal securities; asset https://www.federalreserve.gov/apps/fof/DisplayTable.aspx?t=L.212
qui g FFA_bond_corp_for = 14228.4 * 1000000000 // L.213, FL893063005 All sectors; corporate and foreign bonds; asset https://www.federalreserve.gov/apps/fof/DisplayTable.aspx?t=L.213

qui egen FFA_bonds = rowtotal(FFA_bond_*)

* allocate government and government-sponsored bond mutual funds
egen aux_mb_gov = rowtotal(FFA_bond_mb FFA_bond_gov) // rowtotal(bond_mb bond_gov)

g FFA_bond_mb_share = FFA_bond_mb / aux_mb_gov
qui sum FFA_bond_mb_share [aw=wgtI95W95]
qui g av_FFA_bond_mb_share = `r(mean)'

g FFA_bond_gov_share = FFA_bond_gov / aux_mb_gov
qui sum FFA_bond_gov_share [aw=wgtI95W95]
qui g av_FFA_bond_gov_share = `r(mean)'

egen check = rowtotal(av_*)
qui sum check
	if `r(mean)' != 1 {
	exit
	}
	else drop check
	
qui g bmutf_mb = gbmutf * av_FFA_bond_mb_share
qui g bmutf_gov = gbmutf * av_FFA_bond_gov_share

qui drop *share aux* gbmutf

	foreach v of varlist FFA_bond_* {
	qui g av_`v'_share = `v' / FFA_bonds
	}

egen check = rowtotal(av_*)
qui sum check
	if `r(mean)' != 1 {
	exit
	}
	else drop check
	
	foreach v of varlist miscbmutf ind_bnd_* {
		foreach group in state_muni mb gov corp_for {
		g aux_`v'_`group' = `v' * av_FFA_bond_`group'_share
		}
	}

	foreach group in state_muni mb gov corp_for {
	*ds bond_`group' bmutf_`group' aux_*_`group'
	egen bond_all_`group' = rowtotal(bond_`group' bmutf_`group' aux_*_`group')
	}
	
qui drop *share aux* miscbmutf ind_bnd_*

g housing = house + nnresre + oresre // oest is net position
replace equity = equity + ffabus

	foreach asset of varlist equity housing bond_all* {
	g cg_`asset' = `asset' * ${p_inc_`asset'} / 100 // if ffanw > 0
	}
	
qui egen cg_all_bonds = rowtotal(cg_bond_all*)
	
	foreach j of numlist 1/3 {
	g int_gain_mort`j' = $interestchange / 10000 * mort`j' * remaining_dur`j'
	}

	foreach j of numlist 1/2 {
	g int_gain_oest_mort`j' = $interestchange / 10000 * oest_mort`j' * oest_remaining_dur`j'
	}

qui egen int_gain = rowtotal(int_gain_*) // if ffanw > 0
qui egen tot_gain = rowtotal(cg_equity cg_housing cg_all_bonds int_gain)
egen payments = rowtotal(payment? oest_payment?) // if ffanw > 0
egen new_payments = rowtotal(new_payment? new_oest_payment?) // if ffanw > 0
egen RR_new_payments = rowtotal(RR_new_payment? RR_new_oest_payment?)

* RR response for BAA and treasury yield after 1 year 
* new rollover fraction: ISSUANCE - CHANGE IN OUTSTANDING as % of OUTSTANDING, 
* 10y average, from SIFA: 13.4% of corporate bonds and 20.6% MBS turnover in a year
qui gen int_loss_liqcer = - $interestchange / 10000 * liqcer - ${corpyldRR} * 0.134 * bond_all_corp_for -  ${treasyldRR}  * 0.206 * bond_all_mb

collapse (rawsum) pop=wgtI95W95 (sum) incdivi *payments int_gain int_loss* tinc [pw=wgtI95W95], by(blackh marstat)

g pay_diff = -(new_payments - payments) + 0.01*incdivi
g RR_pay_diff = -(RR_new_payments - payments) + ${diviRR}*incdivi
qui drop incdivi

	foreach cg of varlist int_gain int_loss* *pay_diff {
	g rel_`cg' = `cg' / tinc * 100 // ffanw * 100
	}	

	foreach v in pay_diff RR_pay_diff ///
	int_gain int_loss_liqcer {
	g pc_`v' = `v' / pop
	}
	
mi unset, asis
g aux = 1
drop tinc pop

drop *payments

qui g com = 1       if blackh == 0 & marstat == 1
qui replace com = 2 if blackh == 0 & marstat == 0
qui replace com = 3 if blackh == 1 & marstat == 1
qui replace com = 4 if blackh == 1 & marstat == 0

label def label_com_c 1 "white, married" 2 "white, single" 3 "black, married" 4 "black, single", modify
label val com label_com_c

drop blackh marstat

reshape wide *int_gain* *int_loss* *pay_diff*, i(aux) j(com)

	foreach v of varlist *1 {
	local hlp = subinstr("`v'", "1", "", .)
	rename `v' wm_`hlp'
	}
	
	foreach v of varlist *2 {
	local hlp = subinstr("`v'", "2", "", .)
	rename `v' ws_`hlp'
	}
	
	foreach v of varlist *3 {
	local hlp = subinstr("`v'", "3", "", .)
	rename `v' bm_`hlp'
	}
	
	foreach v of varlist *4 {
	local hlp = subinstr("`v'", "4", "", .)
	rename `v' bs_`hlp'
	}
	
expand 2

g aux_cat_all = .
replace aux_cat_all = 1 if _n == 1
replace aux_cat_all = 2 if _n == 2

label def aux_cat_all_lab 1 "gain from mortgage interest change + dividends" ///
						  2 "loss from savings + bond interest change" , replace
label val aux_cat_all aux_cat_all_lab

* actuals

	foreach v  in "RR_" { 
	
	qui g 		wm_pc_`v'combi = wm_pc_`v'pay_diff if aux_cat_all == 1
	qui replace wm_pc_`v'combi = wm_pc_int_loss_liqcer if aux_cat_all == 2
	qui g 		ws_pc_`v'combi = ws_pc_`v'pay_diff if aux_cat_all == 1
	qui replace ws_pc_`v'combi = ws_pc_int_loss_liqcer if aux_cat_all == 2
	qui g 		bm_pc_`v'combi = bm_pc_`v'pay_diff if aux_cat_all == 1
	qui replace bm_pc_`v'combi = bm_pc_int_loss_liqcer if aux_cat_all == 2
	qui g 		bs_pc_`v'combi = bs_pc_`v'pay_diff if aux_cat_all == 1
	qui replace bs_pc_`v'combi = bs_pc_int_loss_liqcer if aux_cat_all == 2

	splitvallabels aux_cat, length(20)
	graph bar ///
	wm_pc_`v'combi ws_pc_`v'combi bm_pc_`v'combi bs_pc_`v'combi, ///
	over(aux_cat, gap(*0.5) relabel(`r(relabel)')) ///
	bar(1, color(white) lc(emidblue) lwidth(thick)) bar(2, color(white) lc(eltblue) lp(shortdash) lwidth(thick)) ///
	bar(3, color(gs0) lc(emidblue) lwidth(thick)) bar(4, color(gs0) lc(eltblue) lp(shortdash) lwidth(thick)) ///
	plotregion(color(white)) graphregion(color(white)) bgcolor(white) yscale(r(`ys')) ///
	legend(lab(1 "white, married") lab(2 "white, single") lab(3 "black, married") lab(4 "black, single") order(1 2 3 4) symxsize(5)) ///
	ylabel(`yl', angle(0)) ytitle("Per household") name("`v'pay_diff_int_loss_pc_bw", replace) xsize(5)	
	graph export "${savpath}/figure_A10.pdf", replace
	export excel aux_cat wm_pc_`v'combi ws_pc_`v'combi bm_pc_`v'combi bs_pc_`v'combi using "${savpath}/figure_A10.xlsx", firstrow(var) replace
	
	}

********************************************************************************
* Figures A9 and A11
********************************************************************************

global maxhorizon = 5
global duration_corp = 7.07
global duration_treasury = 9.47
global duration_mbs = 5.43

import excel using "${scfpath}/irfs.xlsx", sheet("rr_ex") firstrow clear
	
drop if inlist(t_horizon, 6, 18)
replace t_horizon = t_horizon / 12
rename t_horizon Horizon

drop *Wagegap* *Ugap*

g Shock = "RR" 

rename (Stocks Houses baa Treasury cpi_log) ///
(sp hp corpyield treasuryyield inflation)

foreach v in inflation {
	replace `v' = `v' * 100
}

tostring Horizon, replace
replace Horizon = Horizon + "Y"

* MS: use treasury yield
qui g interest = treasuryyield

tempfile irfs_joint
save `irfs_joint', replace

	foreach shocktype in RR { // BK RR GK // Paul 
	
	use if year == 2019 using "${scfpath}/HSCF_2019.dta", clear
	*collapse blackh [aw=wgtI95W95], by(ffanwgroups)
	
	drop if raceh == 0		
	
	replace marstat = 1 if marstatdetail == 4 & marstat == 0
	keep if marstat == 0 // singles
	
	merge 1:1 year id impnum using "${scfpath}/newvars.dta"
	keep if _merge==3
	drop _merge
	mi unset, asis

	* collapse tinc ageh [aw=wgtI95W95], by(blackh sexh)
	*keep if ageh < 65 // inrange(ageh, 25, 64)

		foreach v of varlist *mort? *payment* {
		replace `v' = `v' / CPI
		}

		foreach spec of numlist 0/$maxhorizon {
		
		preserve
		
		use `irfs_joint', clear
		
		keep if Shock == "`shocktype'"		
		
		keep if Horizon == "`spec'Y"
		
		drop Shock
		
		qui ds Horizon, not
		
		*replace sp = sp/3	
			
		qui levelsof sp, local(p_inc_equity)
		qui levelsof hp, local(p_inc_housing)
		qui levelsof interest, local(interestchange)
		qui levelsof inflation, local(inflationchange)
		
		qui g corppchange = - $duration_corp * corpyield - `inflationchange'
		qui levelsof corppchange, local(p_inc_bond_all_corp_for)
		qui g govpchange = - $duration_treasury * treasuryyield - `inflationchange'
		qui levelsof govpchange, local(p_inc_bond_all_gov)
		local p_inc_bond_all_state_muni = `p_inc_bond_all_gov'
		qui g mbpchange = - $duration_mbs * corpyield - `inflationchange'
		qui levelsof mbpchange, local(p_inc_bond_all_mb)
		
		restore
		
		preserve

		replace wgtI95W95 = wgtI95W95 * 1000

		drop bnd savbnd

		rename notxbnd	bond_state_muni
		rename mortbnd 	bond_mb
		rename govtbnd 	bond_gov
		rename obnd 	bond_corp_for

		rename tfbmutf	bmutf_state_muni
		rename obmutf 	bmutf_corp_for

		qui egen bonds = rowtotal(bond_*)

		* note: already in 2019 prices
		qui g FFA_bond_gov = 19426.0 * 1000000000 // L.210 FL893061105 All sectors; Treasury securities; asset https://www.federalreserve.gov/apps/fof/DisplayTable.aspx?t=L.210
		qui g FFA_bond_mb = 9628.5 * 1000000000 // L.211 FL893061705 All sectors; agency- and GSE-backed securities; asset https://www.federalreserve.gov/apps/fof/DisplayTable.aspx?t=L.211
		qui g FFA_bond_state_muni = 4151.7 * 1000000000 // L.212, FL893062005 All sectors; municipal securities; asset https://www.federalreserve.gov/apps/fof/DisplayTable.aspx?t=L.212
		qui g FFA_bond_corp_for = 14228.4 * 1000000000 // L.213, FL893063005 All sectors; corporate and foreign bonds; asset https://www.federalreserve.gov/apps/fof/DisplayTable.aspx?t=L.213

		qui egen FFA_bonds = rowtotal(FFA_bond_*)

		* allocate government and government-sponsored bond mutual funds
		egen aux_mb_gov = rowtotal(FFA_bond_mb FFA_bond_gov) // rowtotal(bond_mb bond_gov)

		g FFA_bond_mb_share = FFA_bond_mb / aux_mb_gov
		qui sum FFA_bond_mb_share [aw=wgtI95W95]
		qui g av_FFA_bond_mb_share = `r(mean)'

		g FFA_bond_gov_share = FFA_bond_gov / aux_mb_gov
		qui sum FFA_bond_gov_share [aw=wgtI95W95]
		qui g av_FFA_bond_gov_share = `r(mean)'

		egen check = rowtotal(av_*)
		qui sum check
			if `r(mean)' != 1 {
			exit
			}
			else drop check
			
		qui g bmutf_mb = gbmutf * av_FFA_bond_mb_share
		qui g bmutf_gov = gbmutf * av_FFA_bond_gov_share

		qui drop *share aux* gbmutf

			foreach v of varlist FFA_bond_* {
			qui g av_`v'_share = `v' / FFA_bonds
			}

		egen check = rowtotal(av_*)
		qui sum check
			if `r(mean)' != 1 {
			exit
			}
			else drop check
			
			foreach v of varlist miscbmutf ind_bnd_* {
				foreach group in state_muni mb gov corp_for {
				g aux_`v'_`group' = `v' * av_FFA_bond_`group'_share
				}
			}

			foreach group in state_muni mb gov corp_for {
			*ds bond_`group' bmutf_`group' aux_*_`group'
			egen bond_all_`group' = rowtotal(bond_`group' bmutf_`group' aux_*_`group')
			}
			
		qui drop *share aux* miscbmutf ind_bnd_*

		g housing = house + nnresre + oresre // oest is net position
		replace equity = equity + ffabus

			foreach asset of varlist equity housing bond_all* {
			g cg_`asset' = `asset' * `p_inc_`asset'' / 100 // if ffanw > 0
			}
			
		qui egen cg_all_bonds = rowtotal(cg_bond_all*)
			
		qui egen tot_gain = rowtotal(cg_equity cg_housing cg_all_bonds) // int_gain int_loss_liqcer
		
		qui g share_below_1 = (tot_gain/tinc*100) < 1 if !mi(tot_gain)
		qui g share_below_5 = (tot_gain/tinc*100) < 5 if !mi(tot_gain)
		
		qui replace share_below_1 = share_below_1 * 100
		qui replace share_below_5 = share_below_5 * 100
		
		*** race ***

		collapse (mean) share_below* (rawsum) pop=wgtI95W95 (sum) cg_equity cg_housing cg_all_bonds *tot_gain ///
		/*inflation_effect*/ tinc ffanw [pw=wgtI95W95], by(blackh sexh) // int_gain int_loss_liqcer

			foreach cg of varlist cg_equity cg_housing cg_all_bonds tot_gain ///
			{ // inflation_effect int_gain int_loss_liqcer 
			g rel_`cg' = `cg' / tinc * 100 // ffanw * 100
			}	

			foreach v in cg_equity cg_housing cg_all_bonds tot_gain ///
			{ // inflation_effect int_gain int_loss_liqcer 
			g pc_`v' = `v' / pop
			}
			
		mi unset, asis
		g aux = 1
		drop tinc
		
		g horizon = `spec'
		
		tempfile interim`spec'
		save `interim`spec''
		
		restore
		
		} // spec
		
	clear

		foreach spec of numlist 0/$maxhorizon {
		append using `interim`spec''	
		}
		
	qui g com = 1       if blackh == 0 & sexh == 1
	qui replace com = 2 if blackh == 0 & sexh == 2
	qui replace com = 3 if blackh == 1 & sexh == 1
	qui replace com = 4 if blackh == 1 & sexh == 2

	label def label_com_c 1 "white men" 2 "white women" 3 "black men" 4 "black women", modify
	label val com label_com_c

	label def label_h 0 "0 years" 1 "1 year" 2 "2 years" 3 "3 years" 4 "4 years" 5 "5 years", replace
	label val horizon label_h
	
	export excel horizon com *tot* using "${scfpath}/total_effect_singles.xlsx", ///
	sheet("`shocktype'") firstrow(var) sheetmodify

	grstyle init
	grstyle set color economist
	
	splitvallabels com, length(6)
	
	graph bar ///
	pc_cg_equity pc_cg_housing pc_cg_all_bonds, stack ///
	over(com, gap(*1) relabel(`r(relabel)') label(labsize(small) angle(90))) over(horizon, gap(*1) label(labsize(medsmall))) ///
	plotregion(color(white)) graphregion(color(white)) bgcolor(white) yscale(r()) ///
	legend(lab(1 "equity effect") lab(2 "housing effect") lab(3 "bond effect") symxsize(5) row(1)) ///
	ylabel(, angle(0)) ytitle("Total net gain per household") ///
	name("tot_gain_pc_bw_decomp_`shocktype'_sex", replace) xsize(10)
	graph export "${savpath}/figure_A9.pdf", replace
	export excel com pc_cg_equity pc_cg_housing pc_cg_all_bonds using "${savpath}/figure_A9.xlsx", firstrow(var) replace
		
	} // shocktype
	
*** interest effects by race and sex ***

clear all

* import IRF data
import excel using "${scfpath}/irfs.xlsx", sheet("rr_ex") firstrow clear
sum Treasury if t_horizon == 12
global treasyldRR = - `r(mean)' / 100
sum baa if t_horizon == 12
global corpyldRR = - `r(mean)' / 100
sum Dividends if t_horizon == 12
global diviRR = - `r(mean)' / 100
	
use if year == 2019 using "${scfpath}/HSCF_2019.dta", clear
merge 1:1 year id impnum using "${scfpath}/newvars.dta"
keep if _merge==3
mi unset, asis

replace marstat = 1 if marstatdetail == 4 & marstat == 0
keep if marstat == 0 // singles

drop if raceh == 0

	foreach v of varlist *mort? *payment* {
	replace `v' = `v' / CPI
	}

local pchange_spec = "same_pchange"	// diff_pchange
	
	if "`pchange_spec'" == "diff_pchange" {
	global p_inc_equity = 10
	global p_inc_housing = 4
	global p_inc_bond_all_state_muni = 10
	global p_inc_bond_all_mb = 10
	global p_inc_bond_all_gov = 5
	global p_inc_bond_all_corp_for = 5
	global interestchange = 100
	}
	else if "`pchange_spec'" == "same_pchange" {
	global p_inc_equity = 10
	global p_inc_housing = 10
	global p_inc_bond_all_state_muni = 10
	global p_inc_bond_all_mb = 10
	global p_inc_bond_all_gov = 10
	global p_inc_bond_all_corp_for = 10
	global interestchange = 100
	global inflationchange = 10
	}

replace wgtI95W95 = wgtI95W95 * 1000

drop bnd savbnd

rename notxbnd	bond_state_muni
rename mortbnd 	bond_mb
rename govtbnd 	bond_gov
rename obnd 	bond_corp_for

rename tfbmutf	bmutf_state_muni
rename obmutf 	bmutf_corp_for

qui egen bonds = rowtotal(bond_*)

* note: already in 2019 prices
qui g FFA_bond_gov = 19426.0 * 1000000000 // L.210 FL893061105 All sectors; Treasury securities; asset https://www.federalreserve.gov/apps/fof/DisplayTable.aspx?t=L.210
qui g FFA_bond_mb = 9628.5 * 1000000000 // L.211 FL893061705 All sectors; agency- and GSE-backed securities; asset https://www.federalreserve.gov/apps/fof/DisplayTable.aspx?t=L.211
qui g FFA_bond_state_muni = 4151.7 * 1000000000 // L.212, FL893062005 All sectors; municipal securities; asset https://www.federalreserve.gov/apps/fof/DisplayTable.aspx?t=L.212
qui g FFA_bond_corp_for = 14228.4 * 1000000000 // L.213, FL893063005 All sectors; corporate and foreign bonds; asset https://www.federalreserve.gov/apps/fof/DisplayTable.aspx?t=L.213

qui egen FFA_bonds = rowtotal(FFA_bond_*)

* allocate government and government-sponsored bond mutual funds
egen aux_mb_gov = rowtotal(FFA_bond_mb FFA_bond_gov) // rowtotal(bond_mb bond_gov)

g FFA_bond_mb_share = FFA_bond_mb / aux_mb_gov
qui sum FFA_bond_mb_share [aw=wgtI95W95]
qui g av_FFA_bond_mb_share = `r(mean)'

g FFA_bond_gov_share = FFA_bond_gov / aux_mb_gov
qui sum FFA_bond_gov_share [aw=wgtI95W95]
qui g av_FFA_bond_gov_share = `r(mean)'

egen check = rowtotal(av_*)
qui sum check
	if `r(mean)' != 1 {
	exit
	}
	else drop check
	
qui g bmutf_mb = gbmutf * av_FFA_bond_mb_share
qui g bmutf_gov = gbmutf * av_FFA_bond_gov_share

qui drop *share aux* gbmutf

	foreach v of varlist FFA_bond_* {
	qui g av_`v'_share = `v' / FFA_bonds
	}

egen check = rowtotal(av_*)
qui sum check
	if `r(mean)' != 1 {
	exit
	}
	else drop check
	
	foreach v of varlist miscbmutf ind_bnd_* {
		foreach group in state_muni mb gov corp_for {
		g aux_`v'_`group' = `v' * av_FFA_bond_`group'_share
		}
	}

	foreach group in state_muni mb gov corp_for {
	*ds bond_`group' bmutf_`group' aux_*_`group'
	egen bond_all_`group' = rowtotal(bond_`group' bmutf_`group' aux_*_`group')
	}
	
qui drop *share aux* miscbmutf ind_bnd_*

g housing = house + nnresre + oresre // oest is net position
replace equity = equity + ffabus

	foreach asset of varlist equity housing bond_all* {
	g cg_`asset' = `asset' * ${p_inc_`asset'} / 100 // if ffanw > 0
	}
	
qui egen cg_all_bonds = rowtotal(cg_bond_all*)
	
	foreach j of numlist 1/3 {
	g int_gain_mort`j' = $interestchange / 10000 * mort`j' * remaining_dur`j'
	}

	foreach j of numlist 1/2 {
	g int_gain_oest_mort`j' = $interestchange / 10000 * oest_mort`j' * oest_remaining_dur`j'
	}

qui egen int_gain = rowtotal(int_gain_*) // if ffanw > 0
qui egen tot_gain = rowtotal(cg_equity cg_housing cg_all_bonds int_gain)
egen payments = rowtotal(payment? oest_payment?) // if ffanw > 0
egen new_payments = rowtotal(new_payment? new_oest_payment?) // if ffanw > 0
egen RR_new_payments = rowtotal(RR_new_payment? RR_new_oest_payment?)

* RR response for BAA and treasury yield after 1 year 
* new rollover fraction: ISSUANCE - CHANGE IN OUTSTANDING as % of OUTSTANDING, 
* 10y average, from SIFA: 13.4% of corporate bonds and 20.6% MBS turnover in a year
qui gen int_loss_liqcer = - $interestchange / 10000 * liqcer - ${corpyldRR} * 0.134 * bond_all_corp_for -  ${treasyldRR}  * 0.206 * bond_all_mb

collapse (rawsum) pop=wgtI95W95 (sum) *payments incdivi int_gain int_loss* tinc [pw=wgtI95W95], by(blackh sexh)

g pay_diff = -(new_payments - payments) + 0.01*incdivi
g RR_pay_diff = -(RR_new_payments - payments) + ${diviRR}*incdivi
qui drop incdivi

	foreach cg of varlist int_gain int_loss* *pay_diff {
	g rel_`cg' = `cg' / tinc * 100 // ffanw * 100
	}	

	foreach v in pay_diff RR_pay_diff ///
	int_gain int_loss_liqcer {
	g pc_`v' = `v' / pop
	}
	
mi unset, asis
g aux = 1
drop tinc pop

drop *payments

qui g com = 1       if blackh == 0 & sexh == 1
qui replace com = 2 if blackh == 0 & sexh == 2
qui replace com = 3 if blackh == 1 & sexh == 1
qui replace com = 4 if blackh == 1 & sexh == 2

label def label_com_c 1 "white men" 2 "white women" 3 "black men" 4 "black women", modify
label val com label_com_c

drop blackh sexh

reshape wide *int_gain* *int_loss* *pay_diff*, i(aux) j(com)

	foreach v of varlist *1 {
	local hlp = subinstr("`v'", "1", "", .)
	rename `v' wm_`hlp'
	}
	
	foreach v of varlist *2 {
	local hlp = subinstr("`v'", "2", "", .)
	rename `v' wf_`hlp'
	}
	
	foreach v of varlist *3 {
	local hlp = subinstr("`v'", "3", "", .)
	rename `v' bm_`hlp'
	}
	
	foreach v of varlist *4 {
	local hlp = subinstr("`v'", "4", "", .)
	rename `v' bf_`hlp'
	}
	
expand 2

g aux_cat_all = .
replace aux_cat_all = 1 if _n == 1
replace aux_cat_all = 2 if _n == 2

label def aux_cat_all_lab 1 "gain from mortgage interest change + dividends" ///
						  2 "loss from savings + bond interest change" , replace
label val aux_cat_all aux_cat_all_lab

* actuals

	foreach v  in "RR_" { 
	
	qui g 		wm_pc_`v'combi = wm_pc_`v'pay_diff if aux_cat_all == 1
	qui replace wm_pc_`v'combi = wm_pc_int_loss_liqcer if aux_cat_all == 2
	qui g 		wf_pc_`v'combi = wf_pc_`v'pay_diff if aux_cat_all == 1
	qui replace wf_pc_`v'combi = wf_pc_int_loss_liqcer if aux_cat_all == 2
	qui g 		bm_pc_`v'combi = bm_pc_`v'pay_diff if aux_cat_all == 1
	qui replace bm_pc_`v'combi = bm_pc_int_loss_liqcer if aux_cat_all == 2
	qui g 		bf_pc_`v'combi = bf_pc_`v'pay_diff if aux_cat_all == 1
	qui replace bf_pc_`v'combi = bf_pc_int_loss_liqcer if aux_cat_all == 2

	splitvallabels aux_cat, length(20)
	graph bar ///
	wm_pc_`v'combi wf_pc_`v'combi bm_pc_`v'combi bf_pc_`v'combi, ///
	over(aux_cat, gap(*0.5) relabel(`r(relabel)')) ///
	bar(1, color(white) lc(emidblue) lwidth(thick)) bar(2, color(white) lc(eltblue) lp(shortdash) lwidth(thick)) ///
	bar(3, color(gs0) lc(emidblue) lwidth(thick)) bar(4, color(gs0) lc(eltblue) lp(shortdash) lwidth(thick)) ///
	plotregion(color(white)) graphregion(color(white)) bgcolor(white) yscale(r(`ys')) ///
	legend(lab(1 "white men") lab(2 "white women") lab(3 "black men") lab(4 "black women") order(1 2 3 4) symxsize(5)) ///
	ylabel(`yl', angle(0)) ytitle("Per household") name("`v'pay_diff_int_loss_pc_bw", replace) xsize(5)	
	graph export "${savpath}/figure_A11.pdf", replace
	export excel aux_cat wm_pc_`v'combi wf_pc_`v'combi bm_pc_`v'combi bf_pc_`v'combi using "${savpath}/figure_A11.xlsx", firstrow(var) replace
	
	}

********************************************************************************
* Table A1
********************************************************************************
	
use if year == 2019 using "${scfpath}/HSCF_2019.dta", clear
merge 1:1 year id impnum using "${scfpath}/newvars.dta"
keep if _merge==3
mi unset, asis

drop if raceh == 0
replace marstat = 1 if marstatdetail == 4 & marstat == 0

replace wgtI95W95 = wgtI95W95 * 1000

qui g housing = house + nnresre + oresre // oest is net position
replace equity = equity + ffabus

* oest is net position
qui replace ffaass = ffaass + oestdebt
qui replace tdebt = tdebt + oestdebt
* egen ffaass_new = rowtotal(liq cds nmmf stocks bond retqliq savbnd cashli othma othfin vehic houses oresre nnresre bus othnfin)
* subtract indirect holdings via savings
qui replace liqcer = liqcer - ind_bnd_savings - ind_equ_savings

drop ffanfin
qui egen ffanfin = rowtotal(vehi onfin)

qui egen aux_assets = rowtotal(all_bonds housing equity ffanfin liqcer)

qui g ffaothfin = ffaass - aux_assets // includes ofin and life

replace ffaothfin = 0 if inrange(ffaothfin, -150, -1) // rounding error

label def label_blackh_c 0 "white" 1 "black", modify
label val blackh label_blackh_c

ren (tinc ffanw) (income wealth)

preserve

keep if marstat == 0

collapse income wealth housing equity ffaass [aw=wgtI95W95], by(blackh sexh)

qui g house_share = housing/ffaass
qui g equity_share = equity/ffaass
drop housing equity ffaass

export excel using "${savpath}/table_A1.xlsx", firstrow(var) sheetreplace sheet("singles_by_sex")

restore

collapse income wealth housing equity ffaass [aw=wgtI95W95], by(blackh marstat)

qui g house_share = housing/ffaass
qui g equity_share = equity/ffaass
drop housing equity ffaass

export excel using "${savpath}/table_A1.xlsx", firstrow(var) sheetreplace sheet("by_mar_stat")

********************************************************************************
* Figure 12
********************************************************************************	
	
clear all

global maxhorizon = 5
global duration_corp = 7.07
global duration_treasury = 9.47
global duration_mbs = 5.43

import excel using "${scfpath}/irfs.xlsx", sheet("rr_ex") firstrow clear
	
drop if inlist(t_horizon, 6, 18)
replace t_horizon = t_horizon / 12
rename t_horizon Horizon

drop *Wagegap* *Ugap*

g Shock = "RR" 

rename (Stocks Houses baa Treasury cpi_log) ///
(sp hp corpyield treasuryyield inflation)

foreach v in inflation {
	replace `v' = `v' * 100
}

tostring Horizon, replace
replace Horizon = Horizon + "Y"

* MS: use treasury yield
qui g interest = treasuryyield

tempfile irfs_joint
save `irfs_joint', replace

	foreach shocktype in RR { 
	
	use if year == 2019 using "${scfpath}/HSCF_2019.dta", clear
	*collapse blackh [aw=wgtI95W95], by(ffanwgroups)
		
	qui xtile ffanw_100 = ffanw [aw=wgtI95W95], nq(100)
	
	merge 1:1 year id impnum using "${scfpath}/newvars.dta"
	keep if _merge==3
	drop _merge
	mi unset, asis

	drop if raceh == 0

		foreach v of varlist *mort? *payment* {
		replace `v' = `v' / CPI
		}

	local spec = 5 // horizon 5
	
	preserve
	
	use `irfs_joint', clear
	
	keep if Shock == "`shocktype'"		
	
	keep if Horizon == "`spec'Y"
	
	drop Shock
	
	qui ds Horizon, not
	
	*replace sp = sp/3	
		
	qui levelsof sp, local(p_inc_equity)
	qui levelsof hp, local(p_inc_housing)
	qui levelsof interest, local(interestchange)
	qui levelsof inflation, local(inflationchange)
	
	qui g corppchange = - $duration_corp * corpyield - `inflationchange'
	qui levelsof corppchange, local(p_inc_bond_all_corp_for)
	qui g govpchange = - $duration_treasury * treasuryyield - `inflationchange'
	qui levelsof govpchange, local(p_inc_bond_all_gov)
	local p_inc_bond_all_state_muni = `p_inc_bond_all_gov'
	qui g mbpchange = - $duration_mbs * corpyield - `inflationchange'
	qui levelsof mbpchange, local(p_inc_bond_all_mb)
	
	restore

	replace wgtI95W95 = wgtI95W95 * 1000

	drop bnd savbnd

	rename notxbnd	bond_state_muni
	rename mortbnd 	bond_mb
	rename govtbnd 	bond_gov
	rename obnd 	bond_corp_for

	rename tfbmutf	bmutf_state_muni
	rename obmutf 	bmutf_corp_for

	qui egen bonds = rowtotal(bond_*)

	* note: already in 2019 prices
	qui g FFA_bond_gov = 19426.0 * 1000000000 // L.210 FL893061105 All sectors; Treasury securities; asset https://www.federalreserve.gov/apps/fof/DisplayTable.aspx?t=L.210
	qui g FFA_bond_mb = 9628.5 * 1000000000 // L.211 FL893061705 All sectors; agency- and GSE-backed securities; asset https://www.federalreserve.gov/apps/fof/DisplayTable.aspx?t=L.211
	qui g FFA_bond_state_muni = 4151.7 * 1000000000 // L.212, FL893062005 All sectors; municipal securities; asset https://www.federalreserve.gov/apps/fof/DisplayTable.aspx?t=L.212
	qui g FFA_bond_corp_for = 14228.4 * 1000000000 // L.213, FL893063005 All sectors; corporate and foreign bonds; asset https://www.federalreserve.gov/apps/fof/DisplayTable.aspx?t=L.213

	qui egen FFA_bonds = rowtotal(FFA_bond_*)

	* allocate government and government-sponsored bond mutual funds
	egen aux_mb_gov = rowtotal(FFA_bond_mb FFA_bond_gov) // rowtotal(bond_mb bond_gov)

	g FFA_bond_mb_share = FFA_bond_mb / aux_mb_gov
	qui sum FFA_bond_mb_share [aw=wgtI95W95]
	qui g av_FFA_bond_mb_share = `r(mean)'

	g FFA_bond_gov_share = FFA_bond_gov / aux_mb_gov
	qui sum FFA_bond_gov_share [aw=wgtI95W95]
	qui g av_FFA_bond_gov_share = `r(mean)'

	egen check = rowtotal(av_*)
	qui sum check
		if `r(mean)' != 1 {
		exit
		}
		else drop check
		
	qui g bmutf_mb = gbmutf * av_FFA_bond_mb_share
	qui g bmutf_gov = gbmutf * av_FFA_bond_gov_share

	qui drop *share aux* gbmutf

		foreach v of varlist FFA_bond_* {
		qui g av_`v'_share = `v' / FFA_bonds
		}

	egen check = rowtotal(av_*)
	qui sum check
		if `r(mean)' != 1 {
		exit
		}
		else drop check
		
		foreach v of varlist miscbmutf ind_bnd_* {
			foreach group in state_muni mb gov corp_for {
			g aux_`v'_`group' = `v' * av_FFA_bond_`group'_share
			}
		}

		foreach group in state_muni mb gov corp_for {
		*ds bond_`group' bmutf_`group' aux_*_`group'
		egen bond_all_`group' = rowtotal(bond_`group' bmutf_`group' aux_*_`group')
		}
		
	qui drop *share aux* miscbmutf ind_bnd_*

	g housing = house + nnresre + oresre // oest is net position
	replace equity = equity + ffabus

		foreach asset of varlist equity housing bond_all* {
		g cg_`asset' = `asset' * `p_inc_`asset'' / 100 // if ffanw > 0
		}
		
	qui egen cg_all_bonds = rowtotal(cg_bond_all*)
		
	qui egen tot_gain = rowtotal(cg_equity cg_housing cg_all_bonds) // int_gain int_loss_liqcer
	
	collapse (sum) tot_gain [pw=wgtI95W95], by(ffanw_100)
	
	qui g cum_gain = sum(tot_gain)
	qui egen tot_gain_all = total(tot_gain)
	qui g cum_gain_rel = cum_gain / tot_gain_all * 100

	twoway ///
	connected cum_gain_rel ffanw_100, lc(gs0) msym(o) msize(large) mfc(gs0) mlc(gs0) ///
	plotregion(color(white)) graphregion(color(white)) bgcolor(white) ///
	xlabel() yscale(r()) ylabel(, angle(0)) legend(off) ///
	ytitle("percentage share of total gains") xtitle("wealth percentile") name("cum_gain_rel_`shocktype'`midgroups'", replace)
	graph export "${savpath}/figure_12.pdf", replace
	export excel cum_gain_rel ffanw_100 using "${savpath}/figure_12.xlsx", firstrow(var) replace 

	} // shocktype

********************************************************************************
* Figure 1
********************************************************************************	

clear all
	
foreach shock in RR {
	
	qui import excel using "${scfpath}/total_effect.xlsx", firstrow clear sheet("`shock'")

	keep horizon blackh rel_tot_gain

	reshape wide rel_tot_gain, i(horizon) j(blackh) str

	qui g portfolio_effect`shock' = rel_tot_gainW - rel_tot_gainB
	
	qui keep horizon portfolio_effect`shock'

	tempfile portfolio_effect_`shock'
	save `portfolio_effect_`shock''
	
} // shock

import excel using "${scfpath}/earningseffect.xlsx", firstrow clear cellra(A15:B21)

rename (Earningseffectinpercentofin RomerRomer) ///
(horizon earnings_effectRR)

qui replace earnings_effectRR = sum(earnings_effectRR) // cumulate

keep horizon earnings_effectRR

qui replace horizon = "0 years" if horizon == "year 0"
qui replace horizon = "1 year" if horizon == "year 1"
foreach j of numlist 2/5 {
	qui replace horizon = "`j' years" if horizon == "year `j'"
}

merge 1:1 horizon using `portfolio_effect_RR', nogen

replace earnings_effectRR = earnings_effectRR * 100

graph bar ///
earnings_effectRR portfolio_effect, ///
over(horizon, gap(*1.2)) blabel(bar, format(%9.2f)) ///
bar(1, color(eltblue) lc(gs0) lwidth(thin)) bar(2, color(emidblue) lc(gs0) lwidth(thin)) ///
plotregion(color(white)) graphregion(color(white)) bgcolor(white) yscale(r(-0.3 16)) ///
legend(lab(1 "relative earnings gains for black households") ///
lab(2 "relative capital gains for white households") symxsize(5) row(2)) ///
ylabel(0(3)15, angle(0)) ytitle("Effect in % of group income") ///
name("comparison_earnings_portfolio_RR", replace) xsize(5)
graph export "${savpath}/figure_1.pdf", replace
export excel horizon earnings_effectRR portfolio_effect using "${savpath}/figure_1.xlsx", firstrow(var) replace 

********************************************************************************
* Figure A12
********************************************************************************	

clear all

foreach shock in RR {
	
	qui import excel using "${scfpath}/total_effect_singles.xlsx", firstrow clear sheet("`shock'")

	keep horizon com rel_tot_gain
	
	rename rel_tot_gain tot_eff_
	
	replace com = subinstr(com, " ", "_", .)

	reshape wide tot_eff_, i(horizon) j(com) str

	qui g portfolio_effect`shock'_f = tot_eff_white_women - tot_eff_black_women
	qui g portfolio_effect`shock'_m = tot_eff_white_men - tot_eff_black_men
	
	qui keep horizon portfolio_effect`shock'*

	tempfile portfolio_effect_`shock'
	save `portfolio_effect_`shock''
	
} // shock

tempfile portfolio_effect
save `portfolio_effect'

import excel using "${scfpath}/earningseffect_singlemen.xlsx", firstrow clear cellra(A15:B21)

rename (Earningseffectinpercentofin RomerRomer) ///
(horizon earnings_effectRR_m)

qui replace earnings_effectRR_m = sum(earnings_effectRR_m) // cumulate

keep horizon earnings_effectRR_m 

tempfile earnings_m
save `earnings_m'

import excel using "${scfpath}/earningseffect_singlewomen.xlsx", firstrow clear cellra(A15:B21)

rename (Earningseffectinpercentofin RomerRomer) ///
(horizon earnings_effectRR_f)

qui replace earnings_effectRR_f = sum(earnings_effectRR_f) // cumulate

keep horizon earnings_effectRR_f

merge 1:1 horizon using `earnings_m', nogen

qui replace horizon = "0 years" if horizon == "year 0"
qui replace horizon = "1 year" if horizon == "year 1"
foreach j of numlist 2/5 {
	qui replace horizon = "`j' years" if horizon == "year `j'"
}

merge 1:1 horizon using `portfolio_effect', nogen

replace earnings_effectRR_m = earnings_effectRR_m * 100
replace earnings_effectRR_f = earnings_effectRR_f * 100

reshape long earnings_effectRR portfolio_effectRR, i(horizon) j(sex) str

replace sex = "single women" if sex == "_f"
replace sex = "single men"   if sex == "_m"

graph bar ///
earnings_effect portfolio_effect, blabel(bar, format(%9.2f)) ///
over(horizon, gap(*1)) over(sex, gap(*1.5) label(labsize(medsmall))) ///
bar(1, color(eltblue) lc(gs0) lwidth(thin)) bar(2, color(emidblue) lc(gs0) lwidth(thin)) ///
plotregion(color(white)) graphregion(color(white)) bgcolor(white) yscale(r(-0.3 14)) ///
legend(lab(1 "relative earnings gains for black households") ///
lab(2 "relative capital gains for white households") symxsize(5) row(1)) ///
ylabel(0(2)14, angle(0)) ytitle("Effect in % of group income") ///
name("comp_earnings_portfolio_by_sex", replace) xsize(8)
graph export "${savpath}/figure_A12.pdf", replace
export excel horizon earnings_effect portfolio_effect using "${savpath}/figure_A12.xlsx", firstrow(var) replace 



