clear
cd "/Users/Adam/Dropbox/Discussions/2021-2/Shiller BPEA"
insheet using cst.csv, comma
save cst.dta, replace

/*
clear
insheet using nyfed_ann.csv, comma
merge 1:1 year using cst.dta 
sort year
*/

gen month = 5 // "Spring"
gen date = ym(year,month)
save cst.dta, replace

clear
insheet using nyfed_month.csv, comma
drop date
gen date = ym(year, month)
keep date nyfed_median_1yr nyfed_median_3yr
merge 1:1 date using cst.dta
drop _m
save cst.dta, replace

clear
insheet using mich.csv, comma
gen date = ym(year,Month)
keep michigan_median_1yr michigan_median_5yr michigan_mean_1yr michigan_mean_5yr date
merge 1:1 date using cst.dta
drop _m 
sort date
format date %tm
save cst.dta, replace

tsset date
tssmooth ma michigan_mean_1yr_sm = michigan_mean_1yr, window(2 1 2)
tssmooth ma michigan_mean_5yr_sm = michigan_mean_5yr, window(2 1 2)
tssmooth ma michigan_median_1yr_sm = michigan_median_1yr, window(2 1 2)
tssmooth ma michigan_median_5yr_sm = michigan_median_5yr, window(2 1 2)
tssmooth ma nyfed_median_1yr_sm = nyfed_median_1yr, window(2 1 2)
tssmooth ma nyfed_median_3yr_sm = nyfed_median_3yr, window(2 1 2)

line cst_all_1yr cst_all_10yr date, legend(label(1 "ST 1 Year") label(2 "ST 10 Year")) graphregion(fcolor(white)) xtitle("Year") ytitle("Annual Expected Price Growth")
graph export onlyst.eps, replace
line cst_all_1yr cst_all_10yr nyfed_median_1yr_sm nyfed_median_3yr_sm date, legend(label(1 "ST 1 Year") label(2 "ST 10 Year") label(3 "NY Fed 1 Year (Smoothed)") label(4 "NY Fed 3 Year (Smoothed)")) lpattern(solid solid dash dash) lcolor(navy maroon navy maroon) graphregion(fcolor(white)) xtitle("Year") ytitle("Annual Expected Price Growth")
graph export st_nyfed.eps, replace
line cst_all_1yr cst_all_10yr michigan_mean_1yr_sm michigan_mean_5yr_sm date, legend(label(1 "ST 1 Year") label(2 "ST 10 Year") label(3 "Michigan 1 Year (Smoothed)") label(4 "Michigan 5 Year (Smoothed)")) lpattern(solid solid -. -.) lcolor(navy maroon navy maroon) graphregion(fcolor(white)) xtitle("Year") ytitle("Annual Expected Price Growth")
graph export st_michigan.eps, replace

// For print
line cst_all_1yr nyfed_median_1yr_sm michigan_mean_1yr_sm date, legend(label(1 "CST 1 Year") label(2 "NY Fed 1 Year (Smoothed)") label(3 "Michigan 1 Year (Smoothed)") rows(1)) lpattern(solid dash -.) lwidth(.75 .75 .5 .5 .3 .3) lcolor(navy maroon dkgreen) graphregion(fcolor(white)) xtitle("Year") ytitle("Annual Expected Price Growth") xsize(6) ysize(3)
graph export cst_all_1yr.eps, replace

line cst_all_10yr nyfed_median_3yr_sm michigan_mean_5yr_sm date, legend(label(1 "CST 10 Year") label(2 "NY Fed 3 Year (Smoothed)") label(3 "Michigan 5 Year (Smoothed)") rows(1)) lpattern(solid dash -.) lwidth(.75 .5 .3) lcolor(navy maroon dkgreen) graphregion(fcolor(white)) xtitle("Year") ytitle("Annual Expected Price Growth") xsize(6) ysize(3)
graph export cst_all_lr.eps, replace


