clear all
cls
set matsize 10000
import excel "ExchangeRatesWeekly.xlsx", firstrow
gen year = year(Date)
gen month = mofd(Date)
format Date %td
tsset Date, d del(7)

rename *_USD E*_USD

/* Dummies for breakpoints and trends */
gen time = _n
gen d2014 = 0
replace d2014 = 1 if Date > d(1aug2014)
gen t2014 = 0 
replace t2014 = time if Date > d(1aug2014)
gen GFC = 0
replace GFC = 1 if Date > d(1aug2008) & Date < d(1jul2009)

/* Creating other currency pairs */
gen EJPY_EUR = EJPY/EEUR
gen EJPY_RMB = EJPY_USD/ERMB
gen ERMB_EUR = ERMB/EEUR_USD


/* Converting to panel data */
reshape long E, i(Date) j(Country, s)
egen CountryID = group(Country)
xtset CountryID Date, d del(7)

/* Country-specific trends*/
su CountryID, meanonly
foreach i of num 1/`r(max)' {
	gen trend`i' = 0
	replace trend`i' = time if CountryID == `i'
	}	
		

/* Calculating weekly volatility */
gen VOL = abs(d.E/l.E)*100
gen VolSP500 = abs(d.SP500/l.SP500)*100
gen VolOil = abs(d.Oil/l.Oil)*100

/* G3 Regressions */
preserve
drop if strpos(Country,"RMB")>0
xtreg VOL time 
xtreg VOL time d2014 t2014
xtreg VOL time d2014 t2014 VolSP500 VolOil
xtreg VOL time d2014 t2014 VolSP500 VolOil GFC
xtreg VOL i.CountryID time d2014 t2014 VolSP500 VolOil GFC
xtreg VOL i.CountryID trend* d2014 t2014 VolSP500 VolOil GFC
restore


/* G4 Regression */
xtreg VOL i.CountryID trend* d2014 t2014 VolSP500 VolOil GFC
