%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Code used to plot model estimates
% Inputs: mat files with estimation outputs
% Authors: Adrien Couturier, Ricardo Reis
% Date: July 2021
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Figure 10

clc
close all
clear

%% load and prepare results/data

clear 
load ../Data/US/full_info_2.mat

mu = mu(1:4);
msigma2 = msigma2(1:4);
mlambda = mlambda(1:4);
z = z(1:4);
b = b(1:4);

pie = [0.02, inferred_pie];
tim = [1967, d];

%% Subplot 10(a): Estimates
% plot inferred pi_e

figure(1)
hold on
plot(tim, pie*100, 'LineWidth', 5)
grid on; axis([1967 1971 1 4.5])
set(gca, 'XTick', [1967:1:1971], 'FontSize', 15)
ylabel('%', 'FontSize', 15)
xlabel('Year', 'FontSize', 15)
hold off
saveTightFigure(figure(1),'../Figures/figure_10_a.pdf');

%% Subplot 10(b): The market-people discrepancy

figure(2)
hold on
plot(d,(z-mu)*100+b*0, 'LineWidth', 5)
plot(d,(b-mu)*100, '-', 'LineWidth', 3)
plot(d,(z-b)*100, ':', 'LineWidth', 3)
legend({'Discrepancy', 'Disagreement across', 'Disagreement within'}, 'Interpreter', 'Latex', 'FontSize', 10, 'Location', 'northwest')
grid on;
set(gca, 'XTick', [1968:1:1971], 'FontSize', 12)
ylabel('%', 'FontSize', 12)
xlabel('Date', 'Interpreter', 'Latex', 'FontSize', 12)
hold off
saveTightFigure(figure(2), '../Figures/figure_10_b.pdf');

%% Subplot 10(c): Standard deviation of signals sigma_t

figure(3)
hold on
plot(d, 100*sqrt(msigma2), 'LineWidth', 5)
grid on;
set(gca, 'XTick', [1968:1:1971], 'FontSize', 12)
ylabel('%', 'FontSize', 12)
xlabel('Year', 'FontSize', 12)
hold off
saveTightFigure(figure(3), '../Figures/figure_10_c.pdf');

%% Subplot 10(d): Responsiveness to signals theta_t

% Use the formula theta = (mu-pistar)/(pie - pistar)
% Get the pistar series
pistar_t(2:4) = inferred_pie(1:end-1); pistar_t(1) = 2e-2;
% Define theta series
theta_t = (mu'-pistar_t)./(inferred_pie-pistar_t);

figure(4)
hold on
plot(d, theta_t, 'LineWidth', 5)
grid on;
set(gca, 'XTick', [1968:1:1971], 'FontSize', 12)
xlabel('Year', 'FontSize', 12)
hold off
saveTightFigure(figure(4),'../Figures/figure_10_d.pdf');

%% Helper function

function saveTightFigure(h, outfilename)
    % SAVETIGHTFIGURE(H,OUTFILENAME) Saves figure H in file OUTFILENAME without
    % the white space around it. 
    %
    % by ``a grad student"
    % http://tipstrickshowtos.blogspot.com/2010/08/how-to-get-rid-of-white-margin-in.html

    % get the current axes
    ax = get(h, 'CurrentAxes');

    % adjust the papersize
    set(ax, 'units', 'centimeters');
    pos = get(ax, 'Position');
    ti = get(ax, 'TightInset');
    set(h, 'PaperUnits', 'centimeters');
    set(h, 'PaperSize', [pos(3)+ti(1)+ti(3) pos(4)+ti(2)+ti(4)]);
    set(h, 'PaperPositionMode', 'manual');
    set(h, 'PaperPosition', [0 0  pos(3)+ti(1)+ti(3) pos(4)+ti(2)+ti(4)]);

    % save it
    saveas(h, outfilename);
end