// local dir "/Users/adriencouturier/GitHub/StartInf"  // Adrien's directory
local dir "/Users/RReis/Dropbox/GitHub/StartInf"  // RR's directory
cd `dir'


* USING THE MICHIGAN TABLE 19
*********************************
use "./Data/US/michigan_moments", clear
* this is from the pdf called "expected change in prices, dist since 1960"

tsset date
drop if inf_1to2==.

g sum = inf_1to2 + inf_3to4 + inf_5 +inf_6to9 + inf_10to14 + dontknowup + downorsame + dontknow

g sumup1 = inf_1to2 + inf_3to4 +inf_5  +inf_6to9  +inf_10to14

g meanup = (1.5*inf_1to2+3.5*inf_3to4+5*inf_5+7.5*inf_6to9+12*inf_10to14)/sumup1

g mean_mich = (-2*downorsame+1.5*inf_1to2+3.5*inf_3to4+5*inf_5+7.5*inf_6to9+12*inf_10to14+meanup*dontknowup)/sum

g variance_mich = (2^2*downorsame+1.5^2*inf_1to2+3.5^2*inf_3to4+5^2*inf_5+7.5^2*inf_6to9+12^2*inf_10to14+meanup^2*dontknowup+mean_mich^2*dontknow)/sum-mean_mich^2

g E3 = (-2^3*downorsame+1.5^3*inf_1to2+3.5^3*inf_3to4+5^3*inf_5+7.5^3*inf_6to9+12^3*inf_10to14+meanup^3*dontknowup)/sum

g skewness_mich = (E3-3*mean_mich*variance-mean_mich^3)/(sqrt(variance_mich)^3)


label variable mean_mich "Mean forecast when using Michigan table"
label variable variance_mich "Variance of forecast when using Michigan table"
label variable skewness_mich "Skewness of forecast when using Michigan table"

* save

save "./Data/US/michigan_moments", replace
