********************************************************************************
* Bill Spriggs Figures
* Gaps in EPOP and AHE by educ/race/gender
* 8/27/2021
********************************************************************************

* AHE Figures
	use "./Data_cleaning/Data/cps_earnings.dta", clear
	decode(gendergroup), gen(gender_str)
	drop gendergroup
	rename gender_str gendergroup
	
	drop __*
	gen ahe_HS = ahe_all if educgroup == 1
	gen ahe_AC = ahe_all if educgroup == 2 
	gen ahe_BA = ahe_all if educgroup == 3
	gen ahe_MA = ahe_all if educgroup == 4
		
	collapse (mean) ahe_HS ahe_AC ahe_BA ahe_MA [aweight = ernwgt], by(date_ym racegroup gendergroup)
	
	foreach r in "Male" "Female" {
	preserve
		keep if gendergroup == "`r'"
		reshape wide ahe_*, i(date_ym) j(racegroup)
		export excel using "./Data_cleaning/Output/ahe_epop_by_race_gender_educ.xlsx", sheet(`"ahe_`r'"') sheetreplace firstrow(varlab)
	restore
	
	}
	
	use "./Data_cleaning/Data/cps_extract_groups.dta", clear
	decode(gendergroup), gen(gender_str)
	drop gendergroup
	rename gender_str gendergroup
	gen E_HS = E if educgroup == 1
	gen U_HS = U if educgroup == 1
	gen N_HS = N if educgroup == 1
	
	gen E_AC = E if educgroup == 2
	gen U_AC = U if educgroup == 2
	gen N_AC = N if educgroup == 2
	
	gen E_BA = E if educgroup == 3
	gen U_BA = U if educgroup == 3
	gen N_BA = N if educgroup == 3
	
	gen E_MA = E if educgroup == 4
	gen U_MA = U if educgroup == 4
	gen N_MA = N if educgroup == 4
	
	collapse (sum) E_* U_* N_*, by(date_ym racegroup gendergroup)
	
	gen epop_HS = E_HS / (E_HS + U_HS + N_HS)
	gen epop_AC = E_AC / (E_AC + U_AC + N_AC)
	gen epop_BA = E_BA / (E_BA + U_BA + N_BA)
	gen epop_MA = E_MA / (E_MA + U_MA + N_MA)
	
	drop E_* U_* N_*
	
	foreach r in "Male" "Female" {
	preserve
		keep if gendergroup == "`r'"
		reshape wide epop_HS epop_AC epop_BA epop_MA, i(date_ym) j(racegroup)
		export excel using "./Data_cleaning/Output/ahe_epop_by_race_gender_educ.xlsx", sheet(`"epop_`r'"') sheetreplace firstrow(varlab)
	restore
	}
	
	
	
