** DEMOGRAPHIC COUNTERFACTUAL EPOP RATES FOR GROUPS


foreach r in "Black" "White" "Other" "Hispanic" {
local title = strproper("`r'")

	foreach g in "$RaceCategories" {

		*Get share_base counterfactuals
		use "./Data_cleaning/Data/`g'share_White.dta", clear
		drop if missing(newid)
		
		gen base_erate = erate
		keep date_ym base_erate newid
		
		tempfile counter_erate
		save `counter_erate'
		
		*Set counterfactuals as new erate
		use "./Data_cleaning/Data/`g'share_`r'.dta", clear
		drop if missing(newid)
		
		merge 1:1 date_ym newid using `counter_erate', nogen
		xtset newid date_ym
		
		* If group's epop > white default use group's epop
		replace base_erate = erate if erate > base_erate
		

		save "./Shift_share/AGR_race_dta/`g'adj_epop_`r'", replace	

	}	

}	
