** DEMOGRAPHICALLY ADJUSTED EDUCATION RATES FOR GROUPS

foreach r in "Black" "White" "Other" "Hispanic" {
local title = strproper("`r'")

	foreach g in "$RaceCategories" {
		*Get share_base counterfactuals

		use "./Data_cleaning/Data/`g'_educ_White.dta", clear
		drop if missing(newid)
		
		gen base_share_hs = share_hs
		gen base_share_ac = share_ac
		gen base_share_ba = share_ba
		gen base_share_ma = share_ma 
		
		keep date_ym base* newid
		
		tempfile counter_educ
		save `counter_educ'
		
		*Set counterfactuals as new education
		use "./Data_cleaning/Data/`g'_educ_`r'.dta", clear
		drop if missing(newid)
		
		merge 1:1 date_ym newid using `counter_educ', nogen
		
		* If group's bachelor + master > baseline bachelor + master use group's share
		gen educ_dummy = base_share_ac + base_share_ba + base_share_ma
		replace base_share_hs = share_hs if (share_ac + share_ba + share_ma) > educ_dummy // | "`r'" != "Black"
		replace base_share_ac = share_ac if (share_ac + share_ba + share_ma) > educ_dummy // | "`r'" != "Black"
		replace base_share_ba = share_ba if (share_ac + share_ba + share_ma) > educ_dummy // | "`r'" != "Black"
		replace base_share_ma = share_ma if (share_ac + share_ba + share_ma) > educ_dummy // | "`r'" != "Black"
		
		* Merge in educ shares for each group
		merge 1:1 date_ym newid using "./Data_cleaning/Data/`g'_educAHE_`r'.dta"
		xtset newid date_ym
		
		* adjusted earnings from education 
		qui gen double ahe_adj_`g'  = ahe_hs * base_share_hs + ahe_ac * base_share_ac + ahe_ba * base_share_ba + ahe_ma * base_share_ma

		rename ahe_adj_`g' ahe_adj_e_`g'
		keep date_ym newid ahe_adj_e_`g' base_share_hs base_share_ac base_share_ba base_share_ma share_hs share_ac share_ba share_ma
		save "./Shift_share/AGR_race_dta/`g'adj_educ_`r'", replace
		
	
	}
}	

