********************************************************************************
* Program:  Creates output counterfactuals
********************************************************************************

*foreach g in "$RaceCategories" {
foreach r in "White" "Black" "Hispanic" "Other" {

	local g "agegenderrace"

	* Merge in actual earnings and hours
	use "./Data_cleaning/Data/Stata_dta/`g'ahe_`r'.dta", clear
	keep date_ym newid hr_group ahe_group
	* Merge in actual epop & lfpr & population level
	merge 1:1 date_ym newid using "./Data_cleaning/Data/Stata_dta/`g'share_`r'.dta", nogen
	*drop pop_tot
	* Merge in a,g,r employment to popoulation ratio
	merge 1:1 date_ym newid using "./Shift_share/AGR_race_dta/`g'adj_epop_`r'", nogen 
	* Merge in adjusted hours
	merge 1:1 date_ym newid using "./Shift_share/AGR_race_dta/`g'adj_hr_`r'", nogen 	
	* Merge in adjusted ahe from educ & utilization & occupation
	merge 1:1 date_ym newid using "./Shift_share/AGR_race_dta/`g'adj_ue_`r'", nogen
	
	* Merge in adjusted ahe from baseline ahe and baseline group utilization and education shares  
	merge 1:1 date_ym newid using "./Shift_share/AGR_race_dta/`g'adj_ueAHE_`r'", nogen

	* Make erate_cps from 0-1
	replace erate = erate / 100 
	replace erate_adj_`g' = base_erate / 100

	drop if date_ym == 2020 | date_ym == 2021
	save "./Projections/Data/Adjusted_orig_`g'`r'.dta",replace
	keep if date_ym == 2019
	tempfile data_2019
	save `data_2019'

forvalues i = 1/41 {
	*local count = `i'
	use `data_2019', clear
	drop tot_pop
	replace date_ym = 2019 + `i'
	merge 1:1 date_ym newid using "./Projections/Data/proj_adjustedsum_`r'.dta"
	keep if _merge == 3 
	drop _merge
	tempfile data_`i'
	save `data_`i''
}

use "./Projections/Data/Adjusted_orig_`g'`r'.dta", clear
forvalues i = 1/41 {
	append using `data_`i''
}
tempfile orig
save `orig'
drop if date_ym <= 2019
tempfile post2019
save `post2019'

use `orig'
drop if date_ym > 2019
replace group_pop = tot_pop * (share_pop / 100)
append using `post2019'
save "./Projections/Data/Adjusted_proj_`g'`r'.dta",replace

			
			gen output0_`g' = (erate * group_pop * hr_group * ahe_group) * 52
			gen output9_`g' = (erate_adj_`g' * group_pop * hrs_all_adj_`g' * ahe_adj_ue_`g') * 52
			gen output16_`g' = (erate_adj_`g' * group_pop * hrs_all_adj_`g' * ahe_adj_all_ueAHE_`g') * 52

	keep date_ym output* 
	
	save "./Projections/Output/output_counter_proj_`r'.dta", replace 
	export excel using "./Projections/Output/output_counter_proj_race_agr.xlsx", sheet(`"`r'"') sheetreplace firstrow(varlab)
	

}


* Merge AGR together and collapse to aggregate output
use "./Projections/Output/output_counter_proj_White.dta", clear 
append using "./Projections/Output/output_counter_proj_Black.dta"
append using "./Projections/Output/output_counter_proj_Hispanic.dta"
append using "./Projections/Output/output_counter_proj_Other.dta"

collapse (sum) output*, by(date_ym)


export excel using "./Projections/Output/output_counterfactual_proj_summed.xlsx", sheet("Overall") sheetreplace firstrow(varlab)



