
foreach r in "White" "Black" "Hispanic" "Other" {
	local g "agegenderrace"
	*local r "Black"

	* Merge in actual epop & lfpr & population level
	use "./Data_cleaning/Data/`g'share_`r'.dta", clear
	merge 1:1 date_ym newid using "./Shift_share/AGR_race_dta/`g'adj_epop_`r'.dta", nogen 

	gen group_pop = tot_pop * (share_pop / 100)
	replace erate_adj_`g' = base_erate / 100
	gen erate_orig = erate
	keep date_ym newid group_pop erate_adj_`g' erate_orig
	gen Enew = group_pop * erate_adj_`g'
	gen Eorig = group_pop * erate_orig/100
	keep date_ym Enew Eorig
	collapse (sum) Enew Eorig, by(date_ym)
	rename Enew Enew_`r'
	rename Eorig Eorig_`r'
	tempfile E_`r'
	save `E_`r''
}
use `E_White'
foreach r in "Black" "Hispanic" "Other" {
	merge 1:1 date_ym using `E_`r'', nogen
}
gen Enew = Enew_White + Enew_Black + Enew_Hispanic + Enew_Other
gen Eorig = Eorig_White + Eorig_Black + Eorig_Hispanic + Eorig_Other
gen Epc = (Enew - Eorig)/Eorig

save "../Misc/Elasticities/Data/Epc_epopshiftshare.dta", replace

