********************************************************************************
* Program:  Creates output counterfactuals
********************************************************************************


foreach r in "White" "Black" "Hispanic" "Other" {
	local g "agegenderrace"
	*local r "White"
	

	* Merge in actual earnings and hours
	use "./Data_cleaning/Data/Stata_dta/`g'ahe_`r'.dta", clear
	keep date_ym newid hr_group ahe_group
	* Merge in percent change in overall employment
	merge m:1 date_ym using "../Misc/Elasticities/Data/Stata_dta/Epc_epopshiftshare.dta", nogen
	* Merge in actual epop & lfpr & population level
	merge 1:1 date_ym newid using "./Data_cleaning/Data/Stata_dta/`g'share_`r'.dta", nogen
	*drop pop_tot
	* Merge in a,g,r employment to popoulation ratio
	merge 1:1 date_ym newid using "./Shift_share/AGR_race_dta/`g'adj_epop_`r'.dta", nogen 
	* Merge in adjusted hours
	merge 1:1 date_ym newid using "./Shift_share/AGR_race_dta/`g'adj_hr_`r'.dta", nogen 
	* Merge in adjusted earnings by education and utilization
	merge 1:1 date_ym newid using "./Shift_share/AGR_race_dta/`g'adj_ue_`r'.dta", nogen


	gen elastE_p8 = 1 - Epc/1.32
	gen elastE_p1 = 1 - Epc/10
	
	gen group_pop = tot_pop * (share_pop / 100)

	* Merge in adjusted ahe with baseline ahe and group edjucation shares
	merge 1:1 date_ym newid using "./Shift_share/AGR_race_dta/`g'adj_AHE_`r'.dta", nogen
	merge 1:1 date_ym newid using "./Shift_share/AGR_race_dta/`g'adj_ueAHE_`r'.dta", nogen

	* Make erate_cps from 0-1
	replace erate = erate / 100 
	replace erate_adj_`g' = base_erate / 100
	*save "./Projections/Data/Adjusted_educ_compare_`g'`r'.dta",replace	

			
			gen output0_`g'_orig = (erate * group_pop * hr_group * ahe_group) * 52

			gen output98_`g' = (erate_adj_`g' * group_pop * hrs_all_adj_`g' * ahe_adj_ue_`g' * elastE_p8) * 52
			gen output91_`g' = (erate_adj_`g' * group_pop * hrs_all_adj_`g' * ahe_adj_ue_`g' * elastE_p1) * 52
			gen output168_`g' = (erate_adj_`g' * group_pop * hrs_all_adj_`g' * ahe_adj_all_ueAHE_`g' * elastE_p8) * 52
			gen output161_`g' = (erate_adj_`g' * group_pop * hrs_all_adj_`g' * ahe_adj_all_ueAHE_`g' * elastE_p1) * 52


	keep date_ym output*
	
	save "../Misc/Elasticities/Adjusted_growth/Output/output_counter_`r'_elast.dta", replace 
	export excel using "../Misc/Elasticities/Adjusted_growth/Output/output_counter_race_agr_elast.xlsx", sheet(`"`r'"') sheetreplace firstrow(varlab)
	

}


* Merge AGR together and collapse to aggregate output
use "../Elasticities/Adjusted_growth/Output/output_counter_White_elast.dta", clear 
append using "../Elasticities/Adjusted_growth/Output/output_counter_Black_elast.dta"
append using "../Elasticities/Adjusted_growth/Output/output_counter_Hispanic_elast.dta"
append using "../Elasticities/Adjusted_growth/Output/output_counter_Other_elast.dta"

collapse (sum) output*, by(date_ym)

export excel using "../Elasticities/Adjusted_growth/Output/output_counterfactual_summed_elast.xlsx", sheet("Overall") sheetreplace firstrow(varlab)



