********************************************************************************
* Program:  Creates education shares by group for productivity growth term
********************************************************************************

foreach g in "racegender" {
	foreach r in "M" "F" {
	foreach s in "White" "Black" "Hispanic" "Other" {
	*local g "gender"
	*local r "F"
		use "./Data_cleaning/Data/cps_earnings.dta", clear
		drop if missing(`g'group)
		drop _* 
		*keep if agegroup == 1
		
		* Get group population share
		preserve 
			collapse (sum) wgtE wgtU wgtN, by(`g'group date_ym)
			
			rename wgtE wgte
			rename wgtU wgtu
			rename wgtN wgtn
			
			bys date_ym: egen pop_tot = sum(wgte) //  + wgtu + wgtn)
			gen double share_pop = 100 * (wgte) / pop_tot // + wgtu + wgtn) / pop_tot
			tempfile share_pop_`g'
			save `share_pop_`g''
		restore
		
		merge m:1 date_ym `g'group using `share_pop_`g''
		
		decode(`g'group), gen(group_str)
		gen gender_dummy = . 
		replace gender_dummy = 1 if strpos(group_str, `"`r'"')
		gen race_dummy = . 
		replace race_dummy = 1 if strpos(group_str, `"`s'"')
		keep if gender_dummy == 1 & race_dummy == 1
		
		sort date_ym `g'group
		egen newid = group(`g'group)

		gen wgt_HS = ernwgt if educgroup == 1
		gen wgt_AC = ernwgt if educgroup == 2
		gen wgt_BA = ernwgt if educgroup == 3
		gen wgt_MA = ernwgt if educgroup == 4
			
		*gen wgt_HS_underutil = ernwgt if utilgroup == 1 & educgroup == 1
 		*gen wgt_AC_underutil = ernwgt if utilgroup == 1 & educgroup == 2
		gen wgt_BA_underutil = ernwgt if utilgroup == 1 & educgroup == 3
		gen wgt_MA_underutil = ernwgt if utilgroup == 1 & educgroup == 4

		*gen wgt_HS_util = ernwgt if utilgroup == 2 & educgroup == 1
 		*gen wgt_AC_util = ernwgt if utilgroup == 2 & educgroup == 2
		gen wgt_BA_util = ernwgt if utilgroup == 2 & educgroup == 3 
		gen wgt_MA_util = ernwgt if utilgroup == 2 & educgroup == 4
		
		
		foreach i in "HS" "AC" "BA_util" "BA_underutil" "MA_util" "MA_underutil" "BA" "MA"{
			replace wgt_`i' = 0 if missing(wgt_`i') // | ernwgt < 0
		}
		
		preserve
			collapse (sum) wgt_HS wgt_AC wgt_BA wgt_MA wgt_BA_underutil wgt_BA_util wgt_MA_underutil wgt_MA_util (mean) share_pop, by(date_ym newid)
			xtset newid date_ym
			tsfill
			
			rename wgt_HS wgt_hs
			rename wgt_AC wgt_ac
			rename wgt_BA wgt_ba
			rename wgt_MA wgt_ma 
			*rename wgt_HS_underutil wgt_hs_underutil
			*rename wgt_AC_underutil wgt_ac_underutil
			rename wgt_BA_underutil wgt_ba_underutil
			rename wgt_MA_underutil wgt_ma_underutil
			*rename wgt_HS_util wgt_hs_util
			*rename wgt_AC_util wgt_ac_util
			rename wgt_BA_util wgt_ba_util
			rename wgt_MA_util wgt_ma_util 
			
			gen tmp = wgt_hs + wgt_ac + wgt_ba + wgt_ma
			gen share_hs = wgt_hs / tmp
			gen share_ac = wgt_ac / tmp 
			gen share_ba = wgt_ba / tmp
			gen share_ma = wgt_ma / tmp 
			drop tmp

			*gen share_hs_underutil = wgt_hs_underutil / (wgt_hs_underutil + wgt_hs_util)
			*gen share_ac_underutil = wgt_ac_underutil / (wgt_ac_underutil + wgt_ac_util) 
			gen share_ba_underutil = wgt_ba_underutil / (wgt_ba_underutil + wgt_ba_util)
			gen share_ma_underutil = wgt_ma_underutil / (wgt_ma_underutil + wgt_ma_util)
			*gen share_hs_util = wgt_hs_util / (wgt_hs_underutil + wgt_hs_util)
			*gen share_ac_util = wgt_ac_util / (wgt_ac_underutil + wgt_ac_util)
			gen share_ba_util = wgt_ba_util / (wgt_ba_underutil + wgt_ba_util)
			gen share_ma_util = wgt_ma_util / (wgt_ma_underutil + wgt_ma_util)
		
			save "./Data_cleaning/Data/`g'_util_`r'_`s'.dta", replace
		restore
		
		gen ahe_HS = ahe_all if educgroup == 1
		gen ahe_AC = ahe_all if educgroup == 2 
		gen ahe_BA = ahe_all if educgroup == 3
		gen ahe_MA = ahe_all if educgroup == 4
		
		*gen ahe_HS_underutil = ahe_all if educgroup == 1 & utilgroup == 1
		*gen ahe_AC_underutil = ahe_all if educgroup == 2 & utilgroup == 1
		gen ahe_BA_underutil = ahe_all if educgroup == 3 & utilgroup == 1
		gen ahe_MA_underutil = ahe_all if educgroup == 4 & utilgroup == 1

		*gen ahe_HS_util = ahe_all if educgroup == 1 & utilgroup == 2
		*gen ahe_AC_util = ahe_all if educgroup == 2 & utilgroup == 2 
		gen ahe_BA_util = ahe_all if educgroup == 3 & utilgroup == 2
		gen ahe_MA_util = ahe_all if educgroup == 4 & utilgroup == 2
		
		collapse (mean) ahe_HS ahe_AC ahe_BA ahe_MA ahe_BA_underutil ahe_BA_util ahe_MA_underutil ahe_MA_util [aweight = ernwgt], by(date_ym newid)
		
		
		rename ahe_HS ahe_hs
		rename ahe_AC ahe_ac
		rename ahe_BA ahe_ba
		rename ahe_MA ahe_ma 
		*rename ahe_HS_underutil ahe_hs_underutil
		*rename ahe_AC_underutil ahe_ac_underutil
		rename ahe_BA_underutil ahe_ba_underutil
		rename ahe_MA_underutil ahe_ma_underutil
		*rename ahe_HS_util ahe_hs_util
		*rename ahe_AC_util ahe_ac_util
		rename ahe_BA_util ahe_ba_util
		rename ahe_MA_util ahe_ma_util 
		
		replace ahe_hs = 0 if missing(ahe_hs)
		replace ahe_ac = 0 if missing(ahe_ac)
		replace ahe_ba = 0 if missing(ahe_ba)
		replace ahe_ma = 0 if missing(ahe_ma)
		
		replace ahe_ba_underutil = 0 if missing(ahe_ba_underutil)
		replace ahe_ma_underutil = 0 if missing(ahe_ma_underutil)
		replace ahe_ba_util = 0 if missing(ahe_ba_util)
		replace ahe_ma_util = 0 if missing(ahe_ma_util)
			
		save "./Data_cleaning/Data/`g'_utilAHE_`r'_`s'.dta", replace
		
		}
	}

}
